/*
 * Decompiled with CFR 0.152.
 */
package de.ponton.xp.adapter.api.internal;

import de.ponton.xp.adapter.api.AdapterStatusRequestHandler;
import de.ponton.xp.adapter.api.ConnectionException;
import de.ponton.xp.adapter.api.ErrorNotificationHandler;
import de.ponton.xp.adapter.api.MessageHandler;
import de.ponton.xp.adapter.api.OutboundMessageStatusUpdateHandler;
import de.ponton.xp.adapter.api.domainvalues.AdapterInfo;
import de.ponton.xp.adapter.api.internal.InboundWebSocketConnection;
import de.ponton.xp.adapter.api.internal.InboundWebSocketEndpoint;
import de.ponton.xp.adapter.api.internal.OnCloseListener;
import de.ponton.xp.adapter.api.internal.WebSocketConnection;
import de.ponton.xp.adapter.api.internal.WebSocketConnectionFactory;
import de.ponton.xp.adapter.api.internal.security.Signer;
import de.ponton.xp.adapter.api.internal.security.UniqueId;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.http.HttpClient;
import java.net.http.WebSocket;
import java.nio.file.Path;
import java.time.Duration;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.logging.Logger;

public class InboundWebSocketConnectionFactory
implements WebSocketConnectionFactory {
    private static final Logger LOG = Logger.getLogger(InboundWebSocketConnectionFactory.class.getName());
    private final Path inboundWorkFolder;
    private final MessageHandler messageHandler;
    private final OutboundMessageStatusUpdateHandler outboundMessageStatusUpdateHandler;
    private final ErrorNotificationHandler errorNotificationHandler;
    private final AdapterStatusRequestHandler adapterStatusRequestHandler;
    private final UniqueId uniqueId;
    private final Signer signer;
    private final AdapterInfo adapterInfo;
    private final HttpClient httpClient;
    private final String hostname;
    private final int port;

    InboundWebSocketConnectionFactory(Path inboundWorkFolder, MessageHandler messageHandler, OutboundMessageStatusUpdateHandler outboundMessageStatusUpdateHandler, ErrorNotificationHandler errorNotificationHandler, AdapterStatusRequestHandler adapterStatusRequestHandler, HttpClient httpClient, String hostname, int port, UniqueId uniqueId, Signer signer, AdapterInfo adapterInfo) {
        this.inboundWorkFolder = inboundWorkFolder;
        this.messageHandler = messageHandler;
        this.outboundMessageStatusUpdateHandler = outboundMessageStatusUpdateHandler;
        this.errorNotificationHandler = errorNotificationHandler;
        this.adapterStatusRequestHandler = adapterStatusRequestHandler;
        this.httpClient = httpClient;
        this.hostname = hostname;
        this.port = port;
        this.uniqueId = uniqueId;
        this.signer = signer;
        this.adapterInfo = adapterInfo;
    }

    @Override
    public WebSocketConnection create(OnCloseListener listener) throws ConnectionException, URISyntaxException {
        InboundWebSocketEndpoint inboundWebSocketEndpoint = new InboundWebSocketEndpoint(this.inboundWorkFolder, this.messageHandler, this.outboundMessageStatusUpdateHandler, this.errorNotificationHandler, this.adapterStatusRequestHandler, this.uniqueId, this.signer, this.adapterInfo, listener);
        WebSocket inWebSocket = this.initInbound(inboundWebSocketEndpoint);
        return new InboundWebSocketConnection(inWebSocket, inboundWebSocketEndpoint);
    }

    private WebSocket initInbound(InboundWebSocketEndpoint inboundWebSocketEndpoint) throws URISyntaxException, ConnectionException {
        WebSocket webSocket;
        URI outboundUri = new URI("wss", null, this.hostname, this.port, "/inbound", null, null);
        CompletableFuture<WebSocket> future = this.httpClient.newWebSocketBuilder().header("User-Agent", "PONTON XP Adapter API").connectTimeout(Duration.ofSeconds(10L)).buildAsync(outboundUri, inboundWebSocketEndpoint);
        LOG.fine(() -> "Waiting for websocket connect to " + String.valueOf(outboundUri));
        try {
            webSocket = future.join();
        }
        catch (CompletionException e) {
            Exception cause = this.findRootCause(e);
            throw new ConnectionException("Could not establish inbound connection (" + this.hostname + ":" + this.port + "): " + cause.getMessage(), cause);
        }
        LOG.fine(() -> "Waiting for authentication on " + String.valueOf(webSocket));
        inboundWebSocketEndpoint.waitForAuthentication();
        return webSocket;
    }

    private Exception findRootCause(Exception e) {
        if (e.getCause() instanceof Exception) {
            return this.findRootCause((Exception)e.getCause());
        }
        return e;
    }
}

