/*
 * Decompiled with CFR 0.152.
 */
package de.ponton.xp.adapter.api.internal;

import de.ponton.xp.adapter.api.AdapterStatusRequestHandler;
import de.ponton.xp.adapter.api.internal.StatusUpdateResponseEnum;
import de.ponton.xp.adapter.api.internal.messages.ProtocolAdapterStatusResponse;
import java.net.http.WebSocket;
import java.util.Objects;

public class AdapterStatusUpdateMessageHandler {
    private final AdapterStatusRequestHandler adapterStatusRequestHandler;

    AdapterStatusUpdateMessageHandler(AdapterStatusRequestHandler adapterStatusRequestHandler) {
        this.adapterStatusRequestHandler = adapterStatusRequestHandler;
    }

    public void handleOnText(WebSocket webSocket) {
        String detailText = Objects.isNull(this.adapterStatusRequestHandler) ? "adapter does not support status update" : this.adapterStatusRequestHandler.onAdapterStatusRequest();
        this.sendResponse(webSocket, detailText);
    }

    private void sendResponse(WebSocket webSocket, String detailText) {
        ProtocolAdapterStatusResponse protocolAdapterStatusResponse = ProtocolAdapterStatusResponse.createBuilder().setResult(StatusUpdateResponseEnum.SUCCESS).setDetailText(detailText).build();
        webSocket.sendText(protocolAdapterStatusResponse.toWireFormat(), true);
    }
}

