/*
 * Decompiled with CFR 0.152.
 */
package de.ponton.xp.adapter.api.domainvalues;

import java.util.Objects;

public class MessengerInstance {
    private final String hostname;
    private final int port;
    private final int inboundParallelConnections;
    private final int outboundParallelConnections;
    private final int archiveParallelConnections;

    public static MessengerInstance create(String hostname, int port) {
        return new MessengerInstance(hostname, port, 1, 1);
    }

    public static MessengerInstance create(String hostname, int port, int inboundParallelConnections, int outboundParallelConnections) {
        return new MessengerInstance(hostname, port, inboundParallelConnections, outboundParallelConnections);
    }

    public static MessengerInstance create(String hostname, int port, int inboundParallelConnections, int outboundParallelConnections, int archiveParallelConnections) {
        return new MessengerInstance(hostname, port, inboundParallelConnections, outboundParallelConnections, archiveParallelConnections);
    }

    private MessengerInstance(String hostname, int port, int inboundParallelConnections, int outboundParallelConnections) {
        this(hostname, port, inboundParallelConnections, outboundParallelConnections, 0);
    }

    private MessengerInstance(String hostname, int port, int inboundParallelConnections, int outboundParallelConnections, int archiveParallelConnections) {
        this.hostname = Objects.requireNonNull(hostname, "hostname must not be NULL");
        if (inboundParallelConnections <= 0) {
            throw new IllegalArgumentException("inboundParallelConnections should be greater than zero");
        }
        if (outboundParallelConnections <= 0) {
            throw new IllegalArgumentException("outboundParallelConnections should be greater than zero");
        }
        if (archiveParallelConnections < 0) {
            throw new IllegalArgumentException("archiveParallelConnections should be equal or greater than zero");
        }
        this.inboundParallelConnections = inboundParallelConnections;
        this.outboundParallelConnections = outboundParallelConnections;
        this.archiveParallelConnections = archiveParallelConnections;
        if (port < 1 || port > 65535) {
            throw new IllegalArgumentException(String.format("port number %d is outside of accepted range 1 - 65535", port));
        }
        this.port = port;
    }

    public String getHostname() {
        return this.hostname;
    }

    public int getPort() {
        return this.port;
    }

    public int getInboundParallelConnections() {
        return this.inboundParallelConnections;
    }

    public int getOutboundParallelConnections() {
        return this.outboundParallelConnections;
    }

    public int getArchiveParallelConnections() {
        return this.archiveParallelConnections;
    }

    public String toString() {
        return "MessengerInstance{hostname='" + this.hostname + "', port=" + this.port + ", inboundParallelConnections='" + this.inboundParallelConnections + "', outboundParallelConnections='" + this.outboundParallelConnections + "', archiveParallelConnections='" + this.archiveParallelConnections + "'}";
    }
}

