/*
 * Decompiled with CFR 0.152.
 */
package de.ponton.xp.adapter.api.domainvalues;

import de.ponton.xp.adapter.api.domainvalues.DisplayName;
import de.ponton.xp.adapter.api.domainvalues.MessageTypeName;
import de.ponton.xp.adapter.api.domainvalues.MessageTypeVersion;
import de.ponton.xp.adapter.api.domainvalues.MimeType;
import de.ponton.xp.adapter.api.domainvalues.SchemaSet;

public class MessageType {
    private final MessageTypeName messageTypeName;
    private final DisplayName displayName;
    private final MessageTypeVersion messageTypeVersion;
    private final SchemaSet schemaSet;
    private final MimeType mimeType;

    public static MessageTypeBuilder newBuilder() {
        return new MessageTypeBuilder();
    }

    private MessageType(MessageTypeName messageTypeName, DisplayName displayName, MessageTypeVersion messageTypeVersion, SchemaSet schemaSet, MimeType mimeType) {
        this.messageTypeName = messageTypeName;
        this.displayName = displayName;
        this.messageTypeVersion = messageTypeVersion;
        this.schemaSet = schemaSet;
        this.mimeType = mimeType;
    }

    public MessageTypeName getName() {
        return this.messageTypeName;
    }

    public DisplayName getDisplayName() {
        return this.displayName;
    }

    public MessageTypeVersion getVersion() {
        return this.messageTypeVersion;
    }

    public SchemaSet getSchemaSet() {
        return this.schemaSet;
    }

    public MimeType getMimeType() {
        return this.mimeType;
    }

    public String toString() {
        return "MessageType{messageTypeName=" + String.valueOf(this.messageTypeName) + ", displayName=" + String.valueOf(this.displayName) + ", messageTypeVersion=" + String.valueOf(this.messageTypeVersion) + ", schemaSet=" + String.valueOf(this.schemaSet) + ", mimeType=" + String.valueOf(this.mimeType) + "}";
    }

    public static class MessageTypeBuilder {
        private MessageTypeName messageTypeName;
        private MessageTypeVersion messageTypeVersion;
        private SchemaSet schemaSet;
        private MimeType mimeType;
        private DisplayName displayName;

        public MessageTypeBuilder setName(MessageTypeName messageTypeName) {
            this.messageTypeName = messageTypeName;
            return this;
        }

        public MessageTypeBuilder setVersion(MessageTypeVersion messageTypeVersion) {
            this.messageTypeVersion = messageTypeVersion;
            return this;
        }

        public MessageTypeBuilder setSchemaSet(SchemaSet schemaSet) {
            this.schemaSet = schemaSet;
            return this;
        }

        public MessageTypeBuilder setMimeType(MimeType mimeType) {
            this.mimeType = mimeType;
            return this;
        }

        public MessageTypeBuilder setDisplayName(DisplayName displayName) {
            this.displayName = displayName;
            return this;
        }

        public MessageType build() {
            return new MessageType(this.messageTypeName, this.displayName, this.messageTypeVersion, this.schemaSet, this.mimeType);
        }
    }
}

