/*
 * Decompiled with CFR 0.152.
 */
package de.ponton.xp.adapter.api.domainvalues;

public class AdapterInfo {
    private final String version;
    private final String id;
    private final int processingTimeout;
    private final boolean supportStatusUpdate;
    private final boolean supportErrorNotification;
    private final boolean supportInboundMessage;
    private final boolean supportArchiving;

    public static AdapterInfoBuilder newBuilder() {
        return new AdapterInfoBuilder();
    }

    private AdapterInfo(String id, String version, int processingTimeout, boolean supportStatusUpdate, boolean supportErrorNotification, boolean supportInboundMessage, boolean supportArchiving) {
        this.id = id;
        this.version = version;
        this.processingTimeout = processingTimeout;
        this.supportStatusUpdate = supportStatusUpdate;
        this.supportErrorNotification = supportErrorNotification;
        this.supportInboundMessage = supportInboundMessage;
        this.supportArchiving = supportArchiving;
    }

    public String getVersion() {
        return this.version;
    }

    public String getId() {
        return this.id;
    }

    public int getProcessingTimeout() {
        return this.processingTimeout;
    }

    public boolean isSupportStatusUpdate() {
        return this.supportStatusUpdate;
    }

    public boolean isSupportErrorNotification() {
        return this.supportErrorNotification;
    }

    public boolean isSupportInboundMessage() {
        return this.supportInboundMessage;
    }

    public boolean isSupportArchiving() {
        return this.supportArchiving;
    }

    public static class AdapterInfoBuilder {
        private String version;
        private String id;
        private int processingTimeout;
        private boolean supportStatusUpdate = true;
        private boolean supportErrorNotification = false;
        private boolean supportInboundMessage = true;
        private boolean supportArchiving = false;

        public AdapterInfo build() {
            return new AdapterInfo(this.id, this.version, this.processingTimeout, this.supportStatusUpdate, this.supportErrorNotification, this.supportInboundMessage, this.supportArchiving);
        }

        public AdapterInfoBuilder setAdapterVersion(String version) {
            this.version = version;
            return this;
        }

        public AdapterInfoBuilder setAdapterId(String id) {
            this.id = id;
            return this;
        }

        public AdapterInfoBuilder setProcessingTimeout(int processingTimeout) {
            this.processingTimeout = processingTimeout;
            return this;
        }

        public AdapterInfoBuilder setSupportStatusUpdate(boolean supportStatusUpdate) {
            this.supportStatusUpdate = supportStatusUpdate;
            return this;
        }

        public AdapterInfoBuilder setSupportErrorNotification(boolean supportErrorNotification) {
            this.supportErrorNotification = supportErrorNotification;
            return this;
        }

        public AdapterInfoBuilder setSupportInboundMessage(boolean supportInboundMessage) {
            this.supportInboundMessage = supportInboundMessage;
            return this;
        }

        public AdapterInfoBuilder setSupportArchiving(boolean supportArchiving) {
            this.supportArchiving = supportArchiving;
            return this;
        }
    }
}

