/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.model.loadbalancer;

import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.XmlTransient;
import java.util.ArrayList;
import java.util.List;
import org.apache.camel.model.LoadBalancerDefinition;
import org.apache.camel.spi.Metadata;

@Metadata(label="eip,routing")
@XmlRootElement(name="failoverLoadBalancer")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class FailoverLoadBalancerDefinition
extends LoadBalancerDefinition {
    @XmlTransient
    private List<Class<?>> exceptionTypes = new ArrayList();
    @XmlElement(name="exception")
    private List<String> exceptions = new ArrayList<String>();
    @XmlAttribute
    private String roundRobin;
    @XmlAttribute
    private String sticky;
    @XmlAttribute
    @Metadata(defaultValue="-1")
    private String maximumFailoverAttempts;

    public FailoverLoadBalancerDefinition() {
    }

    protected FailoverLoadBalancerDefinition(FailoverLoadBalancerDefinition source) {
        super(source);
        this.exceptionTypes = new ArrayList(source.exceptionTypes);
        this.exceptions = new ArrayList<String>(source.exceptions);
        this.roundRobin = source.roundRobin;
        this.sticky = source.sticky;
        this.maximumFailoverAttempts = source.maximumFailoverAttempts;
    }

    @Override
    public FailoverLoadBalancerDefinition copyDefinition() {
        return new FailoverLoadBalancerDefinition(this);
    }

    public List<String> getExceptions() {
        return this.exceptions;
    }

    public void setExceptions(List<String> exceptions) {
        this.exceptions = exceptions;
    }

    public List<Class<?>> getExceptionTypes() {
        return this.exceptionTypes;
    }

    public void setExceptionTypes(List<Class<?>> exceptionTypes) {
        this.exceptionTypes = exceptionTypes;
    }

    public String getRoundRobin() {
        return this.roundRobin;
    }

    public void setRoundRobin(String roundRobin) {
        this.roundRobin = roundRobin;
    }

    public String getSticky() {
        return this.sticky;
    }

    public void setSticky(String sticky) {
        this.sticky = sticky;
    }

    public String getMaximumFailoverAttempts() {
        return this.maximumFailoverAttempts;
    }

    public void setMaximumFailoverAttempts(String maximumFailoverAttempts) {
        this.maximumFailoverAttempts = maximumFailoverAttempts;
    }

    @Override
    public String toString() {
        return "FailoverLoadBalancer";
    }
}

