/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.saaj;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import javax.activation.DataHandler;
import javax.xml.soap.AttachmentPart;
import javax.xml.soap.MimeHeader;
import javax.xml.soap.MimeHeaders;
import javax.xml.soap.SOAPBody;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPHeader;
import javax.xml.soap.SOAPMessage;
import javax.xml.soap.SOAPPart;
import org.apache.axiom.attachments.Attachments;
import org.apache.axiom.mime.ContentType;
import org.apache.axiom.mime.Header;
import org.apache.axiom.mime.MediaType;
import org.apache.axiom.mime.Part;
import org.apache.axiom.mime.PartDataHandler;
import org.apache.axiom.om.OMException;
import org.apache.axiom.om.OMOutputFormat;
import org.apache.axiom.om.impl.OMMultipartWriter;
import org.apache.axiom.soap.SOAPEnvelope;
import org.apache.axiom.soap.SOAPFactory;
import org.apache.axiom.soap.SOAPVersion;
import org.apache.axiom.util.UIDGenerator;
import org.apache.axis2.saaj.AttachmentPartImpl;
import org.apache.axis2.saaj.SOAPEnvelopeImpl;
import org.apache.axis2.saaj.SOAPPartImpl;
import org.apache.axis2.saaj.util.SAAJUtil;

public class SOAPMessageImpl
extends SOAPMessage {
    private SOAPPart soapPart;
    private Collection<AttachmentPart> attachmentParts = new ArrayList<AttachmentPart>();
    private MimeHeaders mimeHeaders;
    private Map<String, Object> props = new Hashtable<String, Object>();
    private boolean saveRequired;

    public SOAPMessageImpl(SOAPEnvelopeImpl soapEnvelope) {
        this.mimeHeaders = new MimeHeaders();
        this.mimeHeaders.addHeader("content-type", ((SOAPFactory)((SOAPEnvelope)soapEnvelope.omTarget).getOMFactory()).getSOAPVersion().getMediaType().toString());
        this.soapPart = new SOAPPartImpl(this, soapEnvelope);
    }

    public SOAPMessageImpl(InputStream inputstream, MimeHeaders mimeHeaders, boolean processMTOM) throws SOAPException {
        String[] contentTypes;
        String contentType = null;
        String tmpContentType = "";
        if (mimeHeaders != null && (contentTypes = mimeHeaders.getHeader("Content-Type")) != null && contentTypes.length > 0) {
            tmpContentType = contentTypes[0];
            contentType = SAAJUtil.normalizeContentType(tmpContentType);
        }
        if ("multipart/related".equals(contentType)) {
            try {
                Attachments attachments = new Attachments(inputstream, tmpContentType, true, System.getProperty("java.io.tmpdir"), "");
                String soapPartContentId = attachments.getRootPartContentID();
                for (String contentId : attachments.getAllContentIDs()) {
                    Part part;
                    DataHandler dataHandler = attachments.getDataHandler(contentId);
                    if (contentId.equals(soapPartContentId)) {
                        MimeHeaders soapPartHeaders = new MimeHeaders();
                        if (dataHandler instanceof PartDataHandler) {
                            part = ((PartDataHandler)dataHandler).getPart();
                            part.getHeaders().forEach(header -> soapPartHeaders.addHeader(header.getName(), header.getValue()));
                        } else {
                            soapPartHeaders.addHeader("Content-Type", attachments.getRootPartContentType());
                            soapPartHeaders.addHeader("Content-ID", "<" + soapPartContentId + ">");
                        }
                        this.soapPart = new SOAPPartImpl(this, attachments.getRootPartInputStream(), soapPartHeaders, (Attachments)(processMTOM ? attachments : null));
                        continue;
                    }
                    AttachmentPart ap = this.createAttachmentPart(dataHandler);
                    if (dataHandler instanceof PartDataHandler) {
                        ap.removeAllMimeHeaders();
                        part = ((PartDataHandler)dataHandler).getPart();
                        part.getHeaders().forEach(header -> ap.addMimeHeader(header.getName(), header.getValue()));
                    } else {
                        ap.setContentId("<" + contentId + ">");
                    }
                    this.attachmentParts.add(ap);
                }
            }
            catch (OMException e) {
                throw new SOAPException((Throwable)e);
            }
        } else {
            this.initCharsetEncodingFromContentType(tmpContentType);
            this.soapPart = new SOAPPartImpl(this, inputstream, mimeHeaders, null);
        }
        this.mimeHeaders = mimeHeaders == null ? new MimeHeaders() : SAAJUtil.copyMimeHeaders(mimeHeaders);
    }

    public String getContentDescription() {
        String[] values = this.mimeHeaders.getHeader("Content-Description");
        if (values != null && values.length > 0) {
            return values[0];
        }
        return null;
    }

    public void setContentDescription(String description) {
        this.mimeHeaders.setHeader("Content-Description", description);
    }

    public SOAPPart getSOAPPart() {
        return this.soapPart;
    }

    public void removeAllAttachments() {
        this.attachmentParts.clear();
        this.saveRequired = true;
    }

    public int countAttachments() {
        return this.attachmentParts.size();
    }

    public Iterator getAttachments() {
        return this.attachmentParts.iterator();
    }

    public Iterator getAttachments(MimeHeaders headers) {
        ArrayList<AttachmentPartImpl> matchingAttachmentParts = new ArrayList<AttachmentPartImpl>();
        Iterator iterator = this.getAttachments();
        while (iterator.hasNext()) {
            AttachmentPartImpl part = (AttachmentPartImpl)((Object)iterator.next());
            if (!part.matches(headers)) continue;
            matchingAttachmentParts.add(part);
        }
        return matchingAttachmentParts.iterator();
    }

    public void addAttachmentPart(AttachmentPart attachmentPart) {
        if (attachmentPart != null) {
            this.attachmentParts.add(attachmentPart);
            this.mimeHeaders.setHeader("Content-Type", "multipart/related");
            this.saveRequired = true;
        }
    }

    public AttachmentPart createAttachmentPart() {
        return new AttachmentPartImpl();
    }

    public MimeHeaders getMimeHeaders() {
        return this.mimeHeaders;
    }

    public void saveChanges() throws SOAPException {
        try {
            ContentType.Builder contentType;
            String contentTypeValue = this.getSingleHeaderValue("Content-Type");
            if (this.isEmptyString(contentTypeValue)) {
                contentType = ContentType.builder().setMediaType(this.attachmentParts.size() > 0 ? MediaType.MULTIPART_RELATED : this.getMediaType());
            } else {
                contentType = new ContentType(contentTypeValue).toBuilder();
                if (contentType.getMediaType().equals((Object)MediaType.MULTIPART_RELATED) && this.attachmentParts.size() == 0) {
                    contentType.setMediaType(this.getMediaType());
                    contentType.clearParameters();
                }
            }
            if (contentType.getMediaType().equals((Object)MediaType.MULTIPART_RELATED)) {
                String soapPartContentId;
                String boundaryParam = contentType.getParameter("boundary");
                if (this.isEmptyString(boundaryParam)) {
                    contentType.setParameter("boundary", UIDGenerator.generateMimeBoundary());
                }
                if (this.isEmptyString(soapPartContentId = this.soapPart.getContentId())) {
                    soapPartContentId = "<" + UIDGenerator.generateContentId() + ">";
                    this.soapPart.setContentId(soapPartContentId);
                }
                contentType.setParameter("start", soapPartContentId);
                for (AttachmentPart attachmentPart : this.attachmentParts) {
                    if (!this.isEmptyString(attachmentPart.getContentId())) continue;
                    attachmentPart.setContentId("<" + UIDGenerator.generateContentId() + ">");
                }
                contentType.setParameter("type", this.getMediaType().toString());
                String soapPartContentTypeValue = this.getSingleHeaderValue(this.soapPart.getMimeHeader("Content-Type"));
                ContentType.Builder soapPartContentType = this.isEmptyString(soapPartContentTypeValue) ? new ContentType(soapPartContentTypeValue).toBuilder() : ContentType.builder().setMediaType(this.getMediaType());
                this.setCharsetParameter(soapPartContentType);
            } else {
                this.setCharsetParameter(contentType);
            }
            this.mimeHeaders.setHeader("Content-Type", contentType.build().toString());
        }
        catch (ParseException e) {
            throw new SOAPException("Invalid Content Type Field in the Mime Message", (Throwable)e);
        }
        this.saveRequired = false;
    }

    public void setSaveRequired() {
        this.saveRequired = true;
    }

    public boolean saveRequired() {
        return this.saveRequired;
    }

    public void writeTo(OutputStream out) throws SOAPException, IOException {
        try {
            this.saveChanges();
            OMOutputFormat format = new OMOutputFormat();
            String[] encoding = this.getSOAPPart().getMimeHeader("Content-Transfer-Encoding");
            boolean base64 = encoding != null && encoding.length > 0 && encoding[0].equalsIgnoreCase("base64");
            String enc = (String)this.getProperty("javax.xml.soap.character-set-encoding");
            format.setCharSetEncoding(enc != null ? enc : "utf-8");
            String writeXmlDecl = (String)this.getProperty("javax.xml.soap.write-xml-declaration");
            if (writeXmlDecl == null || writeXmlDecl.equals("false")) {
                format.setIgnoreXMLDeclaration(true);
            }
            SOAPEnvelope envelope = (SOAPEnvelope)((SOAPEnvelopeImpl)this.soapPart.getEnvelope()).getOMTarget();
            if (this.attachmentParts.isEmpty()) {
                envelope.serialize(out, format);
            } else {
                ContentType.Builder contentType = new ContentType(this.getSingleHeaderValue("Content-Type")).toBuilder();
                String boundary = contentType.getParameter("boundary");
                if (this.isEmptyString(boundary)) {
                    boundary = UIDGenerator.generateMimeBoundary();
                    contentType.setParameter("boundary", boundary);
                }
                format.setMimeBoundary(boundary);
                String rootContentId = this.soapPart.getContentId();
                if (this.isEmptyString(rootContentId)) {
                    rootContentId = "<" + UIDGenerator.generateContentId() + ">";
                    this.soapPart.setContentId(rootContentId);
                }
                contentType.setParameter("start", rootContentId);
                if (rootContentId.indexOf("<") > -1 & rootContentId.indexOf(">") > -1) {
                    rootContentId = rootContentId.substring(1, rootContentId.length() - 1);
                }
                format.setRootContentId(rootContentId);
                format.setSOAP11(((SOAPFactory)((SOAPEnvelope)((SOAPEnvelopeImpl)this.soapPart.getEnvelope()).omTarget).getOMFactory()).getSOAPVersion() == SOAPVersion.SOAP11);
                this.mimeHeaders.setHeader("Content-Type", contentType.build().toString());
                OMMultipartWriter mpw = new OMMultipartWriter(out, format, base64);
                OutputStream rootPartOutputStream = mpw.writeRootPart();
                envelope.serialize(rootPartOutputStream);
                rootPartOutputStream.close();
                HashSet<String> knownMimeHeaders = new HashSet<String>(3);
                knownMimeHeaders.add("Content-Type".toLowerCase());
                knownMimeHeaders.add("Content-Transfer-Encoding".toLowerCase());
                knownMimeHeaders.add("Content-Id".toLowerCase());
                for (AttachmentPart ap : this.attachmentParts) {
                    ArrayList extraHeaders = new ArrayList();
                    ap.getAllMimeHeaders().forEachRemaining(mimeHeader -> {
                        if (!knownMimeHeaders.contains(mimeHeader.getName().toLowerCase())) {
                            extraHeaders.add(new Header(mimeHeader.getName(), mimeHeader.getValue()));
                        }
                    });
                    mpw.writePart(ap.getDataHandler(), ap.getContentId(), extraHeaders);
                }
                mpw.complete();
            }
            this.saveRequired = true;
        }
        catch (Exception e) {
            throw new SOAPException((Throwable)e);
        }
    }

    public void setProperty(String property, Object value) {
        this.props.put(property, value);
    }

    public Object getProperty(String property) throws SOAPException {
        return this.props.get(property);
    }

    public AttachmentPart getAttachment(SOAPElement soapelement) throws SOAPException {
        Iterator iterator = this.getAttachments();
        while (iterator.hasNext()) {
            AttachmentPartImpl attachmentPart = (AttachmentPartImpl)((Object)iterator.next());
            String[] contentIds = attachmentPart.getMimeHeader("Content-Id");
            String reference = soapelement.getAttribute("href");
            if (!(reference != null && reference.trim().length() != 0 || (reference = soapelement.getValue()) != null && reference.trim().length() != 0)) {
                return null;
            }
            for (int a = 0; a < contentIds.length; ++a) {
                String idPart = reference.substring(reference.indexOf(":") + 1);
                idPart = "<" + idPart + ">";
                if (!idPart.equals(contentIds[a])) continue;
                return attachmentPart;
            }
            String[] contentLocations = attachmentPart.getMimeHeader("Content-Location");
            if (contentLocations == null) continue;
            for (int b = 0; b < contentLocations.length; ++b) {
                if (!reference.equals(contentLocations[b])) continue;
                return attachmentPart;
            }
        }
        return null;
    }

    public void removeAttachments(MimeHeaders headers) {
        ArrayList<AttachmentPart> newAttachmentParts = new ArrayList<AttachmentPart>();
        for (AttachmentPart attachmentPart : this.attachmentParts) {
            Iterator iterator = headers.getAllHeaders();
            while (iterator.hasNext()) {
                MimeHeader mimeHeader = (MimeHeader)iterator.next();
                String[] headerValues = attachmentPart.getMimeHeader(mimeHeader.getName());
                if (headerValues.length == 0 || headerValues[0].equals(mimeHeader.getValue())) continue;
                newAttachmentParts.add(attachmentPart);
            }
        }
        this.attachmentParts.clear();
        this.attachmentParts = newAttachmentParts;
        this.saveRequired = true;
    }

    public SOAPHeader getSOAPHeader() throws SOAPException {
        return this.soapPart.getEnvelope().getHeader();
    }

    public SOAPBody getSOAPBody() throws SOAPException {
        return this.soapPart.getEnvelope().getBody();
    }

    private void initCharsetEncodingFromContentType(String contentType) {
        int delimiterIndex;
        if (contentType != null && (delimiterIndex = contentType.lastIndexOf("charset")) > 0) {
            int index;
            int charsetIndex;
            String charsetPart = contentType.substring(delimiterIndex);
            String charset = charsetPart.substring((charsetIndex = charsetPart.indexOf(61)) + 1).trim();
            if (charset.startsWith("\"") || charset.startsWith("'")) {
                charset = charset.substring(1, charset.length());
            }
            if (charset.endsWith("\"") || charset.endsWith("'")) {
                charset = charset.substring(0, charset.length() - 1);
            }
            if ((index = charset.indexOf(59)) != -1) {
                charset = charset.substring(0, index);
            }
            this.setProperty("javax.xml.soap.character-set-encoding", charset);
        }
    }

    private boolean isEmptyString(String value) {
        return value == null || value.length() == 0;
    }

    private String getSingleHeaderValue(String[] values) {
        return values != null && values.length > 0 ? values[0] : null;
    }

    private String getSingleHeaderValue(String name) {
        String[] values = this.mimeHeaders.getHeader(name);
        if (values == null || values.length == 0) {
            return null;
        }
        return values[0];
    }

    private MediaType getMediaType() throws SOAPException {
        return ((SOAPFactory)((SOAPEnvelope)((SOAPEnvelopeImpl)this.soapPart.getEnvelope()).omTarget).getOMFactory()).getSOAPVersion().getMediaType();
    }

    private void setCharsetParameter(ContentType.Builder contentType) throws SOAPException {
        String charset = (String)this.getProperty("javax.xml.soap.character-set-encoding");
        if (!this.isEmptyString(charset)) {
            contentType.setParameter("charset", charset);
        } else {
            charset = contentType.getParameter("charset");
            if (this.isEmptyString(charset)) {
                contentType.setParameter("charset", "UTF-8");
            }
        }
    }
}

