/*
 * Decompiled with CFR 0.152.
 */
package de.pontonconsulting.xmlpipe.velocity;

import de.pontonconsulting.xmlpipe.config.ConfigResourceService;
import de.pontonconsulting.xmlpipe.velocity.SpringResourceLoader;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.velocity.app.VelocityEngine;
import org.apache.velocity.exception.VelocityException;
import org.springframework.core.io.DefaultResourceLoader;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;
import org.springframework.core.io.support.PropertiesLoaderUtils;
import org.springframework.util.CollectionUtils;

public class VelocityEngineFactory {
    protected final Logger logger = LogManager.getLogger(this.getClass());
    private Resource configLocation;
    private final Map<String, Object> velocityProperties = new HashMap<String, Object>();
    private String resourceLoaderPath;
    private ResourceLoader resourceLoader = new DefaultResourceLoader();
    private boolean preferFileSystemAccess = true;
    private boolean overrideLogging = true;
    private final ConfigResourceService configResourceService;

    public VelocityEngineFactory(ConfigResourceService configResourceService) {
        this.configResourceService = configResourceService;
    }

    public void setConfigLocation(Resource configLocation) {
        this.configLocation = configLocation;
    }

    public void setVelocityProperties(Properties velocityProperties) {
        CollectionUtils.mergePropertiesIntoMap((Properties)velocityProperties, this.velocityProperties);
    }

    public void setVelocityPropertiesMap(Map<String, Object> velocityPropertiesMap) {
        if (velocityPropertiesMap != null) {
            this.velocityProperties.putAll(velocityPropertiesMap);
        }
    }

    public void setResourceLoaderPath(String resourceLoaderPath) {
        this.resourceLoaderPath = resourceLoaderPath;
    }

    public void setResourceLoader(ResourceLoader resourceLoader) {
        this.resourceLoader = resourceLoader;
    }

    protected ResourceLoader getResourceLoader() {
        return this.resourceLoader;
    }

    public void setPreferFileSystemAccess(boolean preferFileSystemAccess) {
        this.preferFileSystemAccess = preferFileSystemAccess;
    }

    protected boolean isPreferFileSystemAccess() {
        return this.preferFileSystemAccess;
    }

    public void setOverrideLogging(boolean overrideLogging) {
        this.overrideLogging = overrideLogging;
    }

    public VelocityEngine createVelocityEngine() throws IOException, VelocityException {
        VelocityEngine velocityEngine = this.newVelocityEngine();
        HashMap<String, Object> props = new HashMap<String, Object>();
        if (this.configLocation != null) {
            if (this.logger.isInfoEnabled()) {
                this.logger.info("Loading Velocity config from [" + String.valueOf(this.configLocation) + "]");
            }
            CollectionUtils.mergePropertiesIntoMap((Properties)PropertiesLoaderUtils.loadProperties((Resource)this.configLocation), props);
        }
        if (!this.velocityProperties.isEmpty()) {
            props.putAll(this.velocityProperties);
        }
        this.initVelocityResourceLoader(velocityEngine);
        if (this.overrideLogging) {
            velocityEngine.setProperty("runtime.log.name", (Object)this.logger.getName());
        }
        for (Map.Entry entry : props.entrySet()) {
            velocityEngine.setProperty((String)entry.getKey(), entry.getValue());
        }
        this.postProcessVelocityEngine(velocityEngine);
        velocityEngine.init();
        return velocityEngine;
    }

    protected VelocityEngine newVelocityEngine() throws IOException, VelocityException {
        return new VelocityEngine();
    }

    protected void initVelocityResourceLoader(VelocityEngine velocityEngine) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("File system access not preferred: using SpringResourceLoader");
        }
        this.initSpringResourceLoader(velocityEngine, this.resourceLoaderPath);
    }

    protected void initSpringResourceLoader(VelocityEngine velocityEngine, String resourceLoaderPath) {
        velocityEngine.setProperty("resource.loader", (Object)"spring");
        velocityEngine.setProperty("spring.resource.loader.class", (Object)SpringResourceLoader.class.getName());
        velocityEngine.setProperty("spring.resource.loader.configResourceService", (Object)this.configResourceService);
        velocityEngine.setApplicationAttribute((Object)"spring.resource.loader", (Object)this.getResourceLoader());
        velocityEngine.setApplicationAttribute((Object)"spring.resource.loader.path", (Object)resourceLoaderPath);
    }

    protected void postProcessVelocityEngine(VelocityEngine velocityEngine) throws IOException, VelocityException {
    }
}

