/*
 * Decompiled with CFR 0.152.
 */
package de.pontonconsulting.xmlpipe.util.spring;

import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpSession;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.core.session.SessionRegistry;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.util.Assert;

public class SessionUtils {
    private static final Log logger = LogFactory.getLog(SessionUtils.class);

    SessionUtils() {
    }

    public static void startNewSessionIfRequired(HttpServletRequest request, boolean migrateAttributes, SessionRegistry sessionRegistry) {
        HttpSession session = request.getSession(false);
        if (session == null) {
            return;
        }
        String originalSessionId = session.getId();
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Invalidating session with Id '" + originalSessionId + "' " + (migrateAttributes ? "and" : "without") + " migrating attributes."));
        }
        HashMap<String, Object> attributesToMigrate = null;
        if (migrateAttributes) {
            attributesToMigrate = new HashMap<String, Object>();
            Enumeration enumer = session.getAttributeNames();
            while (enumer.hasMoreElements()) {
                String key = (String)enumer.nextElement();
                attributesToMigrate.put(key, session.getAttribute(key));
            }
        }
        session.invalidate();
        session = request.getSession(true);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Started new session: " + session.getId()));
        }
        if (attributesToMigrate != null) {
            for (Map.Entry entry : attributesToMigrate.entrySet()) {
                session.setAttribute((String)entry.getKey(), entry.getValue());
            }
        }
        if (sessionRegistry != null) {
            sessionRegistry.removeSessionInformation(originalSessionId);
            Object principal = SessionUtils.obtainPrincipalFromAuthentication(SecurityContextHolder.getContext().getAuthentication());
            sessionRegistry.registerNewSession(session.getId(), principal);
        }
    }

    private static Object obtainPrincipalFromAuthentication(Authentication auth) {
        Assert.notNull((Object)auth, (String)"Authentication required");
        Assert.notNull((Object)auth.getPrincipal(), (String)"Authentication.getPrincipal() required");
        if (auth.getPrincipal() instanceof UserDetails) {
            return ((UserDetails)auth.getPrincipal()).getUsername();
        }
        return auth.getPrincipal();
    }
}

