/*
 * Decompiled with CFR 0.152.
 */
package de.pontonconsulting.xmlpipe.util;

import de.pontonconsulting.xmlpipe.util.IOUtil;
import java.io.BufferedInputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.PosixFileAttributeView;
import java.nio.file.attribute.PosixFilePermission;
import java.util.Set;
import org.apache.commons.compress.archivers.zip.ZipArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipArchiveOutputStream;
import org.apache.commons.io.IOUtils;

public class ZipCreatorFileVisitor
implements FileVisitor<Path> {
    private static final String UNIX_PATH_SEPARATOR = "/";
    private static final String REGEX_WINDOWS_PATH_SEPARATOR = "\\\\";
    private static final int DEFAULT_FILE_UNIX_MODE = 493;
    private final Path toZipPath;
    private final Path zipFilePath;
    private ZipArchiveOutputStream zipOutputStream;
    private final String prefix;

    public ZipCreatorFileVisitor(Path toZipPath, Path zipFilePath) {
        this.toZipPath = toZipPath.normalize();
        this.prefix = String.valueOf(toZipPath.getFileName()) + UNIX_PATH_SEPARATOR;
        if (!Files.isDirectory(toZipPath, new LinkOption[0])) {
            throw new IllegalArgumentException("ToZipPath must be a directory.");
        }
        this.zipFilePath = zipFilePath;
    }

    @Override
    public FileVisitResult preVisitDirectory(Path dirPath, BasicFileAttributes attrs) throws IOException {
        if (this.toZipPath.equals(dirPath.normalize())) {
            this.zipOutputStream = new ZipArchiveOutputStream(Files.newOutputStream(this.zipFilePath, new OpenOption[0]));
        }
        String entryName = this.buildEntryName(dirPath, true);
        ZipArchiveEntry outputJarEntry = new ZipArchiveEntry(entryName);
        this.zipOutputStream.putArchiveEntry(outputJarEntry);
        outputJarEntry.setLastModifiedTime(Files.getLastModifiedTime(dirPath, new LinkOption[0]));
        outputJarEntry.setUnixMode(this.determineUnixMode(dirPath));
        this.zipOutputStream.closeArchiveEntry();
        return FileVisitResult.CONTINUE;
    }

    @Override
    public FileVisitResult visitFile(Path filePath, BasicFileAttributes attrs) throws IOException {
        String entryName = this.buildEntryName(filePath, false);
        ZipArchiveEntry outputJarEntry = new ZipArchiveEntry(entryName);
        this.zipOutputStream.putArchiveEntry(outputJarEntry);
        outputJarEntry.setSize(Files.size(filePath));
        outputJarEntry.setLastModifiedTime(Files.getLastModifiedTime(filePath, new LinkOption[0]));
        outputJarEntry.setUnixMode(this.determineUnixMode(filePath));
        try (BufferedInputStream sourceInputStream = new BufferedInputStream(Files.newInputStream(filePath, new OpenOption[0]));){
            IOUtils.copy((InputStream)sourceInputStream, (OutputStream)this.zipOutputStream);
        }
        this.zipOutputStream.closeArchiveEntry();
        return FileVisitResult.CONTINUE;
    }

    @Override
    public FileVisitResult visitFileFailed(Path filePath, IOException exc) throws IOException {
        return FileVisitResult.TERMINATE;
    }

    @Override
    public FileVisitResult postVisitDirectory(Path dirPath, IOException exc) throws IOException {
        if (exc == null) {
            if (this.toZipPath.equals(dirPath.normalize())) {
                IOUtil.closeStreamQuietly((Closeable)this.zipOutputStream);
            }
            return FileVisitResult.CONTINUE;
        }
        IOUtil.closeStreamQuietly((Closeable)this.zipOutputStream);
        throw exc;
    }

    private int determineUnixMode(Path path) throws IOException {
        if (this.supportPOSIX(path)) {
            Set<PosixFilePermission> posixFilePermissions = Files.getPosixFilePermissions(path, new LinkOption[0]);
            return this.toMode(posixFilePermissions);
        }
        return 493;
    }

    private boolean supportPOSIX(Path path) {
        PosixFileAttributeView posixView = Files.getFileAttributeView(path, PosixFileAttributeView.class, new LinkOption[0]);
        return posixView != null;
    }

    private int toMode(Set<PosixFilePermission> permissions) {
        int unixMode = 0;
        for (PosixFilePermission posixFilePermission : permissions) {
            unixMode += this.permissionToInt(posixFilePermission);
        }
        String octalUnixMode = "0" + String.valueOf(unixMode);
        switch (octalUnixMode.length()) {
            case 1: {
                octalUnixMode = "0" + octalUnixMode;
                break;
            }
            case 2: {
                octalUnixMode = "0" + octalUnixMode;
                break;
            }
            case 3: {
                octalUnixMode = "0" + octalUnixMode;
            }
        }
        unixMode = Integer.parseInt(octalUnixMode, 8);
        return unixMode;
    }

    private int permissionToInt(PosixFilePermission permission) {
        switch (permission) {
            case OWNER_EXECUTE: {
                return 100;
            }
            case GROUP_EXECUTE: {
                return 10;
            }
            case OTHERS_EXECUTE: {
                return 1;
            }
            case OWNER_WRITE: {
                return 200;
            }
            case GROUP_WRITE: {
                return 20;
            }
            case OTHERS_WRITE: {
                return 2;
            }
            case OWNER_READ: {
                return 400;
            }
            case GROUP_READ: {
                return 40;
            }
            case OTHERS_READ: {
                return 4;
            }
        }
        return 0;
    }

    private String buildEntryName(Path path, boolean isDirectory) {
        String entryName = this.prefix + this.getNormalizedPath(this.toZipPath.relativize(path.normalize()));
        if (isDirectory && !entryName.endsWith(UNIX_PATH_SEPARATOR)) {
            entryName = entryName + UNIX_PATH_SEPARATOR;
        }
        return entryName;
    }

    private String getNormalizedPath(Path path) {
        return path.toString().replaceAll(REGEX_WINDOWS_PATH_SEPARATOR, UNIX_PATH_SEPARATOR);
    }
}

