/*
 * Decompiled with CFR 0.152.
 */
package de.pontonconsulting.xmlpipe.uioption;

import de.pontonconsulting.xmlpipe.cp.Option;
import de.pontonconsulting.xmlpipe.cpa.Communication;
import de.pontonconsulting.xmlpipe.messenger.IPipelineFactory;
import de.pontonconsulting.xmlpipe.messenger.packaging.IPackagingManager;
import de.pontonconsulting.xmlpipe.uioption.UIOption;
import jakarta.annotation.PostConstruct;
import java.util.Map;
import java.util.TreeMap;

public class UIOptionFinder {
    public static final String PACKAGING = "packaging";
    public static final String PROCESSING = "processing";
    private final IPipelineFactory _pipelineFactory;
    private final IPackagingManager _packagingManager;
    private static Map<String, UIOption> _packagingOptions = new TreeMap<String, UIOption>();
    private static Map<String, UIOption> _pipelineOptions = new TreeMap<String, UIOption>();

    public UIOptionFinder(IPipelineFactory pipelineFactory, IPackagingManager packagingManager) {
        this._pipelineFactory = pipelineFactory;
        this._packagingManager = packagingManager;
    }

    @PostConstruct
    public void initialize() {
        int i;
        UIOption[] uiOptions;
        for (String packagingId : this._packagingManager.getPackagingIds()) {
            uiOptions = this._packagingManager.getPackagingOptions(packagingId);
            for (i = 0; i < uiOptions.length; ++i) {
                _packagingOptions.put(packagingId + "_" + uiOptions[i].getOptionPath(), uiOptions[i]);
            }
        }
        for (String pipelineIds : this._pipelineFactory.getPipelineIds()) {
            uiOptions = this._pipelineFactory.getPipelineOptions(pipelineIds);
            for (i = 0; i < uiOptions.length; ++i) {
                _pipelineOptions.put(pipelineIds + "_" + uiOptions[i].getOptionPath(), uiOptions[i]);
            }
        }
    }

    public static String getUIOptionName(String optionType, String id, Option option) {
        return UIOptionFinder.getUIOption(optionType, id, option).getName();
    }

    public static UIOption getUIOption(String optionType, String id, Option option) {
        return UIOptionFinder.getUIOption(optionType, id, option.getPath());
    }

    public static UIOption getUIOption(String optionSort, String id, String optionPath) {
        UIOption uiOption = null;
        String defaultOptionPath = UIOptionFinder.determineDefaultOptionPath(optionSort, optionPath);
        if (PACKAGING.equals(optionSort)) {
            uiOption = UIOptionFinder.getUIOption(_packagingOptions, defaultOptionPath, id);
        } else if (PROCESSING.equals(optionSort)) {
            uiOption = UIOptionFinder.getUIOption(_pipelineOptions, defaultOptionPath, id);
        }
        return uiOption;
    }

    public static String determineDefaultOptionPath(String optionSort, String optionPath) {
        if (PACKAGING.equals(optionSort)) {
            return optionPath;
        }
        if (PROCESSING.equals(optionSort)) {
            return Communication.determinePipelineDefaultOptionPath(optionPath);
        }
        return optionPath;
    }

    private static UIOption getUIOption(Map<String, UIOption> map, String optionPath, String id) {
        return map.get(id + "_" + optionPath);
    }
}

