/*
 * Decompiled with CFR 0.152.
 */
package de.pontonconsulting.xmlpipe.uioption;

import de.pontonconsulting.xmlpipe.cp.Option;
import de.pontonconsulting.xmlpipe.cpa.Communication;
import de.pontonconsulting.xmlpipe.cpp.CppPartner;
import de.pontonconsulting.xmlpipe.uioption.UIOptionFinder;
import java.util.Arrays;

public class UIOption
implements Cloneable {
    public static final String LIST_VALUES_SEPARATOR = ",";
    public static final Integer SENDER = 3;
    public static final Integer RECEIVER = 4;
    public static final Integer BOTH_PARTNERS = 5;
    public static final Integer NONE = 0;
    public static final String CERT_MODE_NONE = "none";
    public static final String CERT_MODE_SENDER = "senderCertificate";
    public static final String CERT_MODE_RECEIVER = "receiverCertificate";
    protected String _path = null;
    protected String _selectedValue = null;
    protected String _values = null;
    protected String _type = null;
    protected String _name = null;
    protected String _help = null;
    protected String _helpHeader = null;
    protected String _profileHelpText = null;
    protected String _agreementHelpText = null;
    protected boolean _activeOption = false;
    protected boolean _canOnlyExistsInProfile = true;
    protected Integer _dependence = BOTH_PARTNERS;
    protected boolean _standard_active = true;
    protected String _certMode = "none";
    protected String _certRefId = "default";
    protected boolean _certSupported = true;
    protected boolean _supported = true;
    protected boolean _uptodate = true;
    protected String[] _commonValues = new String[0];
    protected boolean _listValueSupported = true;
    protected boolean _isEmptyValueAllowed = false;
    private String _toolTip = "";
    private int _level = -1;
    private int _paddingLeft = 0;
    private String _defaultValue = null;
    private boolean _visible = true;
    private VISIBILITY _visibility = VISIBILITY.BOTH;

    public UIOption() {
    }

    protected UIOption(String path) {
        this._path = path;
        this.calculateOptionLevel();
    }

    protected UIOption(String path, String help, String helpHeader, String agreementHelpText) {
        this(path);
        this._help = help;
        this._helpHeader = helpHeader;
        this._agreementHelpText = agreementHelpText;
    }

    protected UIOption(String path, String help, String helpHeader, String agreementHelpText, String profileHelpText) {
        this(path, help, helpHeader, agreementHelpText);
        this._profileHelpText = profileHelpText;
    }

    protected UIOption(String nameKey, String optionPath, String optionType, String values, String help, String helpHeader, String agreementHelpText) {
        this(optionPath, help, helpHeader, agreementHelpText);
        this._name = nameKey;
        this._path = optionPath;
        this._type = optionType;
        this._values = values;
        if ("string".equals(this._type)) {
            this._defaultValue = values;
        }
        this.sortValues();
    }

    protected UIOption(String nameKey, String optionPath, String optionType, String values, String help, String helpHeader, String agreementHelpText, String profileHelpText) {
        this(nameKey, optionPath, optionType, values, help, helpHeader, agreementHelpText);
        this._profileHelpText = profileHelpText;
    }

    public UIOption(String nameKey, String optionPath, String optionType, String values, String help, String helpHeader, String agreementHelpText, String profileHelpText, Integer dependence) {
        this(nameKey, optionPath, optionType, values, help, helpHeader, agreementHelpText, profileHelpText);
        this._dependence = dependence;
    }

    public UIOption(String nameKey, String optionPath, String optionType, String values, String help, String helpHeader, String agreementHelpText, String profileHelpText, Integer dependence, boolean standardActive) {
        this(nameKey, optionPath, optionType, values, help, helpHeader, agreementHelpText, profileHelpText, dependence);
        this._standard_active = standardActive;
    }

    public UIOption(String nameKey, String optionPath, String optionType, String values, String help, String helpHeader, String agreementHelpText, String profileHelpText, Integer dependence, boolean standardActive, boolean isEmptyValueAllowed) {
        this(nameKey, optionPath, optionType, values, help, helpHeader, agreementHelpText, profileHelpText, dependence, standardActive);
        this._isEmptyValueAllowed = isEmptyValueAllowed;
    }

    public UIOption(String nameKey, String optionPath, String optionType, String values, String help, String helpHeader, String agreementHelpText, String profileHelpText, Integer dependence, String defaultValue) {
        this(nameKey, optionPath, optionType, values, help, helpHeader, agreementHelpText, profileHelpText, dependence);
        this._defaultValue = defaultValue;
    }

    public UIOption(String nameKey, String optionPath, String optionType, String values, String help, String helpHeader, String agreementHelpText, String profileHelpText, Integer dependence, String defaultValue, String certMode) {
        this(nameKey, optionPath, optionType, values, help, helpHeader, agreementHelpText, profileHelpText, dependence, defaultValue);
        this._certMode = certMode;
    }

    public boolean getStandardActive() {
        return this._standard_active;
    }

    public void setStandardActive(boolean standardActive) {
        this._standard_active = standardActive;
    }

    public Integer getDependence() {
        return this._dependence;
    }

    public void setDependence(Integer dependence) {
        this._dependence = dependence;
    }

    public String getHelpHeader() {
        return this._helpHeader;
    }

    public void setHelpHeader(String helpHeader) {
        this._helpHeader = helpHeader;
    }

    public String getProfileHelpText() {
        return this._profileHelpText;
    }

    public void setProfileHelpText(String helpText) {
        this._profileHelpText = helpText;
    }

    public String getAgreementHelpText() {
        return this._agreementHelpText;
    }

    public void setAgreementHelpText(String helpText) {
        this._agreementHelpText = helpText;
    }

    public String getType() {
        return this._type;
    }

    public void setType(String type) {
        this._type = type;
    }

    public String getName() {
        return this._name;
    }

    public void setName(String name) {
        this._name = name;
    }

    public String getOptionPath() {
        return this._path;
    }

    public void setOptionPath(String path) {
        this._path = path;
    }

    public String getActiveOptionValue() {
        return this._selectedValue;
    }

    public void setActiveOptionValue(String value) {
        this._selectedValue = value;
    }

    public boolean getSupported() {
        return this._supported;
    }

    public void setSupported(boolean supported) {
        this._supported = supported;
    }

    public boolean isListValueSupported() {
        return this._listValueSupported;
    }

    public void setListValueSupported(boolean listValueSupported) {
        this._listValueSupported = listValueSupported;
    }

    public boolean getUptodate() {
        return this._uptodate;
    }

    public void setUptodate(boolean uptodate) {
        this._uptodate = uptodate;
    }

    public String getHelp() {
        return this._help;
    }

    public void setHelp(String help) {
        this._help = help;
    }

    public String toString() {
        String[] commonValues = this.getCommonValues();
        Object commonValuesAsString = "[";
        for (int i = 0; i < commonValues.length; ++i) {
            String commonValue = commonValues[i];
            commonValuesAsString = (String)commonValuesAsString + commonValue;
            if (i >= commonValues.length - 1) continue;
            commonValuesAsString = (String)commonValuesAsString + ", ";
        }
        commonValuesAsString = (String)commonValuesAsString + "]";
        return "Path:" + this.getOptionPath() + "; selectedValue: " + this._selectedValue + "; values: " + this.getValues() + "; type: " + this.getType() + "; name: " + this.getName() + "; help: " + this.getHelp() + "; helpHeader: " + this.getHelpHeader() + "; profileHelpText: " + this.getProfileHelpText() + "; agreementHelpText: " + this.getAgreementHelpText() + "; activeOption: " + this.getActiveOption() + "; canOnlyExistsInProfile: " + this.getCanOnlyExistsInProfile() + "; dependence: " + this.getDependence() + "; standardActive: " + this.getStandardActive() + "; certMode: " + this.getCertMode() + "; certRefIde: " + this.getCertRefId() + "; certSupported: " + this.isCertSupported() + "; supported: " + this.getSupported() + "; uptodate: " + this.getUptodate() + "; commonValues: " + (String)commonValuesAsString + "; listValueSupported: " + this.isListValueSupported() + "; isEmptyValueAllowed: " + this.isEmptyValueAllowed() + "; toolTip: " + this.getToolTip() + "; level: " + this.getOptionLevel() + "; paddingLeft: " + this.getPaddingLeft() + "; defaultValue: " + this.getDefaultValue() + "; visible: " + this.isVisible() + "; visibility: " + String.valueOf((Object)this.getVisibility()) + ".";
    }

    public boolean getCanOnlyExistsInProfile() {
        return this._canOnlyExistsInProfile;
    }

    public void setCanOnlyExistsInProfile(boolean onlyExistsInProfiele) {
        this._canOnlyExistsInProfile = onlyExistsInProfiele;
    }

    public String getValues() {
        return this._values;
    }

    public void setValues(String values) {
        this._values = values;
    }

    public boolean getActiveOption() {
        return this._activeOption;
    }

    public void setActiveOption(boolean isActive) {
        this._activeOption = isActive;
    }

    public String[] getCommonValues() {
        return this._commonValues;
    }

    public void setCommonValues(String[] commonValues) {
        this._commonValues = commonValues;
    }

    public String getParentPath() {
        return Option.getParentPath(this._path);
    }

    protected Object clone() throws CloneNotSupportedException {
        UIOption newUIOption = new UIOption();
        this.copyValuesTo(newUIOption);
        return newUIOption;
    }

    protected void copyValuesTo(UIOption newUIOption) {
        newUIOption.setActiveOption(this.getActiveOption());
        newUIOption.setCanOnlyExistsInProfile(this.getCanOnlyExistsInProfile());
        newUIOption.setCommonValues((String[])this.getCommonValues().clone());
        newUIOption.setValues(this.getValues());
        newUIOption.setHelp(this.getHelp());
        newUIOption.setHelpHeader(this.getHelpHeader());
        newUIOption.setProfileHelpText(this.getProfileHelpText());
        newUIOption.setAgreementHelpText(this.getAgreementHelpText());
        newUIOption.setName(this.getName());
        newUIOption.setOptionPath(this.getOptionPath());
        newUIOption.setActiveOptionValue(this.getActiveOptionValue());
        newUIOption.setSupported(this.getSupported());
        newUIOption.setListValueSupported(this.isListValueSupported());
        newUIOption.setType(this.getType());
        newUIOption.setUptodate(this.getUptodate());
        newUIOption.setDependence(this.getDependence());
        newUIOption.setDefaultValue(this.getDefaultValue());
        newUIOption.setEmptyValueAllowed(this.isEmptyValueAllowed());
        newUIOption.setCertMode(this.getCertMode());
        newUIOption.setCertRefId(this.getCertRefId());
        newUIOption.setCertSupported(this.isCertSupported());
        newUIOption.setVisibility(this.getVisibility());
        newUIOption._level = this._level;
        newUIOption._paddingLeft = this._paddingLeft;
    }

    public static UIOption[] clone(UIOption[] uiOptions) throws CloneNotSupportedException {
        UIOption[] newArray = new UIOption[uiOptions.length];
        for (int i = 0; i < newArray.length; ++i) {
            newArray[i] = (UIOption)uiOptions[i].clone();
        }
        return newArray;
    }

    public String getToolTip() {
        return this._toolTip;
    }

    public void setToolTip(String toolTip) {
        this._toolTip = toolTip;
    }

    public String getHtmlToolTip() {
        String htmlToolTip = this._toolTip;
        if (htmlToolTip != null) {
            htmlToolTip = htmlToolTip.replaceAll("'", "&#39;");
            htmlToolTip = htmlToolTip.replaceAll("\"", "&#58;");
        } else {
            htmlToolTip = "";
        }
        return htmlToolTip;
    }

    public int calculateOptionLevel() {
        int level = 1;
        try {
            String parentPath = this.getParentPath();
            level = parentPath == null || parentPath.trim().equals("") ? 1 : (level += new UIOption(parentPath).calculateOptionLevel());
        }
        catch (Exception e) {
            level = 1;
        }
        this._level = level;
        this.calculatePaddingLeft();
        return level;
    }

    public int getOptionLevel() {
        if (this._level == -1) {
            this._level = this.calculateOptionLevel();
        }
        return this._level;
    }

    public int calculatePaddingLeft() {
        this._paddingLeft = (this.getOptionLevel() - 1) * 20;
        return this._paddingLeft;
    }

    public int getPaddingLeft() {
        return this._paddingLeft;
    }

    public String getDefaultValue() {
        if (this._defaultValue == null) {
            if ("boolean".equals(this.getType())) {
                return Boolean.TRUE.toString();
            }
            if ("string".equals(this.getType())) {
                return "";
            }
            if ("list".equals(this.getType())) {
                String[] values = this.getValueEntries();
                if (values.length > 0) {
                    return values[0];
                }
                return "";
            }
        }
        return this._defaultValue;
    }

    public String getDefaultOptionPath(String optionSort) {
        return UIOptionFinder.determineDefaultOptionPath(optionSort, this.getOptionPath());
    }

    public void setDefaultValue(String defaultValue) {
        this._defaultValue = defaultValue;
    }

    public String[] getValueEntries() {
        try {
            return this.getValues().split(LIST_VALUES_SEPARATOR);
        }
        catch (Exception e) {
            return new String[0];
        }
    }

    public void sortValues() {
        String[] values = this.getValueEntries();
        UIOption.sortValues(values);
        this.setValues(UIOption.values2String(values));
    }

    public static String values2String(String[] values) {
        Object string = "";
        for (int i = 0; i < values.length; ++i) {
            String value = values[i];
            string = i == 0 ? (String)string + value : (String)string + LIST_VALUES_SEPARATOR + value;
        }
        return string;
    }

    public static void sortValues(String[] values) {
        Arrays.sort(values, String::compareToIgnoreCase);
    }

    public boolean isEmptyValueAllowed() {
        if ("string".equals(this.getType())) {
            return this._isEmptyValueAllowed;
        }
        return false;
    }

    public void setEmptyValueAllowed(boolean isEmptyValueAllowed) {
        this._isEmptyValueAllowed = isEmptyValueAllowed;
    }

    public boolean getNeedsCertificate() {
        return !CERT_MODE_NONE.equals(this.getCertMode());
    }

    public String getCertRefId() {
        return this._certRefId;
    }

    public void setCertRefId(String certRefId) {
        this._certRefId = certRefId;
    }

    public String getCertMode() {
        return this._certMode;
    }

    public void setCertMode(String certMode) {
        this._certMode = certMode;
    }

    public boolean isCertSupported() {
        return this._certSupported;
    }

    public void setCertSupported(boolean certSupported) {
        this._certSupported = certSupported;
    }

    public boolean isVisible() {
        return this._visible;
    }

    public void setVisible(boolean visible) {
        this._visible = visible;
    }

    public boolean isValid() {
        return this.getSupported() && this.isListValueSupported() && this.isCertSupported();
    }

    public boolean validate(CppPartner sender, CppPartner receiver, Communication comm) {
        return true;
    }

    public VISIBILITY getVisibility() {
        return this._visibility;
    }

    public void setVisibility(VISIBILITY visibility) {
        this._visibility = visibility;
    }

    public static enum VISIBILITY {
        INBOUND,
        OUTBOUND,
        NONE,
        BOTH;

    }
}

