/*
 * Decompiled with CFR 0.152.
 */
package de.pontonconsulting.xmlpipe.soap.ebxml.header;

import de.pontonconsulting.xmlpipe.messenger.ReferenceDateTask;
import de.pontonconsulting.xmlpipe.soap.ebxml.EbXmlException;
import de.pontonconsulting.xmlpipe.soap.ebxml.header.Description;
import de.pontonconsulting.xmlpipe.soap.ebxml.header.HeaderExtension;
import de.pontonconsulting.xmlpipe.soap.ebxml.header.MessageData;
import de.pontonconsulting.xmlpipe.soap.ebxml.header.Party;
import de.pontonconsulting.xmlpipe.soap.ebxml.header.Service;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import javax.xml.soap.Name;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPEnvelope;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPHeaderElement;

public class MessageHeader
extends HeaderExtension {
    private String _cpaId;
    public static final String EBXML_CPA_ID = "CPAId";
    private String _conversationId;
    public static final String EBXML_CONVERSATION_ID = "ConversationId";
    private String _action;
    public static final String EBXML_ACTION = "Action";
    private boolean _duplicateElimination;
    public static final String EBXML_DUPLICATE_ELIMINATION = "DuplicateElimination";
    private Party _to;
    public static final String EBXML_TO = "To";
    private Party _from;
    public static final String EBXML_FROM = "From";
    private MessageData _messageData;
    public static final String EBXML_MESSAGEDATA = "MessageData";
    private final Collection<Description> _description = new ArrayList<Description>();
    public static final String EBXML_DESCRIPTION = "Description";
    private Service _service;
    public static final String EBXML_SERVICE = "Service";

    public MessageHeader(ReferenceDateTask referenceDateTask) {
        this._from = new Party();
        this._to = new Party();
        this._messageData = new MessageData(referenceDateTask);
    }

    public MessageHeader(SOAPElement elem, SOAPEnvelope env, ReferenceDateTask referenceDateTask) throws SOAPException {
        super(elem, env);
        Iterator it = elem.getChildElements();
        Name name = null;
        while (it.hasNext()) {
            Object subElement = it.next();
            if (!(subElement instanceof SOAPElement)) continue;
            elem = (SOAPElement)subElement;
            name = elem.getElementName();
            if (this.compare(name, EBXML_FROM)) {
                this._from = new Party(elem, env);
                continue;
            }
            if (this.compare(name, EBXML_TO)) {
                this._to = new Party(elem, env);
                continue;
            }
            if (this.compare(name, EBXML_CPA_ID)) {
                this._cpaId = elem.getValue();
                continue;
            }
            if (this.compare(name, EBXML_CONVERSATION_ID)) {
                this._conversationId = elem.getValue();
                continue;
            }
            if (this.compare(name, EBXML_SERVICE)) {
                this._service = new Service(elem, env);
                continue;
            }
            if (this.compare(name, EBXML_ACTION)) {
                this._action = elem.getValue();
                continue;
            }
            if (this.compare(name, EBXML_MESSAGEDATA)) {
                this._messageData = new MessageData(elem, referenceDateTask);
                continue;
            }
            if (this.compare(name, EBXML_DESCRIPTION)) {
                this._description.add(new Description(elem, env));
                continue;
            }
            if (!this.compare(name, EBXML_DUPLICATE_ELIMINATION)) continue;
            this._duplicateElimination = true;
        }
    }

    public String getCpaId() {
        return this._cpaId;
    }

    public void setCpaId(String cpaId) {
        this._cpaId = cpaId;
    }

    public String getConversationId() {
        return this._conversationId;
    }

    public void setConversationId(String conversationId) {
        this._conversationId = conversationId;
    }

    public String getAction() {
        return this._action;
    }

    public void setAction(String action) {
        this._action = action;
    }

    public boolean isDuplicateElimination() {
        return this._duplicateElimination;
    }

    public void setDuplicateElimination(boolean duplicateElimination) {
        this._duplicateElimination = duplicateElimination;
    }

    public Party getFrom() {
        return this._from;
    }

    public void setFrom(Party from) {
        this._from = from;
    }

    public void setFrom(HashMap<String, String> from) {
        this._from = new Party(from);
    }

    public MessageData getMessageData() {
        return this._messageData;
    }

    public void setMessageData(MessageData messageData) {
        this._messageData = messageData;
    }

    public Collection<Description> getDescriptions() {
        return this._description;
    }

    public void addDescription(String text, String language) {
        this._description.add(new Description(text, language));
    }

    public void addDescription(Description description) {
        this._description.add(description);
    }

    public Service getService() {
        return this._service;
    }

    public void setService(Service service) {
        this._service = service;
    }

    public void setService(String service, String type) {
        this._service = new Service(service, type);
    }

    public Party getTo() {
        return this._to;
    }

    public void addParty(String partyId, String partyIdType) {
        this._to.addPartyId(partyId, partyIdType);
    }

    public void setTo(Party to) {
        this._to = to;
    }

    public void setTo(HashMap<String, String> to) {
        this._to = new Party(to);
    }

    public void generateSOAP(SOAPHeaderElement ebHeader, SOAPEnvelope envelope) throws SOAPException {
        Name name = null;
        this.generateMustUnderstand(ebHeader, envelope);
        if (this.getId() != null) {
            name = envelope.createName("id", "eb", "http://www.oasis-open.org/committees/ebxml-msg/schema/msg-header-2_0.xsd");
            ebHeader.addAttribute(name, this.getId());
        }
        name = envelope.createName("version", "eb", "http://www.oasis-open.org/committees/ebxml-msg/schema/msg-header-2_0.xsd");
        ebHeader.addAttribute(name, this.getVersion());
        name = envelope.createName(EBXML_FROM, "eb", "http://www.oasis-open.org/committees/ebxml-msg/schema/msg-header-2_0.xsd");
        SOAPElement ebFrom = ebHeader.addChildElement(name);
        this._from.generateSOAP(ebFrom, envelope);
        name = envelope.createName(EBXML_TO, "eb", "http://www.oasis-open.org/committees/ebxml-msg/schema/msg-header-2_0.xsd");
        SOAPElement ebTo = ebHeader.addChildElement(name);
        this._to.generateSOAP(ebTo, envelope);
        name = envelope.createName(EBXML_CPA_ID, "eb", "http://www.oasis-open.org/committees/ebxml-msg/schema/msg-header-2_0.xsd");
        SOAPElement ebCPAId = ebHeader.addChildElement(name);
        ebCPAId.addTextNode(this._cpaId);
        name = envelope.createName(EBXML_CONVERSATION_ID, "eb", "http://www.oasis-open.org/committees/ebxml-msg/schema/msg-header-2_0.xsd");
        SOAPElement ebConv = ebHeader.addChildElement(name);
        ebConv.addTextNode(this._conversationId);
        name = envelope.createName(EBXML_SERVICE, "eb", "http://www.oasis-open.org/committees/ebxml-msg/schema/msg-header-2_0.xsd");
        SOAPElement ebService = ebHeader.addChildElement(name);
        this._service.generateSOAP(ebService, envelope);
        name = envelope.createName(EBXML_ACTION, "eb", "http://www.oasis-open.org/committees/ebxml-msg/schema/msg-header-2_0.xsd");
        SOAPElement ebAction = ebHeader.addChildElement(name);
        ebAction.addTextNode(this._action);
        name = envelope.createName(EBXML_MESSAGEDATA, "eb", "http://www.oasis-open.org/committees/ebxml-msg/schema/msg-header-2_0.xsd");
        SOAPElement ebMessageData = ebHeader.addChildElement(name);
        this._messageData.generateSOAP(ebMessageData, envelope);
        if (this._duplicateElimination) {
            name = envelope.createName(EBXML_DUPLICATE_ELIMINATION, "eb", "http://www.oasis-open.org/committees/ebxml-msg/schema/msg-header-2_0.xsd");
            ebHeader.addChildElement(name);
        }
        Iterator<Description> i = this._description.iterator();
        while (i.hasNext()) {
            name = envelope.createName(EBXML_DESCRIPTION, "eb", "http://www.oasis-open.org/committees/ebxml-msg/schema/msg-header-2_0.xsd");
            SOAPElement ebDescription = ebHeader.addChildElement(name);
            Description element = i.next();
            element.generateSOAP(ebDescription, envelope);
        }
    }

    public void validate() throws EbXmlException {
        if (this._from == null) {
            throw new EbXmlException(30034, "Error", "OtherXml", "From Element is required in MessageHeader.");
        }
        if (this._to == null) {
            throw new EbXmlException(30035, "Error", "OtherXml", "To Element is required in MessageHeader.");
        }
        if (this._cpaId == null) {
            throw new EbXmlException(30036, "Error", "OtherXml", "CPAId Element is required in MessageHeader.");
        }
        if (this._conversationId == null) {
            throw new EbXmlException(30037, "Error", "OtherXml", "ConversationId Element is required in MessageHeader.");
        }
        if (this._service == null) {
            throw new EbXmlException(30038, "Error", "OtherXml", "Service Element is required in MessageHeader.");
        }
        this._service.validate();
        if (this._action == null) {
            throw new EbXmlException(30039, "Error", "OtherXml", "Action Element is required in MessageHeader.");
        }
        if (this._messageData == null) {
            throw new EbXmlException(30040, "Error", "OtherXml", "MessageData Element is required in MessageHeader.");
        }
        this._messageData.validate();
    }
}

