/*
 * Decompiled with CFR 0.152.
 */
package de.pontonconsulting.xmlpipe.soap.ebxml.header;

import de.pontonconsulting.xmlpipe.soap.ebxml.EbXmlException;
import de.pontonconsulting.xmlpipe.soap.ebxml.header.Error;
import de.pontonconsulting.xmlpipe.soap.ebxml.header.HeaderExtension;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import javax.xml.soap.Name;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPEnvelope;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPHeaderElement;

public class ErrorList
extends HeaderExtension {
    private String _highestSeverity;
    public static final String EBXML_HIGHEST_SEVERITY = "highestSeverity";
    public Collection<Error> _error = new ArrayList<Error>();
    public static final String EBXML_ERROR = "Error";

    public ErrorList() {
    }

    public ErrorList(SOAPElement elem, SOAPEnvelope env) throws SOAPException {
        super(elem, env);
        Name name = env.createName(EBXML_HIGHEST_SEVERITY, "eb", "http://www.oasis-open.org/committees/ebxml-msg/schema/msg-header-2_0.xsd");
        this._highestSeverity = elem.getAttributeValue(name);
        Iterator it = elem.getChildElements();
        while (it.hasNext()) {
            Object subElement = it.next();
            if (!(subElement instanceof SOAPElement) || !this.compare(name = (elem = (SOAPElement)subElement).getElementName(), EBXML_ERROR)) continue;
            this._error.add(new Error(elem, env));
        }
    }

    public String getHighestSeverity() {
        return this._highestSeverity;
    }

    public void setHighestSeverity(String highestSeverity) {
        this._highestSeverity = highestSeverity;
    }

    public Collection<Error> getErrors() {
        return this._error;
    }

    public void addError(Error error) {
        if (!this._error.contains(error)) {
            this._error.add(error);
            this.updateHighestSeverity(error.getSeverity());
        }
    }

    public void addError(String severity, String errorcode) {
        this._error.add(new Error(severity, errorcode));
        this.updateHighestSeverity(severity);
    }

    private void updateHighestSeverity(String severity) {
        if (this._highestSeverity == null) {
            this._highestSeverity = severity;
        } else if (EBXML_ERROR.equals(severity)) {
            this._highestSeverity = severity;
        }
    }

    public void removeError(Error error) {
        this._error.remove(error);
    }

    public void generateSOAP(SOAPHeaderElement ebHeader, SOAPEnvelope envelope) throws SOAPException {
        Name name = null;
        this.generateMustUnderstand(ebHeader, envelope);
        if (this.getId() != null) {
            name = envelope.createName("id", "eb", "http://www.oasis-open.org/committees/ebxml-msg/schema/msg-header-2_0.xsd");
            ebHeader.addAttribute(name, this.getId());
        }
        name = envelope.createName("version", "eb", "http://www.oasis-open.org/committees/ebxml-msg/schema/msg-header-2_0.xsd");
        ebHeader.addAttribute(name, this.getVersion());
        name = envelope.createName(EBXML_HIGHEST_SEVERITY, "eb", "http://www.oasis-open.org/committees/ebxml-msg/schema/msg-header-2_0.xsd");
        ebHeader.addAttribute(name, this._highestSeverity);
        Iterator<Error> i = this._error.iterator();
        while (i.hasNext()) {
            name = envelope.createName(EBXML_ERROR, "eb", "http://www.oasis-open.org/committees/ebxml-msg/schema/msg-header-2_0.xsd");
            SOAPElement ebError = ebHeader.addChildElement(name);
            Error element = i.next();
            element.generateSOAP(ebError, envelope);
        }
    }

    public void validate() throws EbXmlException {
        if (this._error.isEmpty()) {
            throw new EbXmlException(30029, EBXML_ERROR, "OtherXml", "ErrorList must contain at least one Error Element");
        }
        if (this._highestSeverity == null) {
            throw new EbXmlException(30030, EBXML_ERROR, "OtherXml", "ErrorList must contain highestSeverity Attribute");
        }
    }
}

