/*
 * Decompiled with CFR 0.152.
 */
package de.pontonconsulting.xmlpipe.soap.ebxml.body;

import de.pontonconsulting.xmlpipe.soap.ebxml.EbXmlException;
import de.pontonconsulting.xmlpipe.soap.ebxml.body.BodyExtension;
import java.util.Iterator;
import javax.xml.soap.Name;
import javax.xml.soap.SOAPBodyElement;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPEnvelope;
import javax.xml.soap.SOAPException;

public class StatusRequest
extends BodyExtension {
    private String _refToMessageId;
    public static final String EBXML_REF_TO_MESSAGE_ID = "RefToMessageId";

    public StatusRequest(String refToMessageId) {
        this._refToMessageId = refToMessageId;
    }

    public StatusRequest(SOAPElement elem, SOAPEnvelope env) throws SOAPException {
        super(elem, env);
        Iterator it = elem.getChildElements();
        Name name = null;
        while (it.hasNext()) {
            Object subElement = it.next();
            if (!(subElement instanceof SOAPElement) || !this.compare(name = (elem = (SOAPElement)subElement).getElementName(), EBXML_REF_TO_MESSAGE_ID)) continue;
            this._refToMessageId = elem.getValue();
            break;
        }
    }

    public String getRefToMessageId() {
        return this._refToMessageId;
    }

    public void setRefToMessageId(String refToMessageId) {
        this._refToMessageId = refToMessageId;
    }

    public void generateSOAP(SOAPBodyElement ebHeader, SOAPEnvelope envelope) throws SOAPException {
        Name name = null;
        if (this.getId() != null) {
            name = envelope.createName("id", "eb", "http://www.oasis-open.org/committees/ebxml-msg/schema/msg-header-2_0.xsd");
            ebHeader.addAttribute(name, this.getId());
        }
        name = envelope.createName("version", "eb", "http://www.oasis-open.org/committees/ebxml-msg/schema/msg-header-2_0.xsd");
        ebHeader.addAttribute(name, this.getVersion());
        name = envelope.createName(EBXML_REF_TO_MESSAGE_ID, "eb", "http://www.oasis-open.org/committees/ebxml-msg/schema/msg-header-2_0.xsd");
        SOAPElement ebRefTo = ebHeader.addChildElement(name);
        ebRefTo.addTextNode(this._refToMessageId);
    }

    public void validate() throws EbXmlException {
        if (this._refToMessageId == null) {
            throw new EbXmlException(30025, "Error", "OtherXml", "StatusRequest must contain RefToMessageId Element");
        }
    }
}

