/*
 * Decompiled with CFR 0.152.
 */
package de.pontonconsulting.xmlpipe.server;

import de.ponton.xmlpipe.bootstrap.ResultCode;
import de.pontonconsulting.xmlpipe.activation.ClusterModeException;
import de.pontonconsulting.xmlpipe.config.AddOnInfoReader;
import de.pontonconsulting.xmlpipe.server.ApplicationUpdater;
import de.pontonconsulting.xmlpipe.server.Server;
import de.schlichtherle.truezip.file.TFile;
import jakarta.activation.CommandMap;
import jakarta.activation.MailcapCommandMap;
import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.security.InvalidKeyException;
import java.security.Provider;
import java.security.Security;
import java.sql.SQLException;
import java.util.Locale;
import java.util.concurrent.atomic.AtomicInteger;
import javax.crypto.Cipher;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.logging.log4j.jul.Log4jBridgeHandler;
import org.apache.wss4j.common.crypto.SantuarioUtil;
import org.apache.wss4j.dom.engine.WSSConfig;
import org.apache.xml.security.Init;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.jsse.provider.BouncyCastleJsseProvider;
import org.hibernate.HibernateException;
import org.springframework.beans.FatalBeanException;
import org.springframework.context.support.ClassPathXmlApplicationContext;

public class Startup {
    private static final Log _log = LogFactory.getFactory().getInstance(Startup.class);
    private static final String COULD_NOT_START_PONTON_X_P_ERROR = "Could not start Ponton X/P. Error: ";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Integer start() {
        try {
            this.checkCryptoStrength();
            ClassPathXmlApplicationContext context = new ClassPathXmlApplicationContext("de/pontonconsulting/xmlpipe/spring.xml");
            Server server = (Server)context.getBean("server", Server.class);
            server.init();
            Server server2 = server;
            synchronized (server2) {
                server.wait();
            }
            return server.getResultCode();
        }
        catch (InvalidKeyException e) {
            System.err.println("Java runtime does not have the 'Unlimited Crypto Strength Jurisdiction Policy Files' installed !");
            System.err.println("This prevents PontonXP from using high-level encryption. ");
            System.err.println("please download these policy files from your JRE vendor and install them into jre/lib/security/");
            System.exit(1);
        }
        catch (FatalBeanException h) {
            Throwable t = h;
            while (t.getCause() != null) {
                t = t.getCause();
            }
            if (t instanceof HibernateException || t instanceof SQLException) {
                System.err.println("Database layer could not be initialised: " + t.getMessage() + "\nplease check database configuration.");
                t.printStackTrace();
                System.exit(1);
            } else if (t instanceof ClusterModeException) {
                ClusterModeException c = (ClusterModeException)t;
                System.err.println(COULD_NOT_START_PONTON_X_P_ERROR + c.getMessage());
                System.exit(1);
            } else {
                System.err.println(COULD_NOT_START_PONTON_X_P_ERROR + String.valueOf(t));
                t.printStackTrace();
                System.exit(1);
            }
        }
        catch (Exception e) {
            System.err.println(COULD_NOT_START_PONTON_X_P_ERROR + String.valueOf(e));
            e.printStackTrace();
            System.exit(1);
        }
        return ResultCode.SHUTDOWN.getResultCode();
    }

    private void checkCryptoStrength() throws Exception {
        Cipher cipher1 = Cipher.getInstance("AES");
        SecretKeySpec key = new SecretKeySpec(new byte[32], "AES");
        cipher1.init(1, key);
    }

    public static void main(String[] args) throws Exception {
        String pontonxpHome = System.getProperty("PONTONXP_HOME");
        if (pontonxpHome != null) {
            final Path tempFolder = Path.of(pontonxpHome, "work", "temp").toAbsolutePath();
            System.setProperty("java.io.tmpdir", tempFolder.toString());
            if (Files.exists(tempFolder, new LinkOption[0])) {
                final AtomicInteger count = new AtomicInteger();
                long startDeletion = System.currentTimeMillis();
                Files.walkFileTree(tempFolder, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                    @Override
                    public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                        Files.delete(file);
                        count.getAndIncrement();
                        return FileVisitResult.CONTINUE;
                    }

                    @Override
                    public FileVisitResult postVisitDirectory(Path dir, IOException exc) throws IOException {
                        if (!tempFolder.equals(dir.toAbsolutePath())) {
                            Files.delete(dir);
                        }
                        return FileVisitResult.CONTINUE;
                    }
                });
                long durationDeletion = (System.currentTimeMillis() - startDeletion) / 1000L;
                System.out.println("Deleted " + String.valueOf(count) + " files in " + durationDeletion + " seconds in the temp folder " + String.valueOf(tempFolder));
            } else {
                Files.createDirectories(tempFolder, new FileAttribute[0]);
                System.out.println("Created temp folder: " + String.valueOf(tempFolder));
            }
        }
        AddOnInfoReader addOnInfoReader = new AddOnInfoReader();
        ApplicationUpdater applicationUpdater = new ApplicationUpdater(addOnInfoReader);
        applicationUpdater.execute();
        Startup startup = new Startup();
        Integer resultCode = startup.start();
        System.out.println("System Exit Code: " + resultCode);
        System.exit(resultCode);
    }

    static {
        Log4jBridgeHandler.install((boolean)true, (String)"", (boolean)true);
        System.setProperty("networkaddress.cache.ttl", System.getProperty("networkaddress.cache.ttl", "3000"));
        System.setProperty("networkaddress.cache.negative.ttl", System.getProperty("networkaddress.cache.negative.ttl", "5"));
        System.setProperty("jdk.http.auth.tunneling.disabledSchemes", System.getProperty("jdk.http.auth.tunneling.disabledSchemes", ""));
        System.setProperty("jdk.httpclient.keepalive.timeout", System.getProperty("jdk.httpclient.keepalive.timeout", "3000"));
        System.setProperty("jdk.httpclient.disableRetryConnect", System.getProperty("jdk.httpclient.disableRetryConnect", "true"));
        Locale systemLocal = Locale.getDefault();
        Locale.setDefault(Locale.ENGLISH);
        System.setProperty("user.country", systemLocal.getCountry());
        System.setProperty("user.language", Locale.ENGLISH.getLanguage());
        System.setProperty("org.mortbay.http.Version.paranoid", "true");
        String schemaFactoryProperty = "javax.xml.validation.SchemaFactory:http://www.w3.org/2001/XMLSchema";
        System.setProperty("javax.xml.validation.SchemaFactory:http://www.w3.org/2001/XMLSchema", "com.sun.org.apache.xerces.internal.jaxp.validation.XMLSchemaFactory");
        MailcapCommandMap mailcap = (MailcapCommandMap)CommandMap.getDefaultCommandMap();
        mailcap.addMailcap("message/disposition-notification;; x-java-content-handler=de.pontonconsulting.xmlpipe.mail.disposition_notification");
        CommandMap.setDefaultCommandMap((CommandMap)mailcap);
        System.setProperty("mail.mime.encodeparameters", "false");
        System.setProperty("mail.mime.address.usecanonicalhostname", "false");
        System.setProperty("hsqldb.method_class_names", "abc");
        System.setProperty("jdk.tls.namedGroups", System.getProperty("jdk.tls.namedGroups", "brainpoolP256r1, brainpoolP256r1tls13, brainpoolP384r1tls13, brainpoolP512r1tls13, brainpoolP384r1, brainpoolP512r1, secp256r1, secp384r1"));
        _log.info((Object)"adding BC Security Provider");
        BouncyCastleProvider bouncyCastleProvider = new BouncyCastleProvider();
        Security.addProvider((Provider)bouncyCastleProvider);
        Security.addProvider((Provider)new BouncyCastleJsseProvider((Provider)bouncyCastleProvider));
        Security.removeProvider("SunEC");
        Security.addProvider(SantuarioUtil.getSantuarioProvider());
        WSSConfig.init();
        _log.info((Object)"initializing XML Security");
        System.setProperty("org.apache.xml.security.ignoreLineBreaks", "true");
        Init.init();
        new TFile("test.true");
    }
}

