/*
 * Decompiled with CFR 0.152.
 */
package de.pontonconsulting.xmlpipe.security.xmlsig;

import de.pontonconsulting.xmlpipe.security.xmlsig.DocumentReference;
import java.io.InputStream;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.xml.security.signature.XMLSignatureInput;
import org.apache.xml.security.utils.resolver.ResourceResolverContext;
import org.apache.xml.security.utils.resolver.ResourceResolverException;
import org.apache.xml.security.utils.resolver.ResourceResolverSpi;
import org.w3c.dom.Attr;

public class DocumentResolver
extends ResourceResolverSpi {
    private final Logger log = LogManager.getLogger((String)("Messenger." + ((Object)((Object)this)).getClass().getSimpleName()));
    protected DocumentReference[] docs;

    public DocumentResolver(DocumentReference[] docReferences) {
        this.docs = docReferences;
    }

    public XMLSignatureInput engineResolveURI(ResourceResolverContext context) throws ResourceResolverException {
        XMLSignatureInput input;
        Attr uri = context.attr;
        String baseUri = context.baseUri;
        String href = uri.getNodeValue();
        if (!href.startsWith("cid:")) {
            Object[] exArgs = new Object[]{"Reference URI does not start with 'cid:'"};
            throw new ResourceResolverException(href, exArgs, uri.toString(), baseUri);
        }
        int found = -1;
        for (int i = 0; i < this.docs.length; ++i) {
            if (this.docs[i].getUri() == null || !this.docs[i].getUri().equals(href)) continue;
            found = i;
            break;
        }
        if (found < 0) {
            this.log.error("can not find:{} {} {}", (Object)href, (Object)uri, (Object)baseUri);
            Object[] exArgs = new Object[]{"Reference URI = " + href + " does not exist!"};
            throw new ResourceResolverException(href, exArgs, uri.toString(), baseUri);
        }
        try {
            InputStream in = this.docs[found].getStream();
            input = new XMLSignatureInput(in);
        }
        catch (Exception e) {
            throw new ResourceResolverException(e, href, uri.toString(), baseUri);
        }
        input.setSourceURI(href);
        input.setMIMEType(this.docs[found].getContentType());
        return input;
    }

    public boolean engineCanResolveURI(ResourceResolverContext context) {
        String href = context.attr.getNodeValue();
        if (href.startsWith("cid:")) {
            for (int i = 0; i < this.docs.length; ++i) {
                if (this.docs[i].getUri() == null || !this.docs[i].getUri().equals(href)) continue;
                return true;
            }
        }
        return false;
    }
}

