/*
 * Decompiled with CFR 0.152.
 */
package de.pontonconsulting.xmlpipe.security.ldap;

import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.Socket;
import javax.net.SocketFactory;
import javax.net.ssl.SSLSocketFactory;

public class LdapProxySocketFactory
extends SocketFactory {
    private final Proxy proxy;
    private final int connectTimeoutMillis;
    private final SSLSocketFactory sslSocketFactory;

    public LdapProxySocketFactory(Proxy proxy, int connectTimeoutMillis, SSLSocketFactory sslSocketFactory) {
        this.proxy = proxy;
        this.connectTimeoutMillis = Math.max(connectTimeoutMillis, 0);
        this.sslSocketFactory = sslSocketFactory;
    }

    @Override
    public Socket createSocket() {
        throw new UnsupportedOperationException("Cannot create unconnected socket");
    }

    @Override
    public Socket createSocket(String host, int port) throws IOException {
        Socket socket = new Socket(this.proxy);
        socket.connect(InetSocketAddress.createUnresolved(host, port), this.connectTimeoutMillis);
        return this.secureSocket(socket, host, port);
    }

    @Override
    public Socket createSocket(String host, int port, InetAddress localHost, int localPort) throws IOException {
        Socket socket = new Socket(this.proxy);
        socket.bind(new InetSocketAddress(localHost, localPort));
        socket.connect(InetSocketAddress.createUnresolved(host, port), this.connectTimeoutMillis);
        return this.secureSocket(socket, host, port);
    }

    @Override
    public Socket createSocket(InetAddress host, int port) throws IOException {
        return this.createSocket(host.getHostName(), port);
    }

    @Override
    public Socket createSocket(InetAddress host, int port, InetAddress localHost, int localPort) throws IOException {
        Socket socket = new Socket(this.proxy);
        socket.bind(new InetSocketAddress(localHost, localPort));
        socket.connect(new InetSocketAddress(host, port), this.connectTimeoutMillis);
        return this.secureSocket(socket, host.getHostName(), port);
    }

    private Socket secureSocket(Socket socket, String host, int port) throws IOException {
        if (this.sslSocketFactory == null) {
            return socket;
        }
        try {
            return this.sslSocketFactory.createSocket(socket, host, port, true);
        }
        catch (IOException e) {
            socket.close();
            throw e;
        }
    }
}

