/*
 * Decompiled with CFR 0.152.
 */
package de.pontonconsulting.xmlpipe.security.certificate;

import de.pontonconsulting.xmlpipe.security.CertificateReader;
import de.pontonconsulting.xmlpipe.security.CertificateUtility;
import de.pontonconsulting.xmlpipe.security.certificate.ICertificateFilter;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class EmailCertificateFilter
implements ICertificateFilter {
    private static Logger LOGGER = LogManager.getLogger((String)"Messenger.EmailCertificateFilter");
    private final CertificateReader certificateInfo;
    private final CertificateUtility certificateUtility;
    private final String emailAddress;

    public EmailCertificateFilter(String emailAddress, CertificateReader certificateInfo, CertificateUtility certificateUtility) {
        Objects.requireNonNull(emailAddress, "Email address can't be null.");
        Objects.requireNonNull(certificateInfo, "CertificateInfo can't be null.");
        Objects.requireNonNull(certificateUtility, "CertificateUtility can't be null.");
        this.emailAddress = emailAddress;
        this.certificateInfo = certificateInfo;
        this.certificateUtility = certificateUtility;
    }

    @Override
    public List<X509Certificate> doFilter(X509Certificate currentCertificate, List<X509Certificate> certificates) {
        ArrayList<X509Certificate> filteredCertificates = new ArrayList<X509Certificate>();
        for (X509Certificate certificate : certificates) {
            List<String> emailAddresses = this.retrieveEmailAddresses(certificate);
            if (emailAddresses.stream().anyMatch(this.emailAddress::equalsIgnoreCase)) {
                filteredCertificates.add(certificate);
                continue;
            }
            LOGGER.debug("the email address '{}' does not exist in the certificate{}", (Object)this.emailAddress, (Object)this.certificateUtility.toUsingInfoText(certificate, ""));
        }
        return filteredCertificates;
    }

    private List<String> retrieveEmailAddresses(X509Certificate certificate) {
        ArrayList<String> emailAddresses = new ArrayList<String>();
        try {
            emailAddresses.add(this.certificateInfo.retrieveEmail(certificate));
        }
        catch (CertificateException certificateException) {
            // empty catch block
        }
        emailAddresses.addAll(this.certificateInfo.retrieveSAN_Emails(certificate));
        return emailAddresses;
    }
}

