/*
 * Decompiled with CFR 0.152.
 */
package de.pontonconsulting.xmlpipe.security.acegi;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import de.ponton.xmlpipe.rest.authorization.Permissions;
import de.ponton.xmlpipe.rest.exception.ResourceNotFoundException;
import de.pontonconsulting.xmlpipe.config.IMessengerProperties;
import de.pontonconsulting.xmlpipe.config.IServerConfigBean;
import de.pontonconsulting.xmlpipe.messenger.database.hibernate.UserRole;
import de.pontonconsulting.xmlpipe.messenger.database.tables.UserRoleDAO;
import jakarta.annotation.PostConstruct;
import java.io.IOException;
import java.lang.reflect.Field;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Stream;

public class UserRoleService {
    private static final String PROPERTY_USER_ROLES_FILE = "user.roles.path";
    private final Set<Runnable> onUserRolesChange = new HashSet<Runnable>();
    private final UserRoleDAO userRoleDAO;

    public UserRoleService(IServerConfigBean serverConfig, IMessengerProperties messengerProperties, UserRoleDAO userRoleDAO, ObjectMapper objectMapper) throws IOException {
        Path rolesFile = Path.of(messengerProperties.getProperty(PROPERTY_USER_ROLES_FILE, Path.of(serverConfig.getConfigFolder().toString(), "userRoles.json").toString()), new String[0]);
        if (Files.exists(rolesFile, new LinkOption[0]) && userRoleDAO.getAllUserRoles().isEmpty()) {
            ((List)objectMapper.readValue(Files.readString(rolesFile), (TypeReference)new TypeReference<List<UserRole>>(this){})).forEach(userRoleDAO::save);
            Files.delete(rolesFile);
        }
        this.userRoleDAO = userRoleDAO;
    }

    @PostConstruct
    protected void postConstruct() throws IOException {
        this.createSystemRoles();
    }

    public List<UserRole> getUserRoles() {
        return this.userRoleDAO.getAllUserRoles();
    }

    public void addUserRole(UserRole userRole, String username) throws IOException {
        this.userRoleDAO.save(userRole);
        this.onUserRolesChange.forEach(Runnable::run);
    }

    public UserRole getUserRole(String id) {
        UserRole userRoleById = this.userRoleDAO.getUserRoleById(id);
        if (userRoleById == null) {
            throw new ResourceNotFoundException("Role with id '" + id + "' does not exist.");
        }
        return userRoleById;
    }

    public void deleteUserRole(String id, String username) throws IOException {
        this.userRoleDAO.delete(id);
        this.onUserRolesChange.forEach(Runnable::run);
    }

    public void editUserRole(String id, UserRole userRole, String username) throws IOException {
        this.userRoleDAO.save(userRole);
        this.onUserRolesChange.forEach(Runnable::run);
    }

    private void createSystemRoles() {
        this.createXpAdministratorRole();
        this.createXpConfigAdministratorRole();
        this.createXpOperator();
        this.createXpDashboardRole();
        this.createXpPartnerRoles();
        this.createXpAgreementRoles();
        this.createXpAgreementTemplateRoles();
        this.createHttpAdapter();
        this.createHttpAdapterConfig();
        this.createXpEditSettingsRole();
        this.createXpMessageMonitorRoles();
        this.createXpUserSettingsRoles();
        this.createXpAdminUserSettingsRoles();
        this.createXpMessageTypes();
        this.createXpEditLicence();
        this.createXpMulticastRules();
        this.createXpHotfolder();
        this.createListener();
        this.createAdapter();
        this.createTestAdapter();
        this.createXpClientRolesEdit();
        this.createXpClientRolesView();
        this.onUserRolesChange.forEach(Runnable::run);
    }

    private void createXpAdministratorRole() {
        UserRole userRole = new UserRole();
        this.userRoleDAO.save(userRole.setSystemRole(true).setDescription("XP administrator").setId("ROLE_administrator").setPermissions(Arrays.stream(Permissions.class.getDeclaredFields()).map(Field::getName).filter(permission -> !permission.equals("HTTP_ADAPTER_ACK_GET")).filter(permission -> !permission.equals("HTTP_ADAPTER_INBOUND_GET")).filter(permission -> !permission.equals("HTTP_ADAPTER_OUTBOUND_POST")).toList()));
    }

    private void createXpConfigAdministratorRole() {
        UserRole userRole = new UserRole();
        this.userRoleDAO.save(userRole.setSystemRole(true).setDescription("XP config administrator").setId("ROLE_config_administrator").setPermissions(Arrays.stream(Permissions.class.getDeclaredFields()).map(Field::getName).filter(permission -> !permission.equals("ADMIN_USERS_DELETE")).filter(permission -> !permission.equals("ADMIN_USERS_POST")).filter(permission -> !permission.equals("ADMIN_USERS_PUT")).filter(permission -> !permission.equals("USER_ROLES_POST")).filter(permission -> !permission.equals("USER_ROLES_PUT")).filter(permission -> !permission.equals("USER_ROLES_DELETE")).filter(permission -> !permission.equals("CLIENT_ROLES_PUT")).filter(permission -> !permission.equals("HTTP_ADAPTER_ACK_GET")).filter(permission -> !permission.equals("HTTP_ADAPTER_INBOUND_GET")).filter(permission -> !permission.equals("HTTP_ADAPTER_OUTBOUND_POST")).toList()));
    }

    private void createHttpAdapter() {
        UserRole userRole = new UserRole();
        this.userRoleDAO.save(userRole.setSystemRole(true).setDescription("HTTP adapter role").setId("ROLE_httpadapter").setPermissions(List.of("HTTP_ADAPTER_ACK_GET", "HTTP_ADAPTER_INBOUND_GET", "HTTP_ADAPTER_OUTBOUND_POST").stream().toList()));
    }

    private void createHttpAdapterConfig() {
        UserRole userRole = new UserRole();
        this.userRoleDAO.save(userRole.setSystemRole(true).setDescription("HTTP adapter config role").setId("ROLE_httpadapter_config").setPermissions(List.of("HTTP_ADAPTER_CONFIG_GET", "HTTP_ADAPTER_CONFIG_PUT", "HTTP_ADAPTER_CONFIG_DELETE").stream().toList()));
    }

    private void createXpOperator() {
        UserRole userRole = new UserRole();
        this.userRoleDAO.save(userRole.setSystemRole(true).setDescription("XP operator").setId("ROLE_operator").setPermissions(Arrays.stream(Permissions.class.getDeclaredFields()).map(Field::getName).filter(permission -> permission.equals("MESSAGE_MONITOR_FIND_MESSAGES_POST") || permission.endsWith("GET") || permission.equals("USER_PASSWORD_POST")).filter(permission -> !permission.equals("USER_ROLES_POST")).filter(permission -> !permission.equals("USER_ROLES_PUT")).filter(permission -> !permission.equals("USER_ROLES_DELETE")).filter(permission -> !permission.equals("CLIENT_ROLES_PUT")).filter(permission -> !permission.equals("STATUS_MESSENGER_RESTART_GET")).filter(permission -> !permission.equals("MESSAGE_MONITOR_TOGGLE_MESSAGE_STATUS_GET")).filter(permission -> !permission.equals("MESSAGE_MONITOR_RESEND_SUCCESSFUL_MESSAGE_GET")).filter(permission -> !permission.equals("MESSAGE_MONITOR_RESEND_FAILED_MESSAGE_GET")).filter(permission -> !permission.equals("ACTIVATION_REQUEST_UPDATE_GET")).filter(permission -> !permission.equals("STATUS_MESSENGER_DOWNLOAD_CONFIG_FILES_GET")).filter(permission -> !permission.equals("STATUS_MESSENGER_DOWNLOAD_LOG_FILES_GET")).filter(permission -> !permission.equals("HTTP_ADAPTER_ACK_GET")).filter(permission -> !permission.equals("HTTP_ADAPTER_INBOUND_GET")).filter(permission -> !permission.equals("HTTP_ADAPTER_OUTBOUND_POST")).toList()));
    }

    private void createXpEditSettingsRole() {
        UserRole userRole = new UserRole();
        this.userRoleDAO.save(userRole.setSystemRole(true).setDescription("Edit XP general settings").setId("ROLE_settings_edit").setPermissions(Stream.of("CONFIGURATION_GET", "CONFIGURATION_PUT", "SETTINGS_EMAIL_TEST_POST", "SETTINGS_PARTY_ID_TYPES_GET", "STATUS_MESSENGER_DOWNLOAD_CONFIG_FILES_GET", "STATUS_MESSENGER_UPLOAD_CONFIG_FILES_POST", "STATUS_MESSENGER_DOWNLOAD_LOG_FILES_GET", "STATUS_MESSENGER_RESTART_GET", "SERVER_CERTIFICATE_GET", "SERVER_CERTIFICATE_PUT", "SERVER_CERTIFICATE_REQUEST_POST", "SERVER_KEY_PAIR_GET", "SERVER_KEY_PAIR_PUT", "SERVERCA_POST", "SERVERCA_GET", "SERVERCA_DELETE", "PLUGABLE_ADAPTER_SETTINGS_GET", "PLUGABLE_ADAPTER_SETTINGS_POST", "PLUGABLE_ADAPTER_SETTINGS_DELETE").toList()));
        UserRole userRole2 = new UserRole();
        this.userRoleDAO.save(userRole2.setSystemRole(true).setDescription("View XP general settings").setId("ROLE_settings_view").setPermissions(Stream.of("CONFIGURATION_GET", "STATUS_MESSENGER_DOWNLOAD_CONFIG_FILES_GET", "STATUS_MESSENGER_DOWNLOAD_LOG_FILES_GET", "SERVER_CERTIFICATE_GET", "SERVER_KEY_PAIR_GET", "SERVERCA_GET", "PLUGABLE_ADAPTER_SETTINGS_GET").toList()));
    }

    private void createXpMessageMonitorRoles() {
        UserRole userRole = new UserRole();
        this.userRoleDAO.save(userRole.setSystemRole(true).setDescription("XP message monitor full control").setId("ROLE_messages_edit").setPermissions(Stream.of("MESSAGE_MONITOR_TOGGLE_MESSAGE_STATUS_GET", "MESSAGE_DELIVER_TO_ADAPTER_POST", "MESSAGE_MONITOR_FIND_MESSAGES_POST", "MESSAGE_MONITOR_RESEND_FAILED_MESSAGE_POST", "MESSAGE_MONITOR_RESEND_FAILED_MESSAGE_GET", "MESSAGE_MONITOR_RESEND_SUCCESSFUL_MESSAGE_GET", "MESSAGES_DETAIL_GET", "MESSAGES_BACKEND_XML_GET", "MESSAGES_HTML_GET", "MESSAGES_ENVELOPE_GET", "MESSAGES_RAW_GET", "MESSAGES_DELETE", "MESSAGE_MONITOR_DELETE_MESSAGE_FROM_QUEUE_DELETE", "PARTNER_LIST_GET", "MESSAGE_TYPE_GET", "ADAPTERS_GET", "MESSAGES_LOG_INFO_PUT").toList()));
        UserRole userRole2 = new UserRole();
        this.userRoleDAO.save(userRole2.setSystemRole(true).setDescription("XP message monitor view").setId("ROLE_messages_view").setPermissions(Stream.of("MESSAGE_MONITOR_FIND_MESSAGES_POST", "MESSAGES_DETAIL_GET", "MESSAGES_BACKEND_XML_GET", "MESSAGES_HTML_GET", "MESSAGES_ENVELOPE_GET", "MESSAGES_RAW_GET", "PARTNER_LIST_GET", "MESSAGE_TYPE_GET", "ADAPTERS_GET", "MESSAGES_LOG_INFO_PUT").toList()));
    }

    private void createXpClientRolesEdit() {
        UserRole userRole = new UserRole();
        this.userRoleDAO.save(userRole.setSystemRole(true).setDescription("XP client roles edit").setId("ROLE_client_roles_edit").setPermissions(Stream.of("USER_GET", "CLIENT_ROLES_GET", "CLIENT_ROLES_PUT", "PARTNER_LIST_GET", "ADAPTERS_GET").toList()));
    }

    private void createXpClientRolesView() {
        UserRole userRole = new UserRole();
        this.userRoleDAO.save(userRole.setSystemRole(true).setDescription("XP client roles view").setId("ROLE_client_roles_view").setPermissions(Stream.of("USER_GET", "CLIENT_ROLES_GET", "PARTNER_LIST_GET", "ADAPTERS_GET").toList()));
    }

    private void createXpUserSettingsRoles() {
        UserRole userRole = new UserRole();
        this.userRoleDAO.save(userRole.setSystemRole(true).setDescription("XP user settings").setId("ROLE_user_settings").setPermissions(Stream.of("USER_GET", "USER_LANGUAGE_GET", "USER_LANGUAGE_DELETE", "USER_LANGUAGE_PUT", "USER_IS_TOTP_ENABLED_GET", "USER_DISABLE_TOTP_POST", "USER_ENABLE_TOTP_POST", "USER_GENERATE_TOTP_SECRET_POST", "USER_PASSWORD_POST").toList()));
    }

    private void createXpAdminUserSettingsRoles() {
        UserRole userRole = new UserRole();
        this.userRoleDAO.save(userRole.setSystemRole(true).setDescription("Edit user administration settings").setId("ROLE_user_admin_settings_edit").setPermissions(Stream.of("ADMIN_USERS_DELETE", "ADMIN_USERS_GET", "ADMIN_USERS_POST", "ADMIN_USERS_PUT", "USER_ROLES_GET", "USER_ROLES_DELETE", "USER_ROLES_PERMISSIONS_GET", "USER_ROLES_PUT", "USER_ROLES_POST", "USER_ROLES_SYSTEM_ROLES_GET", "ADMIN_SECURITY_SETTINGS_GET", "CLIENT_ROLES_GET", "CLIENT_ROLES_PUT", "ADMIN_SECURITY_SETTINGS_PUT").toList()));
        UserRole userRole2 = new UserRole();
        this.userRoleDAO.save(userRole2.setSystemRole(true).setDescription("View user administration settings").setId("ROLE_user_admin_settings_view").setPermissions(Stream.of("ADMIN_USERS_GET", "USER_ROLES_GET", "USER_ROLES_PERMISSIONS_GET", "USER_ROLES_SYSTEM_ROLES_GET", "ADMIN_SECURITY_SETTINGS_GET", "CLIENT_ROLES_GET").toList()));
    }

    private void createXpDashboardRole() {
        UserRole userRole = new UserRole();
        this.userRoleDAO.save(userRole.setSystemRole(true).setDescription("XP dashboard").setId("ROLE_dashboard").setPermissions(Arrays.stream(Permissions.class.getDeclaredFields()).map(Field::getName).filter(permission -> permission.startsWith("STATUS") && permission.endsWith("GET")).filter(permission -> !permission.equals("STATUS_MESSENGER_RESTART_GET")).filter(permission -> !permission.equals("STATUS_MESSENGER_DOWNLOAD_CONFIG_FILES_GET")).filter(permission -> !permission.equals("STATUS_MESSENGER_DOWNLOAD_LOG_FILES_GET")).toList().stream().toList()));
    }

    private void createXpPartnerRoles() {
        UserRole userRole = new UserRole();
        this.userRoleDAO.save(userRole.setSystemRole(true).setDescription("XP partners configuration").setId("ROLE_partner_edit").setPermissions(Stream.of("PARTNER_GET", "PARTNER_LIST_GET", "PARTNER_DELETE", "PARTNER_PUT", "PARTNER_LOCAL_PUT", "PARTNER_REMOTE_PUT", "PARTNER_POST", "PARTNER_CERTIFICATE_GET", "PARTNER_CERTIFICATE_POST", "PARTNER_DEFAULT_CERTIFICATE_GET", "PARTNER_DEFAULT_CERTIFICATE_PUT", "PARTNER_KEY_PAIR_GET", "PARTNER_KEY_PAIR_POST", "PARTNER_BDEW_CERTIFICATE_REQUEST_POST", "PARTNER_BDEW_CERTIFICATE_REQUEST_POST", "PARTNER_CERTIFICATE_DELETE", "PARTNER_CERTIFICATE_REQUEST_GET", "PARTNER_CERTIFICATE_REQUEST_POST", "MESSAGE_TYPE_GET", "REGISTRY_GET", "REGISTRY_ENABLED_GET", "REGISTRY_IMPORT_POST", "REGISTRY_SYNCHRONIZE_POST", "REGISTRY_UPLOAD_POST", "SETTINGS_PARTY_ID_TYPES_GET", "CA_GET", "CA_DELETE", "CA_POST").toList()));
        UserRole userRole2 = new UserRole();
        this.userRoleDAO.save(userRole2.setSystemRole(true).setDescription("XP partners view").setId("ROLE_partner_view").setPermissions(Stream.of("PARTNER_GET", "PARTNER_LIST_GET", "PARTNER_CERTIFICATE_GET", "PARTNER_DEFAULT_CERTIFICATE_GET", "PARTNER_KEY_PAIR_GET", "PARTNER_CERTIFICATE_REQUEST_GET", "MESSAGE_TYPE_GET", "MESSAGE_TYPE_GET", "REGISTRY_GET", "REGISTRY_ENABLED_GET", "CA_GET").toList()));
    }

    private void createXpAgreementRoles() {
        UserRole userRole = new UserRole();
        this.userRoleDAO.save(userRole.setSystemRole(true).setDescription("XP agreements edit").setId("ROLE_agreement_edit").setPermissions(Stream.of("AGREEMENTS_DELETE", "AGREEMENTS_GET", "AGREEMENTS_POST", "AGREEMENTS_PUT", "AGREEMENTS_PROPOSAL_GET", "AGREEMENTS_LIST_ITEMS_GET", "AGREEMENTS_TEMPLATE_IDS_GET", "PARTNER_GET", "PARTNER_LIST_GET", "PARTNER_CERTIFICATE_GET", "PARTNER_DEFAULT_CERTIFICATE_GET", "PARTNER_KEY_PAIR_GET", "PARTNER_CERTIFICATE_REQUEST_GET", "MESSAGE_TYPE_GET", "CONFIGURATION_GET").toList()));
        UserRole userRole2 = new UserRole();
        this.userRoleDAO.save(userRole2.setSystemRole(true).setDescription("XP agreements view").setId("ROLE_agreement_view").setPermissions(Stream.of("AGREEMENTS_GET", "AGREEMENTS_PROPOSAL_GET", "AGREEMENTS_LIST_ITEMS_GET", "AGREEMENTS_TEMPLATE_IDS_GET", "PARTNER_GET", "PARTNER_LIST_GET", "PARTNER_CERTIFICATE_GET", "PARTNER_DEFAULT_CERTIFICATE_GET", "PARTNER_KEY_PAIR_GET", "PARTNER_CERTIFICATE_REQUEST_GET", "MESSAGE_TYPE_GET").toList()));
    }

    private void createXpAgreementTemplateRoles() {
        UserRole userRole = new UserRole();
        this.userRoleDAO.save(userRole.setSystemRole(true).setDescription("XP agreement templates edit").setId("ROLE_agreement_template_edit").setPermissions(Stream.of("AGREEMENT_TEMPLATE_DELETE", "AGREEMENT_TEMPLATE_GET", "AGREEMENT_TEMPLATE_POST", "AGREEMENT_TEMPLATE_PUT", "AGREEMENTS_TEMPLATE_IDS_GET").toList()));
        UserRole userRole2 = new UserRole();
        this.userRoleDAO.save(userRole2.setSystemRole(true).setDescription("XP agreements templates view").setId("ROLE_agreement_template_view").setPermissions(Stream.of("AGREEMENT_TEMPLATE_GET", "AGREEMENTS_TEMPLATE_IDS_GET").toList()));
    }

    private void createXpMessageTypes() {
        UserRole userRole = new UserRole();
        this.userRoleDAO.save(userRole.setSystemRole(true).setDescription("XP edit schema").setId("ROLE_schema_edit").setPermissions(Stream.of("MESSAGE_TYPE_GET", "MESSAGE_TYPE_POST").toList()));
        UserRole userRole2 = new UserRole();
        this.userRoleDAO.save(userRole2.setSystemRole(true).setDescription("XP view schema").setId("ROLE_schema_view").setPermissions(Stream.of("MESSAGE_TYPE_GET").toList()));
    }

    private void createXpEditLicence() {
        UserRole userRole = new UserRole();
        this.userRoleDAO.save(userRole.setSystemRole(true).setDescription("XP edit Activation").setId("ROLE_licence_edit").setPermissions(List.of("ACTIVATION_GET", "ACTIVATION_REQUEST_UPDATE_GET", "ACTIVATION_INSTALL_POST")));
        userRole = new UserRole();
        this.userRoleDAO.save(userRole.setSystemRole(true).setDescription("XP view activation").setId("ROLE_licence_view").setPermissions(List.of("ACTIVATION_GET")));
    }

    private void createXpMulticastRules() {
        UserRole userRole = new UserRole();
        this.userRoleDAO.save(userRole.setSystemRole(true).setDescription("XP edit multicast rules").setId("ROLE_multicast_rules_edit").setPermissions(List.of("MESSAGE_MULTICAST_RULES_GET", "MESSAGE_MULTICAST_RULES_PUT", "MESSAGE_TYPE_GET", "PARTNER_LIST_GET")));
        userRole = new UserRole();
        this.userRoleDAO.save(userRole.setSystemRole(true).setDescription("XP view multicast rules").setId("ROLE_multicast_rules_view").setPermissions(List.of("MESSAGE_MULTICAST_RULES_GET", "MESSAGE_TYPE_GET", "PARTNER_LIST_GET")));
    }

    private void createXpHotfolder() {
        UserRole userRole = new UserRole();
        this.userRoleDAO.save(userRole.setSystemRole(true).setDescription("XP edit hotfolder settings").setId("ROLE_hotfolder_edit").setPermissions(List.of("HOTFOLDERS_DELETE", "HOTFOLDERS_GET", "HOTFOLDERS_POST", "HOTFOLDERS_PUT", "PARTNER_LIST_GET")));
        userRole = new UserRole();
        this.userRoleDAO.save(userRole.setSystemRole(true).setDescription("XP view hotfolder settings").setId("ROLE_hotfolder_view").setPermissions(List.of("HOTFOLDERS_GET", "PARTNER_LIST_GET")));
    }

    private void createListener() {
        UserRole userRole = new UserRole();
        this.userRoleDAO.save(userRole.setSystemRole(true).setDescription("XP edit listener settings").setId("ROLE_listener_edit").setPermissions(Arrays.stream(Permissions.class.getDeclaredFields()).map(Field::getName).filter(permission -> permission.startsWith("LISTENER") || permission.equals("CONFIGURATION_GET") || permission.equals("PARTNER_LIST_GET")).toList()));
        userRole = new UserRole();
        this.userRoleDAO.save(userRole.setSystemRole(true).setDescription("XP view listener settings").setId("ROLE_listener_view").setPermissions(Arrays.stream(Permissions.class.getDeclaredFields()).map(Field::getName).filter(permission -> permission.startsWith("LISTENER") || permission.equals("CONFIGURATION_GET") || permission.equals("PARTNER_LIST_GET")).filter(permission -> permission.endsWith("GET")).toList()));
    }

    private void createAdapter() {
        UserRole userRole = new UserRole();
        this.userRoleDAO.save(userRole.setSystemRole(true).setDescription("XP edit adapter settings").setId("ROLE_adapter_edit").setPermissions(List.of("ADAPTERS_GET", "ADAPTERS_STATUS_GET", "ADAPTERS_DELETE")));
        userRole = new UserRole();
        this.userRoleDAO.save(userRole.setSystemRole(true).setDescription("XP view adapter settings").setId("ROLE_adapter_view").setPermissions(List.of("ADAPTERS_GET")));
    }

    private void createTestAdapter() {
        UserRole userRole = new UserRole();
        this.userRoleDAO.save(userRole.setSystemRole(true).setDescription("XP use test adapter").setId("ROLE_test_adapter").setPermissions(List.of("TEST_ADAPTER_POST", "TEST_ADAPTER_PING_GET", "AGREEMENTS_LIST_ITEMS_GET")));
    }

    public void addOnUserRoleChange(Runnable runnable) {
        this.onUserRolesChange.add(runnable);
    }

    public List<String> getSystemRoles() {
        return this.getUserRoles().stream().filter(UserRole::isSystemRole).map(UserRole::getId).toList();
    }
}

