/*
 * Decompiled with CFR 0.152.
 */
package de.pontonconsulting.xmlpipe.security.acegi;

import de.pontonconsulting.xmlpipe.admintool.InstallCertException;
import de.pontonconsulting.xmlpipe.config.IServerConfigBean;
import de.pontonconsulting.xmlpipe.config.SSLKeystoreBean;
import de.pontonconsulting.xmlpipe.config.ServerConfigBeanChangedEvent;
import de.pontonconsulting.xmlpipe.messenger.ReferenceDateTask;
import de.pontonconsulting.xmlpipe.messenger.database.hibernate.MessengerUser;
import de.pontonconsulting.xmlpipe.messenger.database.tables.MessengerUserDAO;
import de.pontonconsulting.xmlpipe.messenger.database.tables.UserRoleDAO;
import de.pontonconsulting.xmlpipe.security.CertificateUtility;
import de.pontonconsulting.xmlpipe.security.acegi.PasswordExpiration;
import de.pontonconsulting.xmlpipe.security.acegi.PontonUser;
import de.pontonconsulting.xmlpipe.security.acegi.UserRoleService;
import de.pontonconsulting.xmlpipe.security.acegi.digester.ObjectFactory;
import de.pontonconsulting.xmlpipe.security.acegi.digester.TomcatUsers;
import dev.samstevens.totp.code.CodeGenerator;
import dev.samstevens.totp.code.CodeVerifier;
import dev.samstevens.totp.code.DefaultCodeGenerator;
import dev.samstevens.totp.code.DefaultCodeVerifier;
import dev.samstevens.totp.secret.DefaultSecretGenerator;
import dev.samstevens.totp.time.SystemTimeProvider;
import dev.samstevens.totp.time.TimeProvider;
import jakarta.annotation.PostConstruct;
import jakarta.xml.bind.JAXBContext;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.security.KeyStoreException;
import java.security.NoSuchProviderException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.time.Instant;
import java.time.OffsetDateTime;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.context.ApplicationListener;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.userdetails.UserDetailsService;
import org.springframework.security.core.userdetails.UsernameNotFoundException;
import org.springframework.security.crypto.password.PasswordEncoder;

public class PontonUserDetailsServiceImpl
implements UserDetailsService,
ApplicationListener<ServerConfigBeanChangedEvent> {
    private static final int MAX_OLD_PASS = 2;
    private static final Logger LOG = LogManager.getLogger((String)"Messenger.PontonUserDetailsServiceImpl");
    private final PasswordEncoder _passwordEncoder;
    private final IServerConfigBean _serverConfigBean;
    private static final String TOMCAT_USERS_XML = "tomcat-users.xml";
    private final SSLKeystoreBean keystoreBean;
    private final UserRoleDAO userRoleDAO;
    private final CertificateUtility certificateUtility;
    private static final JAXBContext TUCONTEXT;
    private static final ObjectFactory FAC;
    private final TimeProvider timeProvider = new SystemTimeProvider();
    private final CodeGenerator codeGenerator = new DefaultCodeGenerator();
    private final CodeVerifier verifier = new DefaultCodeVerifier(this.codeGenerator, this.timeProvider);
    private final MessengerUserDAO messengerUserDAO;
    private final ReferenceDateTask referenceDateTask;
    private final UserRoleService userRoleService;
    private final List<Consumer<String>> userDeleteEventListeners = new ArrayList<Consumer<String>>();

    public PontonUserDetailsServiceImpl(PasswordEncoder passwordEncoder, IServerConfigBean serverConfigBean, SSLKeystoreBean keystoreBean, UserRoleDAO userRoleDAO, CertificateUtility certificateUtility, MessengerUserDAO messengerUserDAO, ReferenceDateTask referenceDateTask, UserRoleService userRoleService) {
        this._passwordEncoder = passwordEncoder;
        this._serverConfigBean = serverConfigBean;
        this.keystoreBean = keystoreBean;
        this.userRoleDAO = userRoleDAO;
        this.certificateUtility = certificateUtility;
        this.messengerUserDAO = messengerUserDAO;
        this.referenceDateTask = referenceDateTask;
        this.userRoleService = userRoleService;
    }

    public MessengerUser loadUserByUsername(String username) throws UsernameNotFoundException {
        return new MessengerUser(this.findUser(username));
    }

    public Authentication createAuthenticationToken(String userName, String newPassword) {
        return new UsernamePasswordAuthenticationToken((Object)userName, (Object)newPassword);
    }

    @PostConstruct
    public void init() throws Exception {
        block9: {
            try {
                String userDataLocationPath = this._serverConfigBean.getRealPath(TOMCAT_USERS_XML);
                File userDataLocationFile = new File(userDataLocationPath);
                if (!userDataLocationFile.exists()) {
                    userDataLocationFile = new File(this._serverConfigBean.getConfigFolder(), TOMCAT_USERS_XML);
                }
                if (!userDataLocationFile.exists() || !this.messengerUserDAO.isEmpty()) break block9;
                try (BufferedInputStream fileInputStream = new BufferedInputStream(Files.newInputStream(userDataLocationFile.toPath(), new OpenOption[0]));){
                    TomcatUsers config = (TomcatUsers)TUCONTEXT.createUnmarshaller().unmarshal((InputStream)fileInputStream);
                    for (TomcatUsers.User user : config.getUser()) {
                        this.addUser(user);
                        user.getOldPassword().forEach(oldPassword -> this.messengerUserDAO.addOldPassword(user.getUsername(), oldPassword.getValue()));
                    }
                }
                Files.delete(userDataLocationFile.toPath());
            }
            catch (IOException e) {
                LOG.error("tomcat-users.xml could not be imported: {}", (Object)e.toString());
            }
        }
    }

    public void setLanguageForUser(String username, String language) {
        if (language != null) {
            Locale locale = Locale.of(language);
            MessengerUser details = this.findUser(username);
            details.setLanguage(locale.getLanguage());
            this.save(details);
        } else {
            MessengerUser details = this.findUser(username);
            details.setLanguage(null);
            this.save(details);
        }
    }

    private MessengerUser findUser(String username) throws UsernameNotFoundException {
        MessengerUser user = this.messengerUserDAO.getUser(username);
        if (user == null) {
            throw new UsernameNotFoundException("unknown user:" + username);
        }
        return user;
    }

    public boolean setCertificateForUser(String username, String certificate) throws InstallCertException, CertificateException, NoSuchProviderException, KeyStoreException {
        X509Certificate storedSslCertificate = this.keystoreBean.getSSLTrustCertificate(username);
        if (certificate != null && !certificate.isEmpty()) {
            X509Certificate newSslCertificate = this.certificateUtility.getX509Certificate(certificate);
            if (!newSslCertificate.equals(storedSslCertificate)) {
                this.keystoreBean.addSSLTrustCertificate(username, newSslCertificate);
            }
        } else if (storedSslCertificate != null) {
            this.keystoreBean.deleteSSLTrustCertificate(username);
        }
        return false;
    }

    private void addUser(TomcatUsers.User user) {
        TomcatUsers.User.Expiration expiration = user.getExpiration();
        String password = user.getPassword();
        if (this.isPasswordMigrationRequired(password)) {
            password = this.encodePassword(user);
        }
        PontonUser details = new PontonUser(user.getUsername(), password, true, true, true, Collections.emptyList(), user.getTotpSecret(), user.isTotpEnabled(), Collections.emptyList());
        if (user.getLanguage() != null) {
            Locale locale = Locale.of(user.getLanguage());
            details.setLocale(locale);
        } else {
            details.setLocale(null);
        }
        if (expiration != null) {
            PasswordExpiration passwordExpiration = new PasswordExpiration(expiration.isEnabled(), expiration.getExpirationDate());
            details.setPasswordExpiration(passwordExpiration);
        }
        details.setRoles(Arrays.asList(user.getRoles().split(",")));
        if (user.getLockedUntil() != null) {
            details.setLockedUntil(user.getLockedUntil());
        }
        this.save(this.convertToMessengerUser(details));
    }

    public void addUser(String username, String password) {
        String hashedPassword = this._passwordEncoder.encode((CharSequence)password);
        MessengerUser messengerUser = new MessengerUser();
        messengerUser.setUsername(username);
        messengerUser.setPassword(hashedPassword);
        messengerUser.setExpiration(this.referenceDateTask.getReferenceOffsetDateTime());
        messengerUser.setExpirationEnabled(true);
        messengerUser.setDisabled(false);
        this.save(messengerUser);
    }

    public void save(MessengerUser messengerUser) {
        this.messengerUserDAO.save(messengerUser);
    }

    public boolean deleteUser(String username) {
        this.userDeleteEventListeners.forEach(action -> action.accept(username));
        return this.messengerUserDAO.deleteUser(username);
    }

    public void setRolesForUser(String username, String[] roles) {
        MessengerUser user = this.messengerUserDAO.getUser(username);
        user.setRoles(Arrays.stream(roles).map(this.userRoleDAO::getUserRoleById).collect(Collectors.toList()));
        this.messengerUserDAO.save(user);
    }

    public void setPasswordForUser(String username, String password, boolean expirePassword) {
        MessengerUser messengerUser = this.findUser(username);
        String newPassword = this._passwordEncoder.encode((CharSequence)password);
        this.messengerUserDAO.addOldPassword(username, messengerUser.getPassword());
        messengerUser.setPassword(newPassword);
        messengerUser.setExpirationEnabled(true);
        messengerUser.setExpiration(expirePassword ? this.referenceDateTask.getReferenceOffsetDateTime() : this.createDefaultExpirationDate());
        this.save(messengerUser);
    }

    private OffsetDateTime createDefaultExpirationDate() {
        return this.referenceDateTask.getReferenceOffsetDateTime().plusYears(this._serverConfigBean.getUserPasswordValidity() != 0 ? (long)this._serverConfigBean.getUserPasswordValidity() : 1L);
    }

    public void onApplicationEvent(ServerConfigBeanChangedEvent event) {
        LOG.debug("ServerConfigBeanChanged Event was triggered, update all password expirations.");
        this.updatePasswordExpirations();
    }

    public boolean isTotpEnabled(String username) {
        MessengerUser details = this.findUser(username);
        return details.getTotpEnabled();
    }

    public void updateTotpEnabled(String username, boolean isTotpEnabled) {
        MessengerUser details = this.findUser(username);
        details.setTotpEnabled(isTotpEnabled);
        this.save(details);
    }

    public String generateTotpSecret() {
        DefaultSecretGenerator secretGenerator = new DefaultSecretGenerator();
        return secretGenerator.generate();
    }

    public void updateTotpSecret(String username, String totpSecret) {
        MessengerUser details = this.findUser(username);
        details.setTotpSecret(totpSecret);
        this.save(details);
    }

    public boolean isValidTotp(String username, String totp) {
        MessengerUser details = this.findUser(username);
        String secret = details.getTotpSecret();
        return this.verifier.isValidCode(secret, totp);
    }

    public boolean isTwoFactorsEnforced() {
        return this._serverConfigBean.isTwoFactorsEnforced();
    }

    private synchronized void updatePasswordExpirations() {
        for (MessengerUser user : new HashSet<MessengerUser>(this.messengerUserDAO.getAll())) {
            try {
                this.updatePasswordExpiration(user);
            }
            catch (Exception ex) {
                LOG.warn(ex.getMessage());
            }
        }
    }

    private void updatePasswordExpiration(MessengerUser user) {
        OffsetDateTime newExpirationDate = this.createDefaultExpirationDate();
        if (user.getExpiration() == null) {
            user.setExpiration(this.createDefaultExpirationDate());
            user.setExpirationEnabled(true);
        } else {
            if (user.getExpiration().isAfter(newExpirationDate)) {
                user.setExpiration(newExpirationDate);
            }
            user.setExpirationEnabled(true);
        }
        this.save(user);
    }

    private String encodePassword(TomcatUsers.User user) {
        String password = user.getPassword();
        if (this.isPasswordMigrationRequired(password)) {
            LOG.info("Migrating password for user {}", (Object)user.getUsername());
            password = this.migratePassword(password, user.getSalt());
        }
        return password;
    }

    private String migratePassword(String password, String salt) {
        return StringUtils.isEmpty((CharSequence)salt) ? "{SHA-1}" + password : "{SHA-512}{" + salt + "}" + password;
    }

    private MessengerUser convertToMessengerUser(PontonUser user) {
        MessengerUser messengerUser = new MessengerUser();
        messengerUser.setUsername(user.getUsername());
        messengerUser.setPassword(user.getPassword());
        messengerUser.setDisabled(!user.isEnabled());
        if (user.getPasswordExpiration() != null) {
            messengerUser.setExpirationEnabled(user.getPasswordExpiration().isEnabled());
            messengerUser.setExpiration(user.getPasswordExpiration().getExpirationDate() != null ? OffsetDateTime.ofInstant(Instant.ofEpochMilli(user.getPasswordExpiration().getExpirationDate().getTime()), ZoneId.of("UTC")) : null);
        } else {
            messengerUser.setExpirationEnabled(false);
            messengerUser.setExpiration(null);
        }
        if (user.getLockedUntil() != null) {
            messengerUser.setLockedUntil(OffsetDateTime.ofInstant(Instant.ofEpochMilli(user.getLockedUntil().getTime()), ZoneId.of("UTC")));
        }
        messengerUser.setRoles(user.getRoles().stream().map(this.userRoleDAO::getUserRoleById).filter(Objects::nonNull).collect(Collectors.toList()));
        messengerUser.setTotpSecret(user.getTotpSecret());
        messengerUser.setTotpEnabled(user.isTotpEnabled());
        messengerUser.setFailedLoginAttempts(user.getFailedAttemptCount());
        messengerUser.setLanguage(user.getLocale() != null ? user.getLocale().getLanguage() : null);
        return messengerUser;
    }

    private boolean isPasswordMigrationRequired(String password) {
        return !password.startsWith("{");
    }

    public void addUserDeleteEventListener(Consumer<String> consumer) {
        this.userDeleteEventListeners.add(consumer);
    }

    public void removeUserDeleteEventListener(Consumer<String> consumer) {
        this.userDeleteEventListeners.remove(consumer);
    }

    static {
        FAC = new ObjectFactory();
        JAXBContext context = null;
        try {
            context = JAXBContext.newInstance((Class[])new Class[]{TomcatUsers.class});
        }
        catch (Exception exception) {
            // empty catch block
        }
        TUCONTEXT = context;
    }
}

