/*
 * Decompiled with CFR 0.152.
 */
package de.pontonconsulting.xmlpipe.security.acegi;

import de.pontonconsulting.xmlpipe.security.acegi.OldUserPassword;
import de.pontonconsulting.xmlpipe.security.acegi.PasswordExpiration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.atomic.AtomicInteger;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.userdetails.User;

public class PontonUser
extends User {
    private static final long serialVersionUID = -1417998612346449469L;
    private Locale _locale;
    private PasswordExpiration _passwordExpiration;
    private List<OldUserPassword> _oldPasswords;
    private AtomicInteger _failedAttempts;
    private List<String> roles;
    private Date _lockedUntil;
    private String totpSecret;
    private boolean totpEnabled;

    public PontonUser(String username, String password, boolean enabled, boolean accountNonExpired, boolean accountNonLocked, Collection<? extends GrantedAuthority> authorities, String totpSecret, boolean totpEnabled, List<String> roles) {
        super(username, password, enabled, accountNonExpired, true, accountNonLocked, authorities);
        this.roles = roles;
        this.totpSecret = totpSecret;
        this.totpEnabled = totpEnabled;
        this._failedAttempts = new AtomicInteger(0);
    }

    public Locale getLocale() {
        return this._locale;
    }

    public void setLocale(Locale locale) {
        this._locale = locale;
    }

    public PasswordExpiration getPasswordExpiration() {
        return this._passwordExpiration;
    }

    public void setPasswordExpiration(PasswordExpiration passwordExpiration) {
        this._passwordExpiration = passwordExpiration;
    }

    public void addOldUserPassword(OldUserPassword oldPassword) {
        this.getOldUserPasswords().add(oldPassword);
    }

    public List<OldUserPassword> getOldUserPasswords() {
        if (this._oldPasswords == null) {
            this._oldPasswords = new ArrayList<OldUserPassword>();
        }
        return this._oldPasswords;
    }

    public void setOldUserPasswords(List<OldUserPassword> oldUserPasswords) {
        this._oldPasswords = oldUserPasswords;
    }

    public boolean isCredentialsNonExpired() {
        if (this._passwordExpiration == null) {
            return super.isCredentialsNonExpired();
        }
        return this.isNotExpired();
    }

    private boolean isNotExpired() {
        boolean result = true;
        if (this._passwordExpiration.isEnabled()) {
            Date now;
            Date expirationDate = this._passwordExpiration.getExpirationDate();
            result = expirationDate.compareTo(now = new Date()) > 0;
        }
        return result;
    }

    public void setLockedUntil(Date date) {
        this._lockedUntil = date;
    }

    public Date getLockedUntil() {
        return this._lockedUntil;
    }

    public void increaseFailedAttemptCount() {
        this._failedAttempts.incrementAndGet();
    }

    public int getFailedAttemptCount() {
        return this._failedAttempts.get();
    }

    public void resetFailedAttemptCount() {
        this._failedAttempts.set(0);
    }

    public void setFailedAttemptCount(int failedAttemptCount) {
        this._failedAttempts.set(failedAttemptCount);
    }

    public String getTotpSecret() {
        return this.totpSecret;
    }

    public void setTotpSecret(String totpSecret) {
        this.totpSecret = totpSecret;
    }

    public boolean isTotpEnabled() {
        return this.totpEnabled;
    }

    public void setTotpEnabled(boolean totpEnabled) {
        this.totpEnabled = totpEnabled;
    }

    public List<String> getRoles() {
        return this.roles;
    }

    public PontonUser setRoles(List<String> roles) {
        this.roles = roles;
        return this;
    }
}

