/*
 * Decompiled with CFR 0.152.
 */
package de.pontonconsulting.xmlpipe.security;

import com.unboundid.ldap.sdk.LDAPException;
import de.pontonconsulting.xmlpipe.TempFileCreator;
import de.pontonconsulting.xmlpipe.messenger.ReferenceDateTask;
import de.pontonconsulting.xmlpipe.messenger.transport.HttpProvider;
import de.pontonconsulting.xmlpipe.messenger.transport.ProviderResponse;
import de.pontonconsulting.xmlpipe.messenger.transport.TransportException;
import de.pontonconsulting.xmlpipe.security.ldap.LdapConnectionPool;
import jakarta.xml.bind.JAXBException;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.security.cert.CRLException;
import java.security.cert.CRLReason;
import java.security.cert.CertificateFactory;
import java.security.cert.CertificateRevokedException;
import java.security.cert.X509CRL;
import java.security.cert.X509CRLEntry;
import java.security.cert.X509Certificate;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.ReentrantLock;
import javax.security.auth.x500.X500Principal;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.bouncycastle.asn1.ASN1IA5String;
import org.bouncycastle.asn1.ASN1InputStream;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.x509.CRLDistPoint;
import org.bouncycastle.asn1.x509.DistributionPoint;
import org.bouncycastle.asn1.x509.DistributionPointName;
import org.bouncycastle.asn1.x509.Extension;
import org.bouncycastle.asn1.x509.GeneralName;
import org.bouncycastle.asn1.x509.GeneralNames;

public class RevocationVerifier {
    private static final Logger LOG = LogManager.getLogger((String)"Messenger.RevocationVerifier");
    public static final int DOWNLOAD_TIMEOUT = 10;
    public static final int DOWNLOAD_CACHE_EXPIRY_MINUTES = 30;
    private final ReentrantLock lock = new ReentrantLock(true);
    private final TempFileCreator tempFileCreator;
    private final HttpProvider httpProvider;
    private final CertificateFactory certificateFactory;
    private final ReferenceDateTask referenceDateTask;
    private final Map<String, CrlCacheEntry> crlCache;
    private final LdapConnectionPool ldapConnectionPool;

    public RevocationVerifier(TempFileCreator tempFileCreator, HttpProvider httpProvider, CertificateFactory certificateFactory, ReferenceDateTask referenceDateTask, LdapConnectionPool ldapConnectionPool) {
        this.tempFileCreator = tempFileCreator;
        this.httpProvider = httpProvider;
        this.certificateFactory = certificateFactory;
        this.referenceDateTask = referenceDateTask;
        this.crlCache = new HashMap<String, CrlCacheEntry>();
        this.ldapConnectionPool = ldapConnectionPool;
    }

    public void verifyCertificateCRLs(X509Certificate certificate) throws IOException, CertificateRevokedException {
        LOG.trace("verifying certificate with subject '{}' and serial number '{}'...", (Object)certificate.getSubjectX500Principal(), (Object)certificate.getSerialNumber());
        List<String> distributionPoints = this.getCrlDistributionPoints(certificate);
        if (!distributionPoints.isEmpty()) {
            AtomicBoolean couldCheck = new AtomicBoolean(false);
            for (String distributionPoint : distributionPoints) {
                try {
                    LOG.trace("... checking distribution point '{}'", (Object)distributionPoint);
                    X509CRL crl = this.getCRL(distributionPoint);
                    couldCheck.set(true);
                    if (crl.isRevoked(certificate)) {
                        X509CRLEntry crlEntry = crl.getRevokedCertificate(certificate);
                        CRLReason reason = Objects.requireNonNullElse(crlEntry.getRevocationReason(), CRLReason.UNSPECIFIED);
                        X500Principal issuer = Objects.requireNonNullElse(crl.getIssuerX500Principal(), new X500Principal("cn=unknown"));
                        LOG.warn("certificate is revoked on '{}' by CRL at '{}' {} {}", (Object)crlEntry.getRevocationDate(), (Object)distributionPoint, (Object)reason, (Object)issuer);
                        throw new CertificateRevokedException(crlEntry.getRevocationDate(), reason, crl.getIssuerX500Principal(), Map.of());
                    }
                    LOG.trace("... certificate is not revoked by CRL at '{}'", (Object)distributionPoint);
                }
                catch (InterruptedException i) {
                    Thread.currentThread().interrupt();
                }
                catch (LDAPException | TransportException | JAXBException | IOException | URISyntaxException | CRLException e) {
                    LOG.warn("... error while verifying against distribution point '{}': {}", (Object)distributionPoint, (Object)e.toString());
                }
                catch (RuntimeException e) {
                    LOG.error("... unexpected error while checking:'{}'", (Object)distributionPoint, (Object)e);
                }
            }
            if (!couldCheck.get()) {
                throw new IOException("Could not download CRLs for the given certificate.");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private X509CRL getCRL(String distributionPoint) throws IOException, URISyntaxException, CRLException, TransportException, InterruptedException, LDAPException, JAXBException {
        X509CRL crl;
        CrlCacheEntry cacheEntry;
        this.lock.lock();
        try {
            cacheEntry = this.crlCache.get(distributionPoint);
            if (cacheEntry != null && cacheEntry.getTimestamp().plus(30L, ChronoUnit.MINUTES).isBefore(Instant.ofEpochMilli(this.referenceDateTask.getReferenceCurrentTimeMillis()))) {
                LOG.trace("cache entry for {} expired.", (Object)distributionPoint);
                this.crlCache.remove(distributionPoint);
                cacheEntry = null;
            }
        }
        finally {
            this.lock.unlock();
        }
        if (cacheEntry == null) {
            crl = distributionPoint.toLowerCase().startsWith("ldap") ? this.ldapConnectionPool.getX509CRL(distributionPoint) : this.fromHttpURL(distributionPoint);
            LOG.trace("... CRL downloaded from {} ", (Object)distributionPoint);
            this.lock.lock();
            try {
                this.crlCache.put(distributionPoint, new CrlCacheEntry(crl, Instant.ofEpochMilli(this.referenceDateTask.getReferenceCurrentTimeMillis())));
            }
            finally {
                this.lock.unlock();
            }
        } else {
            LOG.trace("... found cache for distribution point '{}'...", (Object)distributionPoint);
            crl = cacheEntry.getCrl();
        }
        return crl;
    }

    private X509CRL fromHttpURL(String crlURL) throws CRLException, IOException, URISyntaxException, TransportException, InterruptedException {
        File crlFile = this.tempFileCreator.createTempFile("crl_", ".crl");
        try {
            X509CRL x509CRL;
            ProviderResponse providerResponse = this.httpProvider.getData(crlFile, null, new URL(crlURL).toURI(), null, null, null, null, 10);
            if (providerResponse.isFailed()) {
                if (providerResponse.getResponseMessage() == null) {
                    throw new IOException("Could not download CRL from " + crlURL);
                }
                throw new IOException(new String(providerResponse.getResponseMessage(), StandardCharsets.UTF_8));
            }
            try (BufferedInputStream inputStream = new BufferedInputStream(Files.newInputStream(crlFile.toPath(), new OpenOption[0]));){
                x509CRL = (X509CRL)this.certificateFactory.generateCRL(inputStream);
            }
            return x509CRL;
        }
        finally {
            Files.deleteIfExists(crlFile.toPath());
        }
    }

    List<String> getCrlDistributionPoints(X509Certificate certificate) throws IOException {
        ArrayList<String> urls = new ArrayList<String>();
        byte[] extension = certificate.getExtensionValue(Extension.cRLDistributionPoints.getId());
        if (extension == null) {
            return urls;
        }
        try (ASN1InputStream oAsnInStream = new ASN1InputStream((InputStream)new ByteArrayInputStream(extension));){
            ArrayList<String> arrayList;
            byte[] crlDpExtOctets = ((DEROctetString)oAsnInStream.readObject()).getOctets();
            try (ASN1InputStream oAsnInStream2 = new ASN1InputStream((InputStream)new ByteArrayInputStream(crlDpExtOctets));){
                for (DistributionPoint distributionPoint : CRLDistPoint.getInstance((Object)oAsnInStream2.readObject()).getDistributionPoints()) {
                    GeneralName[] generalNames;
                    DistributionPointName name = distributionPoint.getDistributionPoint();
                    if (name == null || name.getType() != 0) continue;
                    for (GeneralName generalName : generalNames = GeneralNames.getInstance((Object)name.getName()).getNames()) {
                        if (generalName.getTagNo() != 6) continue;
                        String url = ASN1IA5String.getInstance((Object)generalName.getName()).getString();
                        urls.add(url);
                    }
                }
                arrayList = urls;
            }
            return arrayList;
        }
    }

    private static class CrlCacheEntry {
        private X509CRL crl;
        private Instant timestamp;

        public CrlCacheEntry(X509CRL crl, Instant instant) {
            this.crl = crl;
            this.timestamp = instant;
        }

        public X509CRL getCrl() {
            return this.crl;
        }

        public Instant getTimestamp() {
            return this.timestamp;
        }
    }
}

