/*
 * Decompiled with CFR 0.152.
 */
package de.pontonconsulting.xmlpipe.security;

import de.pontonconsulting.xmlpipe.config.MessengerConfig;
import de.pontonconsulting.xmlpipe.cpp.CppPartner;
import de.pontonconsulting.xmlpipe.cpp.ProfileStoreAccessException;
import de.pontonconsulting.xmlpipe.cpp.Profiles;
import de.pontonconsulting.xmlpipe.messenger.ReferenceDateTask;
import de.pontonconsulting.xmlpipe.security.RevocationVerifier;
import de.pontonconsulting.xmlpipe.security.RevocationVerifierFactory;
import de.pontonconsulting.xmlpipe.security.ldap.LdapServerQueryService;
import java.io.IOException;
import java.security.cert.CertificateRevokedException;
import java.security.cert.X509Certificate;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class RemotePartnerCertificateTrustManager {
    private static final Logger LOG = LogManager.getLogger((String)("Messenger." + RemotePartnerCertificateTrustManager.class.getSimpleName()));
    private final MessengerConfig messengerConfig;
    private final Profiles profiles;
    private final RevocationVerifierFactory revocationVerifierFactory;
    private final ReferenceDateTask referenceDateTask;
    private final LdapServerQueryService ldapServerQueryService;
    private final Lock partnerCheckLock;

    public RemotePartnerCertificateTrustManager(RevocationVerifierFactory revocationVerifierFactory, MessengerConfig messengerConfig, Profiles profiles, ReferenceDateTask referenceDateTask, LdapServerQueryService ldapServerQueryService) {
        this.revocationVerifierFactory = revocationVerifierFactory;
        this.messengerConfig = messengerConfig;
        this.profiles = profiles;
        this.referenceDateTask = referenceDateTask;
        this.ldapServerQueryService = ldapServerQueryService;
        this.partnerCheckLock = new ReentrantLock();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void validateCertificates() {
        this.partnerCheckLock.lock();
        try {
            LOG.info("start remote partner certificate check");
            if (this.messengerConfig.isPartnerCertificateRevocationCheckEnabled()) {
                List<String> allRemoteProfileIds = this.profiles.getRemoteLocalIds();
                RevocationVerifier revocationVerifier = this.revocationVerifierFactory.createRevocationVerifier();
                for (String partnerId : allRemoteProfileIds) {
                    if (Thread.currentThread().isInterrupted()) {
                        return;
                    }
                    CppPartner partner = this.profiles.getProfileForLocalId(partnerId, false);
                    Set<X509Certificate> certificateSet = partner.getAllCertificates();
                    certificateSet.forEach(cert -> this.updateStatus(revocationVerifier, (X509Certificate)cert, partner));
                    this.ldapServerQueryService.updatePartnerCertificatesFromLDAP(partner);
                }
                LOG.info("remote partner certificate check finished");
            }
        }
        catch (Exception e) {
            LOG.error("Error during validateCertificates", (Throwable)e);
        }
        finally {
            this.partnerCheckLock.unlock();
        }
    }

    private void updateStatus(RevocationVerifier revocationVerifier, X509Certificate certificate, CppPartner partner) {
        try {
            revocationVerifier.verifyCertificateCRLs(certificate);
            partner.setCertificateRevoked(certificate, false);
            this.updatePartnerProfile(partner);
        }
        catch (IOException e) {
            Optional<Instant> lastSuccessfulCheck = partner.getTimestampOfLastSuccessfulRevocationCheck(certificate);
            if (lastSuccessfulCheck.isEmpty()) {
                partner.setCertificateRevoked(certificate, false);
                this.updatePartnerProfile(partner);
            } else if (Instant.ofEpochMilli(this.referenceDateTask.getReferenceDate().getTime()).minus(3L, ChronoUnit.DAYS).isAfter(lastSuccessfulCheck.get())) {
                LOG.warn("Certificate {} was temporarily revoked because communication with CRL server did not work since {}.", (Object)certificate.getSubjectX500Principal().getName(), lastSuccessfulCheck);
                partner.setCertificateRevoked(certificate, true);
                this.updatePartnerProfile(partner);
            }
        }
        catch (CertificateRevokedException e) {
            LOG.warn("Certificate {} was revoked with reason {}", (Object)certificate.getSubjectX500Principal().getName(), (Object)e.getRevocationReason());
            partner.setCertificateRevoked(certificate, true);
            this.updatePartnerProfile(partner);
        }
    }

    private void updatePartnerProfile(CppPartner partner) {
        try {
            partner.save();
        }
        catch (ProfileStoreAccessException e) {
            LOG.warn("could not update partner profile {}", (Object)partner.getDisplayName());
        }
    }
}

