/*
 * Decompiled with CFR 0.152.
 */
package de.pontonconsulting.xmlpipe.security;

import de.pontonconsulting.common.io.BeginningCRLFRemovingOutputStream;
import de.pontonconsulting.common.io.CRLFOutputStream;
import de.pontonconsulting.xmlpipe.security.SecurityException;
import jakarta.mail.MessagingException;
import jakarta.mail.internet.MimeBodyPart;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.security.DigestInputStream;
import java.security.DigestOutputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import org.bouncycastle.util.encoders.Base64;

public class MessageDigestCalculator {
    private MimeBodyPart _message;
    private boolean _includeMimeHeaders;
    private boolean _useRFC1848Canonicalisation;
    private MessageDigest _messageDigest;
    private byte[] _digest;
    private String _digestBase64;

    public MessageDigestCalculator(MimeBodyPart message, boolean includeMimeHeaders, String digestAlgorithm, boolean useRFC1848Canonicalisation) throws SecurityException {
        try {
            this._message = message;
            this._includeMimeHeaders = includeMimeHeaders;
            this._useRFC1848Canonicalisation = useRFC1848Canonicalisation;
            this._messageDigest = MessageDigest.getInstance(digestAlgorithm, "BC");
        }
        catch (NoSuchProviderException nspe) {
            throw new SecurityException(41000, "Unable to create MessageDigestCalculator. SecurityProvier cannot be found", nspe);
        }
        catch (NoSuchAlgorithmException nsae) {
            throw new SecurityException(41000, "Unable to create MessageDigestCalculator. DigestAlgorithm cannot be found", nsae);
        }
    }

    public byte[] getDigest() throws SecurityException {
        if (this._digest == null) {
            OutputStream out = null;
            FilterInputStream in = null;
            try {
                if (this._includeMimeHeaders) {
                    DigestOutputStream dOut = new DigestOutputStream(new OutputStream(this){

                        @Override
                        public void write(int b) throws IOException {
                        }
                    }, this._messageDigest);
                    out = this._useRFC1848Canonicalisation ? new CRLFOutputStream(dOut) : new BeginningCRLFRemovingOutputStream(dOut);
                    this._message.writeTo(out);
                    out.flush();
                    this._digest = dOut.getMessageDigest().digest();
                    this._digestBase64 = new String(Base64.encode((byte[])this._digest));
                } else {
                    in = new DigestInputStream(this._message.getInputStream(), this._messageDigest);
                    byte[] buffer = new byte[65536];
                    while (in.read(buffer) != -1) {
                    }
                    this._digest = ((DigestInputStream)in).getMessageDigest().digest();
                    this._digestBase64 = new String(Base64.encode((byte[])this._digest));
                }
            }
            catch (MessagingException me) {
                throw new SecurityException(41000, "Unable to calculate the message digest.", me);
            }
            catch (IOException ioe) {
                throw new SecurityException(41000, "Unable to calculate the message digest.", ioe);
            }
            finally {
                if (in != null) {
                    try {
                        in.close();
                    }
                    catch (Exception exception) {}
                }
                if (out != null) {
                    try {
                        out.close();
                    }
                    catch (Exception exception) {}
                }
            }
        }
        return this._digest;
    }

    public String getDigestBase64() throws SecurityException {
        if (this._digestBase64 == null) {
            this.getDigest();
        }
        return this._digestBase64;
    }
}

