/*
 * Decompiled with CFR 0.152.
 */
package de.pontonconsulting.xmlpipe.security;

import de.pontonconsulting.xmlpipe.config.KeystoreBean;
import de.pontonconsulting.xmlpipe.messenger.ReferenceDateTask;
import de.pontonconsulting.xmlpipe.security.CertificateUtility;
import de.pontonconsulting.xmlpipe.security.DecryptionCrypto;
import de.pontonconsulting.xmlpipe.security.SignatureVerificationCrypto;
import de.pontonconsulting.xmlpipe.security.util.SignCertInfo;
import java.security.cert.X509Certificate;
import java.util.List;
import org.apache.wss4j.common.crypto.Crypto;

public class CryptoFactory {
    private final CertificateUtility certificateUtility;
    private final KeystoreBean keystoreBean;
    private final ReferenceDateTask referenceDateTask;

    public CryptoFactory(CertificateUtility certificateUtility, KeystoreBean keystoreBean, ReferenceDateTask referenceDateTask) {
        this.certificateUtility = certificateUtility;
        this.keystoreBean = keystoreBean;
        this.referenceDateTask = referenceDateTask;
    }

    public Crypto createSignatureVerificationCrypto(List<X509Certificate> certificates) {
        return new SignatureVerificationCrypto(certificates, this.certificateUtility, this.keystoreBean, this.referenceDateTask);
    }

    public Crypto createDecryptionCrypto(List<SignCertInfo> signCertInfos) {
        return new DecryptionCrypto(this.certificateUtility, this.keystoreBean, signCertInfos, this.referenceDateTask);
    }
}

