/*
 * Decompiled with CFR 0.152.
 */
package de.pontonconsulting.xmlpipe.security;

import de.pontonconsulting.xmlpipe.security.CryptoUtil;
import java.io.IOException;
import java.math.BigInteger;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509Certificate;
import javax.security.auth.x500.X500Principal;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.cert.X509CertificateHolder;

public class CertificateInfo {
    private final X500Name _issuer;
    private final BigInteger _serial;

    public CertificateInfo(X500Name issuer, BigInteger serial) {
        this._issuer = issuer;
        this._serial = serial;
    }

    public CertificateInfo(X509Certificate certificate) {
        X500Name issuer = null;
        BigInteger serial = null;
        try {
            X509CertificateHolder holder = CryptoUtil.createCertificateHolder(certificate);
            issuer = holder.getIssuer();
            serial = holder.getSerialNumber();
        }
        catch (IOException | CertificateEncodingException e) {
            e.printStackTrace();
        }
        this._issuer = issuer;
        this._serial = serial;
    }

    public X500Name getIssuer() {
        return this._issuer;
    }

    public String getIssuerString() {
        try {
            X500Principal principle = new X500Principal(this._issuer.getEncoded());
            return principle.getName("RFC1779");
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public BigInteger getSerial() {
        return this._serial;
    }
}

