/*
 * Decompiled with CFR 0.152.
 */
package de.pontonconsulting.xmlpipe.security;

import java.io.IOException;
import java.math.BigInteger;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Provider;
import java.security.SecureRandom;
import java.security.Security;
import java.util.Date;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.asn1.cmp.PKIBody;
import org.bouncycastle.asn1.crmf.CertReqMessages;
import org.bouncycastle.asn1.crmf.CertReqMsg;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.asn1.x509.GeneralName;
import org.bouncycastle.cert.cmp.CMPException;
import org.bouncycastle.cert.cmp.ProtectedPKIMessage;
import org.bouncycastle.cert.cmp.ProtectedPKIMessageBuilder;
import org.bouncycastle.cert.crmf.CRMFException;
import org.bouncycastle.cert.crmf.CertificateRequestMessage;
import org.bouncycastle.cert.crmf.PKMACBuilder;
import org.bouncycastle.cert.crmf.PKMACValuesCalculator;
import org.bouncycastle.cert.crmf.jcajce.JcaCertificateRequestMessageBuilder;
import org.bouncycastle.cert.crmf.jcajce.JcePKMACValuesCalculator;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.operator.ContentSigner;
import org.bouncycastle.operator.OperatorCreationException;
import org.bouncycastle.operator.jcajce.JcaContentSignerBuilder;

public class CRMFBuilder {
    private static final ASN1ObjectIdentifier BSI_DE = new ASN1ObjectIdentifier("0.4.0.127.0.7");
    private static final ASN1ObjectIdentifier BSI_DE_ID_CERT_REQ_MSGS = new ASN1ObjectIdentifier(BSI_DE.getId() + ".4.1.1.1");
    private static final ASN1ObjectIdentifier BSI_DE_ID_CERT_REQ_MSGS_WITH_OUTER_SIGNATURE = new ASN1ObjectIdentifier(BSI_DE.getId() + ".4.1.1.2");

    public static void main(String[] args) throws NoSuchAlgorithmException, NoSuchProviderException, CRMFException, IOException, CMPException, OperatorCreationException {
        Security.addProvider((Provider)new BouncyCastleProvider());
        KeyPairGenerator keyPairGenerator = KeyPairGenerator.getInstance("RSA", "BC");
        keyPairGenerator.initialize(2048);
        KeyPair keyPair = keyPairGenerator.generateKeyPair();
        SecureRandom random = new SecureRandom();
        BigInteger certReqId = BigInteger.valueOf(System.nanoTime());
        byte[] senderNonce = new byte[16];
        random.nextBytes(senderNonce);
        ContentSigner signer = new JcaContentSignerBuilder("SHA256WithRSAEncryption").setProvider("BC").build(keyPair.getPrivate());
        CertificateRequestMessage certReqMsg = new CertificateRequestMessage(new JcaCertificateRequestMessageBuilder(certReqId).setPublicKey(keyPair.getPublic()).setSubject(new X500Name("CN=BC Test")).setProofOfPossessionSigningKeySigner(signer).build().getEncoded());
        DERSequence asn1Sequence = new DERSequence(new ASN1Encodable[]{BSI_DE_ID_CERT_REQ_MSGS, new CertReqMessages(new CertReqMsg[]{certReqMsg.toASN1Structure(), certReqMsg.toASN1Structure()})});
        Files.write(Path.of("pkiMessage2.dat", new String[0]), asn1Sequence.getEncoded(), new OpenOption[0]);
        X500Name sender = new X500Name("CN=BC Test");
        X500Name recipient = new X500Name("CN=Bouncy Castle Test CA");
        String hmacPassword = "password";
        ProtectedPKIMessage pkiMessage = new ProtectedPKIMessageBuilder(new GeneralName(sender), new GeneralName(recipient)).setMessageTime(new Date()).setSenderNonce(senderNonce).setBody(new PKIBody(0, (ASN1Encodable)new CertReqMessages(new CertReqMsg[]{certReqMsg.toASN1Structure()}))).build(new PKMACBuilder((PKMACValuesCalculator)new JcePKMACValuesCalculator().setProvider("BC")).build("password".toCharArray()));
        ProtectedPKIMessage pkiMessage2 = new ProtectedPKIMessageBuilder(new GeneralName(sender), new GeneralName(recipient)).setMessageTime(new Date()).setSenderNonce(senderNonce).setBody(new PKIBody(7, (ASN1Encodable)new CertReqMessages(new CertReqMsg[]{certReqMsg.toASN1Structure(), certReqMsg.toASN1Structure()}))).build(signer);
    }
}

