/*
 * Decompiled with CFR 0.152.
 */
package de.pontonconsulting.xmlpipe.registry.client;

import de.pontonconsulting.xmlpipe.Constants;
import de.pontonconsulting.xmlpipe.TempFileCreator;
import de.pontonconsulting.xmlpipe.config.MessengerConfig;
import de.pontonconsulting.xmlpipe.cpp.CppPartner;
import de.pontonconsulting.xmlpipe.registry.RegistryException;
import de.pontonconsulting.xmlpipe.registry.client.RegistryHttpClient;
import de.pontonconsulting.xmlpipe.registry.client.WebDAVResponse;
import jakarta.xml.bind.JAXBException;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.net.ConnectException;
import java.net.URI;
import java.net.URL;
import java.net.URLEncoder;
import java.net.http.HttpRequest;
import java.net.http.HttpTimeoutException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import javax.net.ssl.SSLException;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import org.apache.jackrabbit.webdav.property.DavProperty;
import org.apache.jackrabbit.webdav.property.DavPropertyNameSet;
import org.apache.jackrabbit.webdav.property.DavPropertySet;
import org.apache.jackrabbit.webdav.property.DefaultDavProperty;
import org.apache.jackrabbit.webdav.property.ProppatchInfo;
import org.apache.jackrabbit.webdav.xml.DomUtil;
import org.apache.jackrabbit.webdav.xml.Namespace;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jsoup.Jsoup;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

public class PartnerRegistryClient {
    private static final String AUTHORIZATION_ERROR = "Authorization error. ";
    private static final String PROXY_AUTHORIZATION_ERROR = "Proxy-Authorization error. ";
    public static final String NAMESPACE_DAV = "DAV:";
    public static final String PROPERTY_DISPLAYNAME = "displayname";
    public static final String NAMESPACE_XP = "XP:";
    public static final String PROPERTY_XP_USERAGENT = "useragent";
    private static final Logger LOG = LogManager.getLogger((String)"Messenger.PartnerRegistryClient");
    private final RegistryHttpClient _registryHttpClient;
    private MessengerConfig messengerConfig;
    private TempFileCreator tempFileCreator;

    public PartnerRegistryClient(RegistryHttpClient registryHttpClient, MessengerConfig messengerConfig, TempFileCreator tempFileCreator) {
        this._registryHttpClient = registryHttpClient;
        this.messengerConfig = messengerConfig;
        this.tempFileCreator = tempFileCreator;
    }

    private String getURLEncodedPath(String path) {
        StringBuilder result = new StringBuilder();
        String[] elements = path.split("/");
        for (int i = 0; i < elements.length; ++i) {
            String element = elements[i];
            if (i > 0) {
                result.append("/");
            }
            result.append(URLEncoder.encode(element, StandardCharsets.UTF_8));
        }
        return result.toString();
    }

    private String getFullURL(URL url, String filePath) {
        Object prefixURL = url.toString();
        if (!((String)prefixURL).endsWith("/")) {
            prefixURL = (String)prefixURL + "/";
        }
        return (String)prefixURL + this.getURLEncodedPath(filePath);
    }

    private void uploadFile(byte[] content, String filePath) throws IOException, RegistryException {
        HttpRequest.Builder builder = HttpRequest.newBuilder(URI.create(this.getFullURL(this._registryHttpClient.getRegistryURL(), filePath)));
        WebDAVResponse response = this._registryHttpClient.sendHttpRequest(builder.PUT(HttpRequest.BodyPublishers.ofByteArray(content)));
        this.handleUnsuccessfulResponse(response, "Could not upload file. ");
    }

    public File downloadFile(File tempFile, String filePath) throws RegistryException {
        try {
            HttpRequest.Builder builder = HttpRequest.newBuilder(URI.create(this.getFullURL(this._registryHttpClient.getRegistryURL(), filePath)));
            WebDAVResponse response = this._registryHttpClient.sendHttpRequest(builder.GET());
            this.handleUnsuccessfulResponse(response, "Could not download file. ");
            Files.write(tempFile.toPath(), response.getResponseMessage(), new OpenOption[0]);
        }
        catch (SSLException e) {
            throw new RegistryException(-1, "Communication error. " + e.getMessage());
        }
        catch (HttpTimeoutException toe) {
            throw new RegistryException(-1, "Connection to PartnerRegistry timed out.", toe);
        }
        catch (ConnectException ce) {
            throw new RegistryException(-1, "Connection failed to PartnerRegistry on " + this._registryHttpClient.getRegistryURL().toString(), ce);
        }
        catch (IOException ioe) {
            throw new RegistryException(-1, ioe.getClass().getSimpleName() + " while downloading file from Partner-Registry", ioe);
        }
        return tempFile;
    }

    public void deleteFile(String filePath) throws RegistryException, IOException {
        HttpRequest.Builder builder = HttpRequest.newBuilder(URI.create(this.getFullURL(this._registryHttpClient.getRegistryURL(), filePath)));
        WebDAVResponse response = this._registryHttpClient.sendHttpRequest(builder.DELETE());
        this.handleUnsuccessfulResponse(response, "Could not delete file. ");
    }

    public void changeProperty(String filePath, String nameSpace, String property, String value) throws IOException, RegistryException {
        this.changeProperty(filePath, Namespace.getNamespace((String)nameSpace), property, value);
    }

    public void changeProperty(String filePath, Namespace namespace, String property, String value) throws IOException, RegistryException {
        try (ByteArrayOutputStream xml = new ByteArrayOutputStream();){
            DavPropertySet newProps = new DavPropertySet();
            DavPropertyNameSet removeProperties = new DavPropertyNameSet();
            DefaultDavProperty davProp = new DefaultDavProperty(property, (Object)value, namespace);
            newProps.add((DavProperty)davProp);
            Document doc = DomUtil.createDocument();
            doc.appendChild(new ProppatchInfo(newProps, removeProperties).toXml(doc));
            DomUtil.transformDocument((Document)doc, (OutputStream)xml);
            HttpRequest.Builder builder = HttpRequest.newBuilder(URI.create(this.getFullURL(this._registryHttpClient.getRegistryURL(), filePath)));
            WebDAVResponse response = this._registryHttpClient.sendHttpRequest(builder.method("PROPPATCH", HttpRequest.BodyPublishers.ofByteArray(xml.toByteArray())));
            this.handleUnsuccessfulResponse(response, "Could not change a WebDAV property. ");
        }
        catch (ParserConfigurationException | TransformerException | SAXException e) {
            throw new RuntimeException(e);
        }
    }

    public boolean isRegistryEnabled() {
        try {
            if (this.messengerConfig.isRegistryDownloadEnabled()) {
                this._registryHttpClient.checkRegistrySettings();
                return true;
            }
        }
        catch (RegistryException | JAXBException e) {
            LOG.debug("PartnerRegistry is not enabled: {}", (Object)e.getMessage());
        }
        return false;
    }

    private void handleUnsuccessfulResponse(WebDAVResponse response, String failureMessage) throws RegistryException {
        if (response.isFailed() || response.isAuthorizationFailed()) {
            String responseText = Jsoup.parse((String)response.getResponseText()).wholeText().trim().replaceAll("\n+", "\n");
            if (response.isAuthorizationFailed()) {
                if (response.getHttpResponseCode() == 407) {
                    throw new RegistryException(-1, PROXY_AUTHORIZATION_ERROR + responseText);
                }
                throw new RegistryException(-1, AUTHORIZATION_ERROR + responseText);
            }
            if (response.isFailed()) {
                throw new RegistryException(-1, failureMessage + responseText);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void uploadLocalPartner(CppPartner profile) throws RegistryException {
        try {
            String remoteFile = this.messengerConfig.getRegistryUsername() + "/" + profile.getLocalId() + ".xml";
            if (profile.getRemoteFile() == null || profile.getRemoteFile().trim().isEmpty() || !profile.getRemoteFile().equals(remoteFile)) {
                profile.setRemoteFile(remoteFile);
            }
            try {
                File tempPublicFile = this.tempFileCreator.createTempFile("publicProfile", ".xml");
                try (OutputStream publicOut = Files.newOutputStream(tempPublicFile.toPath(), new OpenOption[0]);){
                    profile.exportPublicPart(publicOut);
                    this.uploadFile(Files.readAllBytes(tempPublicFile.toPath()), remoteFile);
                }
                finally {
                    try {
                        this.tempFileCreator.deleteFile(tempPublicFile);
                    }
                    catch (IOException e) {
                        LOG.error("Could not delete temporary file for profile {}: {}", (Object)profile.getLocalId(), (Object)e.toString());
                    }
                }
            }
            catch (IOException e) {
                LOG.error("Could not upload profile file for profile {}: {}", (Object)profile.getLocalId(), (Object)e.toString());
            }
            try {
                this.changeProperty(remoteFile, NAMESPACE_DAV, PROPERTY_DISPLAYNAME, profile.getDisplayName());
                this.changeProperty(remoteFile, NAMESPACE_XP, PROPERTY_XP_USERAGENT, Constants.getHTTP_XP_NAME());
            }
            catch (RegistryException e) {
                LOG.error("could not set MetaData value for partner profile {}: {}", (Object)profile.getLocalId(), (Object)e.toString());
            }
        }
        catch (RegistryException je) {
            LOG.error("Failed to upload local profile '{}': {}", (Object)profile.getLocalId(), (Object)je.getMessage());
            throw je;
        }
        catch (Exception je) {
            LOG.error("Failed to upload local profile '{}': {}", (Object)profile.getLocalId(), (Object)je.toString());
            throw new RegistryException(-1, "Could not upload profile.", je);
        }
    }

    public void setMessengerConfig(MessengerConfig messengerConfig) {
        this.messengerConfig = messengerConfig;
    }
}

