/*
 * Decompiled with CFR 0.152.
 */
package de.pontonconsulting.xmlpipe.messenger.transport.ssl;

import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Collection;
import java.util.List;
import java.util.StringTokenizer;

public class HostnameChecker {
    private static final String DELIM = ".";
    private static final HostnameChecker INSTANCE_TLS = new HostnameChecker();

    private HostnameChecker() {
    }

    public static HostnameChecker getInstance() {
        return INSTANCE_TLS;
    }

    public void match(String s, X509Certificate x509certificate) throws CertificateException {
        StringBuilder message = new StringBuilder();
        String dn = x509certificate.getSubjectX500Principal().getName();
        String cn = this.getCN(dn);
        if (cn != null && this.isMatched(s, cn)) {
            return;
        }
        message.append("CN '").append(cn).append("' does not match hostname '").append(s).append("'. ");
        Collection<List<?>> collection = x509certificate.getSubjectAlternativeNames();
        if (collection != null) {
            boolean flag = false;
            for (List<?> list : collection) {
                int type = (Integer)list.get(0);
                if (type != 2 && type != 7) continue;
                flag = true;
                String s2 = (String)list.get(1);
                if (!this.isMatched(s, s2)) continue;
                return;
            }
            if (flag) {
                message.append("No subject alternative name matches hostname. ");
            }
        }
        throw new CertificateException(message.toString());
    }

    private boolean isMatched(String s, String s1) {
        return this.matchAllWildcards(s, s1);
    }

    private boolean matchAllWildcards(String s, String s1) {
        s = s.toLowerCase();
        s1 = s1.toLowerCase();
        StringTokenizer stringtokenizer = new StringTokenizer(s, DELIM);
        StringTokenizer stringtokenizer1 = new StringTokenizer(s1, DELIM);
        if (stringtokenizer.countTokens() != stringtokenizer1.countTokens()) {
            return false;
        }
        while (stringtokenizer.hasMoreTokens()) {
            if (this.matchWildCards(stringtokenizer.nextToken(), stringtokenizer1.nextToken())) continue;
            return false;
        }
        return true;
    }

    private boolean matchWildCards(String s, String s1) {
        int i = s1.indexOf("*");
        if (i == -1) {
            return s.equals(s1);
        }
        boolean flag = true;
        String s4 = s1;
        while (i != -1) {
            String s3 = s4.substring(0, i);
            s4 = s4.substring(i + 1);
            int j = s.indexOf(s3);
            if (j == -1 || flag && j != 0) {
                return false;
            }
            flag = false;
            s = s.substring(j + s3.length());
            i = s4.indexOf("*");
        }
        return s.endsWith(s4);
    }

    private String getCN(String dn) {
        int i = 0;
        i = dn.indexOf("CN=");
        if (i == -1) {
            return null;
        }
        dn = dn.substring(i + 3);
        char[] dncs = dn.toCharArray();
        for (i = 0; i < dncs.length && (dncs[i] != ',' || i <= 0 || dncs[i - 1] == '\\'); ++i) {
        }
        return dn.substring(0, i);
    }
}

