/*
 * Decompiled with CFR 0.152.
 */
package de.pontonconsulting.xmlpipe.messenger.transport;

import de.pontonconsulting.xmlpipe.messenger.transport.XpHttpClient;
import de.pontonconsulting.xmlpipe.messenger.transport.XpHttpClientFactory;
import java.net.http.HttpClient;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import java.time.Duration;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;
import java.util.ArrayList;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.scheduling.annotation.Scheduled;

public class XpHttpClientManager {
    public static final long IDLE_TIMEOUT_OF_HTTP_CLIENT = Duration.ofMinutes(10L).toMillis();
    private static final Logger LOG = LogManager.getLogger((String)"Messenger.HttpClientManager");
    private final Map<String, XpHttpClient> cachedHttpClients = new ConcurrentHashMap<String, XpHttpClient>();
    private final AtomicReference<XpHttpClient> cachedTrustAllHttpClientRef = new AtomicReference();
    private final XpHttpClientFactory xpHttpClientFactory;
    private final ExecutorService executor;
    private final ReadWriteLock rwLockForKeyStore = new ReentrantReadWriteLock();
    private final Lock readLock = this.rwLockForKeyStore.readLock();
    private final Lock writeLock = this.rwLockForKeyStore.writeLock();

    public XpHttpClientManager(XpHttpClientFactory xpHttpClientFactory, ExecutorService executor) {
        this.xpHttpClientFactory = xpHttpClientFactory;
        this.executor = executor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HttpClient getHttpClient(PrivateKey clientPrivateKey, X509Certificate[] clientCertificateChain) {
        HttpClient httpClient;
        Object id;
        this.readLock.lock();
        try {
            if (clientCertificateChain != null && clientCertificateChain.length > 0) {
                X509Certificate clientCertificate = clientCertificateChain[0];
                id = clientCertificate.getSubjectX500Principal().toString() + "_" + clientCertificate.getIssuerX500Principal().toString() + "_" + clientCertificate.getSerialNumber().toString();
            } else {
                id = "NO_CLIENT_CERTIFICATE";
            }
            if (this.cachedHttpClients.containsKey(id)) {
                LOG.debug("Getting HttpClient for id '{}'.", id);
                httpClient = this.cachedHttpClients.get(id).updateLastUseTime().getHttpClient();
                return httpClient;
            }
        }
        finally {
            this.readLock.unlock();
        }
        this.writeLock.lock();
        try {
            this.cachedHttpClients.put((String)id, this.xpHttpClientFactory.createXpHttpClient(clientPrivateKey, clientCertificateChain));
            LOG.debug("Created HttpClient for id '{}'.", id);
            LOG.debug("Getting HttpClient for id '{}'.", id);
            httpClient = this.cachedHttpClients.get(id).updateLastUseTime().getHttpClient();
            return httpClient;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    public HttpClient createXpTrustAllHttpClient() {
        this.readLock.lock();
        try {
            if (this.cachedTrustAllHttpClientRef.get() != null) {
                HttpClient httpClient = this.cachedTrustAllHttpClientRef.get().getHttpClient();
                return httpClient;
            }
        }
        finally {
            this.readLock.unlock();
        }
        this.writeLock.lock();
        try {
            this.cachedTrustAllHttpClientRef.set(this.xpHttpClientFactory.createXpTrustAllHttpClient());
            HttpClient httpClient = this.cachedTrustAllHttpClientRef.get().getHttpClient();
            return httpClient;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    @Scheduled(fixedRate=5L, timeUnit=TimeUnit.MINUTES)
    public void purge() {
        ArrayList xpHttpClients2delete = new ArrayList();
        OffsetDateTime now = OffsetDateTime.now(ZoneOffset.UTC);
        this.cachedHttpClients.forEach((id, xpHttpClient) -> {
            if (Duration.between(xpHttpClient.getLastUseTime(), now).toMillis() > IDLE_TIMEOUT_OF_HTTP_CLIENT) {
                this.writeLock.lock();
                try {
                    xpHttpClients2delete.add(this.cachedHttpClients.remove(id));
                    LOG.debug("Removed cached HttpClient with expired idle timeout '{}' and id '{}'", xpHttpClient, id);
                }
                finally {
                    this.writeLock.unlock();
                }
            }
        });
        xpHttpClients2delete.parallelStream().forEach(xpHttpClient -> {
            Future<?> future = this.executor.submit(() -> {
                try {
                    xpHttpClient.shutdown();
                }
                catch (Exception e) {
                    LOG.trace("An error occurs when shutting down the http client.", (Throwable)e);
                }
            });
            try {
                future.get(5L, TimeUnit.SECONDS);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                LOG.trace("The thread to shutdown the http client was interrupted.");
            }
            catch (ExecutionException e) {
                LOG.trace("Error occurs while executing shutdown thread.", (Throwable)e);
            }
            catch (TimeoutException e) {
                LOG.trace("The shutdown task of http client was not completed within 5 seconds. Going to cancel the task.");
                future.cancel(true);
            }
        });
    }
}

