/*
 * Decompiled with CFR 0.152.
 */
package de.pontonconsulting.xmlpipe.messenger.transport;

import de.pontonconsulting.xmlpipe.messenger.transport.HttpProxySelector;
import de.pontonconsulting.xmlpipe.messenger.transport.ssl.SSLKeyManager;
import java.net.http.HttpClient;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import java.time.Duration;
import java.time.OffsetDateTime;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicReference;
import javax.net.ssl.KeyManager;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class XpHttpClient {
    private static final Logger LOG = LogManager.getLogger((String)"Messenger.XpHttpClient");
    private final HttpClient httpClient;
    private final AtomicReference<OffsetDateTime> lastUseTime = new AtomicReference<OffsetDateTime>(OffsetDateTime.now());
    private final X509TrustManager serverCertificateTrustManager;

    XpHttpClient(HttpProxySelector httpProxySelector, PrivateKey key, X509Certificate[] certificateChain, Executor executor, X509TrustManager serverCertificateTrustManager, boolean useHttp1_1Only) {
        this.serverCertificateTrustManager = serverCertificateTrustManager;
        try {
            HttpClient.Builder httpClientBuilder = HttpClient.newBuilder().sslContext(this.getSSLContext(certificateChain, key)).connectTimeout(Duration.ofSeconds(60L)).executor(executor).proxy(httpProxySelector).followRedirects(HttpClient.Redirect.NEVER);
            if (useHttp1_1Only) {
                httpClientBuilder.version(HttpClient.Version.HTTP_1_1);
            }
            this.httpClient = httpClientBuilder.build();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void shutdown() {
        this.httpClient.close();
    }

    private SSLContext getSSLContext(X509Certificate[] certificateChain, PrivateKey key) throws NoSuchAlgorithmException, KeyManagementException, NoSuchProviderException {
        KeyManager[] keyManagers = key != null && certificateChain != null && certificateChain.length > 0 ? new SSLKeyManager[]{new SSLKeyManager(certificateChain, key)} : new SSLKeyManager[]{};
        SSLContext sslContext = SSLContext.getInstance("TLS", "BCJSSE");
        sslContext.init(keyManagers, new TrustManager[]{this.serverCertificateTrustManager}, null);
        return sslContext;
    }

    public HttpClient getHttpClient() {
        return this.httpClient;
    }

    public XpHttpClient updateLastUseTime() {
        this.lastUseTime.set(OffsetDateTime.now());
        return this;
    }

    public OffsetDateTime getLastUseTime() {
        return this.lastUseTime.get();
    }
}

