/*
 * Decompiled with CFR 0.152.
 */
package de.pontonconsulting.xmlpipe.messenger.transport;

import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.UnknownHostException;
import javax.net.SocketFactory;

public class PontonSocketFactory
extends SocketFactory {
    private Proxy _proxy = Proxy.NO_PROXY;

    public void setProxy(String host, int port) {
        this._proxy = new Proxy(Proxy.Type.SOCKS, new InetSocketAddress(host, port));
    }

    @Override
    public Socket createSocket() throws IOException {
        Socket socket = null;
        socket = this._proxy == null || this._proxy.equals(Proxy.NO_PROXY) ? new Socket() : new Socket(this._proxy);
        return socket;
    }

    @Override
    public Socket createSocket(String host, int port) throws UnknownHostException, IOException {
        Socket socket = null;
        if (this._proxy == null || this._proxy.equals(Proxy.NO_PROXY)) {
            socket = new Socket(host, port);
        } else {
            socket = new Socket(this._proxy);
            socket.connect(new InetSocketAddress(host, port));
        }
        return socket;
    }

    @Override
    public Socket createSocket(InetAddress address, int port) throws IOException {
        Socket socket = null;
        if (this._proxy == null || this._proxy.equals(Proxy.NO_PROXY)) {
            socket = new Socket(address, port);
        } else {
            socket = new Socket(this._proxy);
            socket.connect(new InetSocketAddress(address, port));
        }
        return socket;
    }

    @Override
    public Socket createSocket(String host, int port, InetAddress localAddr, int localPort) throws UnknownHostException, IOException {
        Socket socket = null;
        if (this._proxy == null || this._proxy.equals(Proxy.NO_PROXY)) {
            socket = new Socket(host, port, localAddr, localPort);
        } else {
            socket = new Socket(this._proxy);
            socket.connect(new InetSocketAddress(host, port));
        }
        return socket;
    }

    @Override
    public Socket createSocket(InetAddress address, int port, InetAddress localAddr, int localPort) throws IOException {
        Socket socket = null;
        if (this._proxy == null || this._proxy.equals(Proxy.NO_PROXY)) {
            socket = new Socket(address, port, localAddr, localPort);
        } else {
            socket = new Socket(this._proxy);
            socket.connect(new InetSocketAddress(address, port));
        }
        return socket;
    }

    public ServerSocket createServerSocket(int port) throws IOException {
        return new ServerSocket(port);
    }

    public ServerSocket createServerSocket(int port, int backlog) throws IOException {
        return new ServerSocket(port, backlog);
    }

    public ServerSocket createServerSocket(int port, int backlog, InetAddress bindAddr) throws IOException {
        return new ServerSocket(port, backlog, bindAddr);
    }
}

