/*
 * Decompiled with CFR 0.152.
 */
package de.pontonconsulting.xmlpipe.messenger.transport;

import de.pontonconsulting.xmlpipe.config.MessengerConfig;
import de.pontonconsulting.xmlpipe.events.ReloadConfiguration;
import jakarta.xml.bind.JAXBException;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.ProxySelector;
import java.net.SocketAddress;
import java.net.URI;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.context.ApplicationListener;

public class HttpProxySelector
extends ProxySelector
implements ApplicationListener<ReloadConfiguration> {
    private static final List<Proxy> NO_PROXY_LIST = List.of(Proxy.NO_PROXY);
    private static final Logger LOG = LogManager.getLogger((String)"Messenger.ProxySelector");
    private final MessengerConfig messengerConfig;
    private boolean proxyEnabled;
    private List<Proxy> proxyServerList = List.of();
    private List<String> bypassList = List.of();

    public HttpProxySelector(MessengerConfig messengerConfig) {
        this.messengerConfig = messengerConfig;
    }

    @Override
    public List<Proxy> select(URI uri) {
        if (!this.proxyEnabled || this.bypassList.contains(uri.getHost())) {
            return NO_PROXY_LIST;
        }
        this.proxyServerList.stream().findFirst().ifPresent(proxy -> LOG.info("Using {}", proxy));
        return this.proxyServerList;
    }

    @Override
    public void connectFailed(URI uri, SocketAddress sa, IOException ioe) {
        LOG.error("proxy {} connection to {} failed. {}", (Object)sa, (Object)uri, (Object)ioe.toString());
    }

    private void updateConfig() {
        try {
            String proxyHost = this.messengerConfig.getProxyHost();
            if (proxyHost != null && !proxyHost.isBlank()) {
                int proxyPort = this.messengerConfig.getProxyPort();
                InetSocketAddress socket = InetSocketAddress.createUnresolved(proxyHost, proxyPort);
                this.proxyServerList = List.of(new Proxy(Proxy.Type.HTTP, socket));
                this.bypassList = this.messengerConfig.getProxyBypassList();
                LOG.info("using HTTP Proxy Server {}:{}", (Object)proxyHost, (Object)proxyPort);
                this.proxyEnabled = true;
            } else {
                LOG.info("no HTTP Proxy Server is used.");
                this.proxyEnabled = false;
            }
        }
        catch (JAXBException e) {
            LOG.error("could not load proxy configuration {}", (Object)e.toString());
        }
    }

    public void onApplicationEvent(ReloadConfiguration event) {
        if (event.isMessengerConfigChanged()) {
            this.updateConfig();
        }
    }
}

