/*
 * Decompiled with CFR 0.152.
 */
package de.pontonconsulting.xmlpipe.messenger.transport;

import de.pontonconsulting.xmlpipe.config.IMessengerConfigAware;
import de.pontonconsulting.xmlpipe.config.KeystoreBean;
import de.pontonconsulting.xmlpipe.config.MessengerConfig;
import de.pontonconsulting.xmlpipe.messenger.transport.BaseTransportProvider;
import de.pontonconsulting.xmlpipe.messenger.transport.FtpClientAbortTask;
import de.pontonconsulting.xmlpipe.messenger.transport.PontonSocketFactory;
import de.pontonconsulting.xmlpipe.messenger.transport.ProviderResponse;
import de.pontonconsulting.xmlpipe.messenger.transport.TransportException;
import de.pontonconsulting.xmlpipe.messenger.transport.XpMessageInputStream;
import de.pontonconsulting.xmlpipe.messenger.transport.ssl.CertificateTrustManager;
import de.pontonconsulting.xmlpipe.messenger.transport.ssl.SSLKeyManager;
import de.pontonconsulting.xmlpipe.security.PontonAuthenticator;
import jakarta.mail.internet.ParseException;
import jakarta.xml.bind.JAXBException;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.net.Socket;
import java.net.URI;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.security.GeneralSecurityException;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import java.util.HashMap;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import javax.net.SocketFactory;
import javax.net.ssl.KeyManager;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.commons.net.ftp.FTPClient;
import org.apache.commons.net.ftp.FTPReply;
import org.apache.commons.net.ftp.FTPSClient;
import org.bouncycastle.jsse.BCExtendedSSLSession;
import org.bouncycastle.jsse.BCSSLSocket;

public class FtpProvider
extends BaseTransportProvider
implements IMessengerConfigAware {
    private static final String PROTOCOL_FTP = "ftp";
    private static final String PROTOCOL_FTPS = "ftps";
    private static final String FTP_URI = "ftp:";
    private static final String FTPS_URI = "ftps:";
    private static final String ANONYMOUS = "anonymous";
    private static final String DEFAULT_PASSWORD = "xp30@ponton.de";
    private static final String[] NAMES = new String[]{"FTP", "FTPS"};
    private static final String ENCODING_DEFAULT = "binary";
    private static Log _log = LogFactory.getFactory().getInstance("Messenger.FtpProvider");
    private static Timer _abortTimer = new Timer("FtpProvider - AbortTimer", true);
    private MessengerConfig _messengerConfig;
    private PontonAuthenticator _authenticator;
    private KeystoreBean keystoreBean;

    @Override
    public void shutdown() {
        _abortTimer.cancel();
    }

    @Override
    public boolean canHandleUri(String uri) {
        if (uri != null) {
            String lower = uri.toLowerCase();
            return lower.startsWith(FTP_URI) || lower.startsWith(FTPS_URI);
        }
        return false;
    }

    @Override
    public String getDefaultTransferEncoding() {
        return ENCODING_DEFAULT;
    }

    @Override
    public String[] getTransportNames() {
        return NAMES;
    }

    @Override
    public boolean isUsingSynchronousProtocol() {
        return false;
    }

    @Override
    public ProviderResponse sendData(File contentFile, long contentLength, String contentType, HashMap<String, String> outHeader, URI uri, X509Certificate[] certificateChain, PrivateKey key, String user, String password, int retryInterval) throws TransportException {
        throw new TransportException(-1, "The method FtpProvider.sendData() is not yet implemented.");
    }

    @Override
    public ProviderResponse sendMessage(File messageFile, File messageHeaderFile, URI destination, X509Certificate[] chain, PrivateKey key, String user, String password, int retryInterval) throws TransportException {
        long abortTimeout;
        String path;
        ProviderResponse response = new ProviderResponse(destination.getScheme());
        String scheme = destination.getScheme();
        String server = destination.getHost();
        int port = destination.getPort();
        if (port == -1) {
            port = 21;
        }
        if (StringUtils.isBlank((CharSequence)(path = destination.getPath())) || !path.contains("/") || path.endsWith("/")) {
            throw new TransportException(-1, "Invalid FTP URL '" + String.valueOf(destination) + "'. A valid FTP URL looks like: ftp(s)://&lt;host&gt;:&lt;port&gt;/&lt;folder_path&gt;/&lt;filename&gt;");
        }
        int folderEndIndex = path.lastIndexOf(47);
        String folder = path.substring(0, folderEndIndex);
        String filename = path.substring(folderEndIndex + 1);
        String newUser = null;
        String newPassword = null;
        String userInfo = destination.getUserInfo();
        if (userInfo != null) {
            int index = userInfo.indexOf(":");
            if (index == -1) {
                newUser = userInfo;
            } else {
                newUser = userInfo.substring(0, index);
                if (index < userInfo.length()) {
                    newPassword = userInfo.substring(index + 1, userInfo.length());
                }
            }
        }
        if (newUser == null && (newUser = user) == null) {
            newUser = ANONYMOUS;
            _log.warn((Object)("no user name is supplied. use user name '" + newUser + "'."));
        }
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("use user name '" + newUser + "'."));
        }
        if (newPassword == null && (newPassword = password) == null) {
            try {
                newPassword = this._messengerConfig.getSmtpFromAddress();
            }
            catch (JAXBException e) {
                newPassword = null;
            }
            if (newPassword == null) {
                newPassword = DEFAULT_PASSWORD;
            }
            _log.warn((Object)("no password is supplied. use password '" + newPassword + "'."));
        }
        if ((abortTimeout = (long)retryInterval * 1000L) < 1L) {
            abortTimeout = 1000L;
        }
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Ftp timeout set to " + abortTimeout / 1000L + " seconds."));
            _log.debug((Object)("Using protocol '" + scheme + "'."));
        }
        if (scheme != null) {
            if (scheme.toLowerCase().equals(PROTOCOL_FTP)) {
                this.sendFtps(response, false, server, port, newUser, newPassword, chain, key, folder, filename, messageHeaderFile, messageFile, abortTimeout);
            } else if (scheme.toLowerCase().equals(PROTOCOL_FTPS)) {
                this.sendFtps(response, true, server, port, newUser, newPassword, chain, key, folder, filename, messageHeaderFile, messageFile, abortTimeout);
            }
        }
        return response;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void sendFtps(ProviderResponse response, boolean isFtps, String server, int port, String user, String password, X509Certificate[] chain, PrivateKey key, String folder, String fileName, File messageHeaderFile, File messageFile, long abortTimeout) throws TransportException {
        Object ftpClient = null;
        InputStream inputStream = null;
        FtpClientAbortTask abortTask = null;
        try {
            if (isFtps) {
                response.setProtocol(PROTOCOL_FTPS);
                ftpClient = new FTPSClientWithResumeBC(new SSLKeyManager(chain, key), new CertificateTrustManager(this.keystoreBean.getKeystore(), this._messengerConfig));
                ((FTPSClient)ftpClient).setEnabledProtocols(new String[]{"TLSv1.2"});
            } else {
                response.setProtocol(PROTOCOL_FTP);
                ftpClient = new FTPClient();
            }
            ftpClient.setSocketFactory(this.getSocketFactory());
            ftpClient.connect(server, port);
            int replyCode = ftpClient.getReplyCode();
            if (!FTPReply.isPositiveCompletion((int)replyCode)) {
                _log.error((Object)("Could not connect to server '" + server + "' on port " + port + ". FTP server refused connection."));
                throw new IOException("Could not connect to server '" + server + "' on port " + port + ". FTP server refused connection.");
            }
            if (ftpClient.login(user, password)) {
                if (isFtps) {
                    ((FTPSClient)ftpClient).execPBSZ(0L);
                    if (200 != ftpClient.getReplyCode()) {
                        this.handleFtpError(response, (FTPClient)ftpClient);
                        return;
                    }
                    ((FTPSClient)ftpClient).execPROT("P");
                    if (200 != ftpClient.getReplyCode()) {
                        this.handleFtpError(response, (FTPClient)ftpClient);
                        return;
                    }
                }
                ftpClient.setFileType(2);
                ftpClient.changeWorkingDirectory(folder.isEmpty() ? "/" : folder);
                if (ftpClient.getReplyCode() / 100 != 2) {
                    this.handleFtpError(response, (FTPClient)ftpClient);
                    return;
                }
                if (_log.isDebugEnabled()) {
                    _log.debug((Object)ftpClient.getReplyString().trim());
                }
                Map<String, String> headers = this.getHeaders(messageHeaderFile);
                inputStream = this.getInputStream(headers, messageFile);
                ftpClient.enterLocalPassiveMode();
                abortTask = new FtpClientAbortTask((FTPClient)ftpClient);
                if (_log.isDebugEnabled()) {
                    _log.debug((Object)("Sending file '" + fileName + "'."));
                }
                _abortTimer.schedule((TimerTask)abortTask, abortTimeout);
                ftpClient.storeFile(fileName, inputStream);
                replyCode = ftpClient.getReplyCode();
                if (replyCode / 100 != 2) {
                    this.handleFtpError(response, (FTPClient)ftpClient);
                    return;
                }
                if (_log.isDebugEnabled()) {
                    _log.debug((Object)ftpClient.getReplyString().trim());
                }
                abortTask.cancel();
                response.setFailed(false);
                return;
            }
            _log.error((Object)"ftp login failed. user and or password is incorrect.");
            response.setAuthorizationFailed(true);
            response.setResponseMessage((ftpClient.getReplyCode() + " Login failed. User and/or Password incorrect.").getBytes());
            this.addResponseError(response, ftpClient.getReplyCode() + " Login failed. User and/or Password incorrect.");
            return;
        }
        catch (Exception e) {
            if (abortTask != null) {
                if (abortTask.didRun()) {
                    _log.error((Object)("No response for FTP transmission within retry interval: " + e.getMessage()));
                    throw new TransportException(25005, "No response within retry interval: " + e.getMessage());
                }
                try {
                    ftpClient.abort();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                abortTask.cancel();
            }
            _log.fatal((Object)("Error: " + e.toString()));
            throw new TransportException(25006, "Server reply: " + e.getMessage());
        }
        finally {
            if (abortTask != null && !abortTask.didRun()) {
                _abortTimer.purge();
            }
            try {
                inputStream.close();
            }
            catch (Exception exception) {}
            try {
                ftpClient.logout();
            }
            catch (Exception exception) {}
            try {
                ftpClient.disconnect();
            }
            catch (Exception exception) {}
        }
    }

    private void handleFtpError(ProviderResponse response, FTPClient ftpClient) {
        _log.error((Object)ftpClient.getReplyString().trim());
        response.setResponseMessage(ftpClient.getReplyString().trim().getBytes());
        this.addResponseError(response, ftpClient.getReplyString().trim());
    }

    private void addResponseError(ProviderResponse response, String replyText) {
        response.setFailed(true);
        Map<String, String> headers = response.getHeaders();
        if (headers == null) {
            headers = new HashMap<String, String>();
            response.setMimeHeaders(headers);
        }
        headers.put("X-reply-text", replyText);
    }

    private SocketFactory getSocketFactory() throws JAXBException, GeneralSecurityException {
        PontonSocketFactory socketFactory = new PontonSocketFactory();
        String proxyHost = this._messengerConfig.getFtpProxyHost();
        if (proxyHost != null && proxyHost.trim().length() > 0) {
            int proxyPort = this._messengerConfig.getFtpProxyPort();
            socketFactory.setProxy(proxyHost, proxyPort);
            String proxyUser = this._messengerConfig.getFtpProxyUser();
            if (proxyUser != null && proxyUser.length() > 0) {
                String proxyPassword = this._messengerConfig.getFtpProxyPassword();
                this._authenticator.addPasswordAuthentication("socks5", proxyUser, proxyPassword.toCharArray());
            }
        }
        return socketFactory;
    }

    private Map<String, String> getHeaders(File messageHeaderFile) throws IOException, ClassNotFoundException {
        if (!messageHeaderFile.exists()) {
            throw new IOException("Packaged message data is missing. Transmission aborted.");
        }
        try (ObjectInputStream ois = new ObjectInputStream(new BufferedInputStream(Files.newInputStream(messageHeaderFile.toPath(), new OpenOption[0])));){
            HashMap hashMap = (HashMap)ois.readObject();
            return hashMap;
        }
    }

    private InputStream getInputStream(Map<String, String> headers, File messageFile) throws IOException, ParseException {
        if (!messageFile.exists()) {
            throw new IOException("Packaged message data is missing. Transmission aborted.");
        }
        String allowHeader = headers.get("X-allow-header-in-payload");
        if (allowHeader != null) {
            headers.remove("X-allow-header-in-payload");
            if ("false".equals(allowHeader)) {
                return new BufferedInputStream(Files.newInputStream(messageFile.toPath(), new OpenOption[0]));
            }
        }
        return new XpMessageInputStream(headers, messageFile);
    }

    @Override
    public void setMessengerConfig(MessengerConfig messengerConfig) {
        this._messengerConfig = messengerConfig;
    }

    public void setAuthenticator(PontonAuthenticator authenticator) {
        this._authenticator = authenticator;
    }

    public void setKeyStoreBean(KeystoreBean keystoreBean) {
        this.keystoreBean = keystoreBean;
    }

    private static class FTPSClientWithResumeBC
    extends FTPSClient {
        public FTPSClientWithResumeBC(SSLKeyManager sslKeyManager, CertificateTrustManager certificateTrustManager) {
            super(FTPSClientWithResumeBC.createSslContext(sslKeyManager, certificateTrustManager));
        }

        private static SSLContext createSslContext(SSLKeyManager sslKeyManager, CertificateTrustManager certificateTrustManager) {
            try {
                SSLContext sslContext = SSLContext.getInstance("TLSv1.2", "BCJSSE");
                sslContext.init(new KeyManager[]{sslKeyManager}, new TrustManager[]{certificateTrustManager}, new SecureRandom());
                return sslContext;
            }
            catch (KeyManagementException | NoSuchAlgorithmException | NoSuchProviderException e) {
                throw new RuntimeException("Cannot create SSL context.", e);
            }
        }

        protected void _connectAction_() throws IOException {
            super._connectAction_();
            this.execPBSZ(0L);
            this.execPROT("P");
        }

        protected void _prepareDataSocket_(Socket dataSocket) {
            Socket socket = this._socket_;
            if (socket instanceof BCSSLSocket) {
                BCSSLSocket sslSocket = (BCSSLSocket)socket;
                BCExtendedSSLSession bcSession = sslSocket.getBCSession();
                _log.debug((Object)String.format("FTPS connection established (%s) cipher suite: %s", bcSession.getProtocol(), bcSession.getCipherSuite()));
                if (bcSession.isValid() && dataSocket instanceof BCSSLSocket) {
                    BCSSLSocket dataSslSocket = (BCSSLSocket)dataSocket;
                    _log.debug((Object)String.format("linking FTPS data connection to control session (%s) from host %s", bcSession, bcSession.getPeerHost()));
                    dataSslSocket.setBCSessionToResume(bcSession);
                    dataSslSocket.setHost(bcSession.getPeerHost());
                }
            }
        }
    }
}

