/*
 * Decompiled with CFR 0.152.
 */
package de.pontonconsulting.xmlpipe.messenger.service;

import de.pontonconsulting.xmlpipe.message.XpMessage;
import de.pontonconsulting.xmlpipe.messenger.archive.ArchiveProcessor;
import de.pontonconsulting.xmlpipe.messenger.database.FileType;
import de.pontonconsulting.xmlpipe.messenger.database.MessageInfo;
import java.io.File;
import java.util.Objects;

public class FileService {
    private final ArchiveProcessor archiveProcessor;

    public FileService(ArchiveProcessor archiveProcessor) {
        this.archiveProcessor = archiveProcessor;
    }

    public void copyMessageDataToFolder(XpMessage message, MessageInfo info, File destinationFolder) {
        this.archiveProcessor.exportArchiveFiles(info, destinationFolder, new FileType[0]);
        if (Objects.nonNull(message.getCurrentContentReference())) {
            File messageCopy = new File(destinationFolder, message.getCurrentContentReference().getName());
            message.setCurrentContentReference(messageCopy);
        }
        File attachmentFolder = new File(destinationFolder, "attachments");
        message.updateAttachments(attachmentFolder);
    }
}

