/*
 * Decompiled with CFR 0.152.
 */
package de.pontonconsulting.xmlpipe.messenger.packaging;

import de.pontonconsulting.activation.ActivationException;
import de.pontonconsulting.xmlpipe.activation.capability.ICapability;
import de.pontonconsulting.xmlpipe.messenger.packaging.BasePackager;
import de.pontonconsulting.xmlpipe.messenger.packaging.IPackagingManager;
import de.pontonconsulting.xmlpipe.messenger.packaging.PackagingException;
import de.pontonconsulting.xmlpipe.uioption.UIOption;
import jakarta.annotation.PostConstruct;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.springframework.context.ApplicationContext;
import org.springframework.util.Assert;

public class PackagingManager
implements IPackagingManager {
    private final ApplicationContext applicationContext;
    private List<ICapability> capabilities = new LinkedList<ICapability>();

    public PackagingManager(ApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
    }

    @PostConstruct
    public void init() {
        Map tempCapabilities = this.applicationContext.getBeansOfType(ICapability.class);
        for (ICapability capa : tempCapabilities.values()) {
            this.capabilities.add(capa);
        }
        Assert.isTrue((!this.capabilities.isEmpty() ? 1 : 0) != 0, (String)"Can't find any capabilities.");
    }

    @Override
    public String[] getPackagingIds() {
        Map<String, BasePackager> basePackagers = this.getBasePackagersMap();
        return basePackagers.keySet().toArray(new String[basePackagers.keySet().size()]);
    }

    private Map<String, BasePackager> getBasePackagersMap() {
        Map packager = this.applicationContext.getBeansOfType(BasePackager.class);
        HashMap<String, BasePackager> result = new HashMap<String, BasePackager>();
        if (packager != null) {
            result.putAll(packager);
        }
        return result;
    }

    @Override
    public UIOption[] getPackagingOptions(String packagingId) {
        BasePackager basePackager = (BasePackager)this.applicationContext.getBean(packagingId, BasePackager.class);
        if (basePackager != null) {
            try {
                return UIOption.clone(basePackager.getUIOptions());
            }
            catch (CloneNotSupportedException e) {
                return new UIOption[0];
            }
        }
        return new UIOption[0];
    }

    @Override
    public BasePackager getPackager(String packaging) throws ActivationException, PackagingException {
        ICapability packagerCapability = null;
        for (ICapability capa : this.capabilities) {
            if (!capa.isSupported(packaging)) continue;
            packagerCapability = capa;
            break;
        }
        if (packagerCapability == null) {
            throw new PackagingException(24008, "Could not find any capability for Packager " + packaging);
        }
        if (packagerCapability.isCapable()) {
            return (BasePackager)this.applicationContext.getBean(packaging, BasePackager.class);
        }
        throw new ActivationException(1026L, packaging + " messaging is disabled.");
    }
}

