/*
 * Decompiled with CFR 0.152.
 */
package de.pontonconsulting.xmlpipe.messenger.packaging;

import de.pontonconsulting.common.security.IPasswordCrypt;
import de.pontonconsulting.xmlpipe.adapter.activation.MimeTypeMapper;
import de.pontonconsulting.xmlpipe.as.AS1ObjectFactory;
import de.pontonconsulting.xmlpipe.as.AS2ObjectFactory;
import de.pontonconsulting.xmlpipe.as.AS3ObjectFactory;
import de.pontonconsulting.xmlpipe.config.IFolders;
import de.pontonconsulting.xmlpipe.config.IMessengerProperties;
import de.pontonconsulting.xmlpipe.config.KeystoreBean;
import de.pontonconsulting.xmlpipe.config.MessengerConfig;
import de.pontonconsulting.xmlpipe.config.SchemaData;
import de.pontonconsulting.xmlpipe.config.SchemataConfig;
import de.pontonconsulting.xmlpipe.cp.Option;
import de.pontonconsulting.xmlpipe.cp.PartyId;
import de.pontonconsulting.xmlpipe.cpa.Agreements;
import de.pontonconsulting.xmlpipe.cpa.Communication;
import de.pontonconsulting.xmlpipe.cpp.OptionNotFoundException;
import de.pontonconsulting.xmlpipe.cpp.ProfileException;
import de.pontonconsulting.xmlpipe.cpp.Profiles;
import de.pontonconsulting.xmlpipe.listener.AS4Exception;
import de.pontonconsulting.xmlpipe.listener.AS4ProcessorHelper;
import de.pontonconsulting.xmlpipe.listener.ListenerManager;
import de.pontonconsulting.xmlpipe.listener.SoapListener;
import de.pontonconsulting.xmlpipe.message.XpMessage;
import de.pontonconsulting.xmlpipe.messenger.IdGenerator;
import de.pontonconsulting.xmlpipe.messenger.ProcessingResult;
import de.pontonconsulting.xmlpipe.messenger.ReceiveFromListener;
import de.pontonconsulting.xmlpipe.messenger.ReferenceDateTask;
import de.pontonconsulting.xmlpipe.messenger.database.tables.MDNDataDAO;
import de.pontonconsulting.xmlpipe.messenger.database.tables.MessageDAO;
import de.pontonconsulting.xmlpipe.messenger.database.tables.MessageWorkDataDAO;
import de.pontonconsulting.xmlpipe.messenger.database.tables.MessengerLog;
import de.pontonconsulting.xmlpipe.messenger.packaging.AS4Message;
import de.pontonconsulting.xmlpipe.messenger.packaging.AS4Payload;
import de.pontonconsulting.xmlpipe.messenger.packaging.AS4PingMessageConverter;
import de.pontonconsulting.xmlpipe.messenger.packaging.AS4ToSOAPConverter;
import de.pontonconsulting.xmlpipe.messenger.packaging.AS4UIOptions;
import de.pontonconsulting.xmlpipe.messenger.packaging.BasePackager;
import de.pontonconsulting.xmlpipe.messenger.packaging.EbXml20UIOptions;
import de.pontonconsulting.xmlpipe.messenger.packaging.PackagingException;
import de.pontonconsulting.xmlpipe.messenger.transport.ProviderResponse;
import de.pontonconsulting.xmlpipe.security.CertificateUtility;
import de.pontonconsulting.xmlpipe.uioption.UIOption;
import de.pontonconsulting.xmlpipe.util.SOAPMessageUtils;
import jakarta.mail.internet.MimeUtility;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.security.GeneralSecurityException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.xml.soap.SOAPMessage;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.util.Assert;

public class AS4
extends BasePackager {
    public static final String PACKAGERNAME = "AS4";
    private static final Logger _log = LogManager.getLogger((String)"Messenger.AS4");
    public static final String COMPRESSION_FILE_EXTENSION = ".gz";
    private final AS4ToSOAPConverter _as4ToSOAPConverter;
    private final AS4ProcessorHelper _as4ProcessorHelper;
    private final AS4PingMessageConverter as4PingMessageConverter;

    public AS4(AS4PingMessageConverter as4PingMessageConverter, MessengerConfig messengerConfig, ListenerManager listenerManager, MessengerLog messengerLog, MDNDataDAO mdnDataDAO, IPasswordCrypt passwordCrypt, KeystoreBean keystore, Profiles profiles, Agreements agreements, IdGenerator idGenerator, MessageDAO messageDAO, ReferenceDateTask referenceDate, IFolders folders, ReceiveFromListener receiveFromListener, SchemataConfig schemataConfig, IMessengerProperties messengerProperties, CertificateUtility certificateUtility, AS1ObjectFactory as1ObjectFactory, AS2ObjectFactory as2ObjectFactory, AS3ObjectFactory as3ObjectFactory, EbXml20UIOptions ebXml20UIOptions, AS4UIOptions as4UIOptions, AS4ToSOAPConverter as4ToSOAPConverter, AS4ProcessorHelper as4ProcessorHelper, MessageWorkDataDAO messageWorkDataDAO) {
        super(messengerConfig, listenerManager, messengerLog, mdnDataDAO, passwordCrypt, keystore, profiles, agreements, idGenerator, messageDAO, referenceDate, folders, receiveFromListener, schemataConfig, messengerProperties, certificateUtility, as1ObjectFactory, as2ObjectFactory, as3ObjectFactory, ebXml20UIOptions, as4UIOptions, messageWorkDataDAO);
        this.as4PingMessageConverter = as4PingMessageConverter;
        this._as4ToSOAPConverter = as4ToSOAPConverter;
        this._as4ProcessorHelper = as4ProcessorHelper;
    }

    @Override
    public boolean handleTransmissionResponse(long messageDataId, ProviderResponse response) {
        byte[] message = response.getResponseMessage();
        String protocol = response.getProtocol();
        Map<String, String> header = response.getHeaders();
        if (header != null && message != null && message.length > 0) {
            SyncReply reply = new SyncReply(messageDataId, header, message, protocol);
            return reply.process();
        }
        return !response.isFailed();
    }

    @Override
    protected Logger getLogger() {
        return _log;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void storePrequeueingFormat(XpMessage xpMessage, File messageFile, File messageHeaderFile) throws PackagingException {
        this.checkTransportValidity(xpMessage);
        try {
            this._as4ProcessorHelper.isCoveredByLicence(xpMessage);
        }
        catch (AS4Exception e) {
            throw new PackagingException(-1, (Throwable)e);
        }
        try {
            Communication inboundCommunication = xpMessage.getCommunication();
            inboundCommunication.getPackagingOptionValue("/ExpectReceipt");
            xpMessage.setAckRequested(true);
        }
        catch (OptionNotFoundException e) {
            xpMessage.setAckRequested(false);
        }
        File packagingEnvelope = new File(messageFile.getParent(), "packaging_envelope.xml");
        AS4Message as4Message = this.createAS4Message(xpMessage);
        SOAPMessage soapMessage = this._as4ToSOAPConverter.convert(as4Message);
        try {
            if (as4Message.getPayloads().size() > 0 && as4Message.getPayloads().get(0).isCompressed()) {
                long before = as4Message.getPayloads().get(0).getContentFile().length();
                long after = as4Message.getPayloads().get(0).getCompressedSize();
                this.getMessengerLog().log2db(62, xpMessage.getDatabaseId(), " (" + AS4ProcessorHelper.AS4_PACKAGE + ") " + before + " bytes -> " + after + " bytes");
            }
            try {
                soapMessage = this._as4ProcessorHelper.signMessage(soapMessage, xpMessage);
                Assert.notNull((Object)soapMessage, (String)"Soap Message could not signed correctly.");
                soapMessage = this._as4ProcessorHelper.encryptMessage(soapMessage, xpMessage);
                Assert.notNull((Object)soapMessage, (String)"Soap Message could not encrypted correctly.");
            }
            catch (GeneralSecurityException e) {
                throw new PackagingException(-1, (Throwable)e);
            }
            this.writeTo(soapMessage, xpMessage, packagingEnvelope, messageFile, messageHeaderFile);
        }
        finally {
            SOAPMessageUtils.purgeAttachments(soapMessage);
        }
    }

    private void writeTo(SOAPMessage soapMessage, XpMessage xpMessage, File packagingEnvelope, File messageFile, File messageHeaderFile) throws PackagingException {
        try (BufferedOutputStream messageFileOutputStream = new BufferedOutputStream(Files.newOutputStream(messageFile.toPath(), new OpenOption[0]));){
            soapMessage.writeTo((OutputStream)messageFileOutputStream);
        }
        catch (Exception e) {
            throw new PackagingException(-1, "Could not store SOAP Message.", e);
        }
        HashMap<String, String> headers = new HashMap<String, String>();
        Optional.ofNullable(xpMessage.getProcessingDirective("X-CopyOf")).ifPresent(value -> headers.put("X-CopyOf", (String)value));
        Optional.ofNullable(xpMessage.getProcessingDirective("X-OriginalReceiver")).ifPresent(value -> headers.put("X-OriginalReceiver", (String)value));
        String contentType = soapMessage.getMimeHeaders().getHeader("Content-Type")[0];
        headers.put("Content-Type", contentType);
        long size = messageFile.length();
        headers.put("Content-Length", Long.toString(size));
        String originalFilename = xpMessage.getProcessingDirective("OriginalFilename");
        if (StringUtils.isNotEmpty((CharSequence)originalFilename)) {
            String encodedOFilename;
            try {
                encodedOFilename = MimeUtility.encodeText((String)originalFilename);
            }
            catch (UnsupportedEncodingException ex) {
                _log.warn(ex.getMessage());
                encodedOFilename = originalFilename;
            }
            headers.put("X-Original-Filename", encodedOFilename);
        }
        try (ObjectOutputStream headerFileOutputStream = new ObjectOutputStream(new BufferedOutputStream(Files.newOutputStream(messageHeaderFile.toPath(), new OpenOption[0])));){
            headerFileOutputStream.writeObject(headers);
        }
        catch (Exception e) {
            throw new PackagingException(-1, "Could not store header file.", e);
        }
        try (BufferedOutputStream packagingEnvelopeOUT = new BufferedOutputStream(Files.newOutputStream(packagingEnvelope.toPath(), new OpenOption[0]));){
            SOAPMessageUtils.purgeAttachments(soapMessage);
            soapMessage.removeAllAttachments();
            soapMessage.writeTo((OutputStream)packagingEnvelopeOUT);
        }
        catch (Exception e) {
            throw new PackagingException(-1, "Could not store packaging envelope file.", e);
        }
    }

    private String getAS4Parameter(XpMessage xpMessage, String optionPath, String packagingParameter, String defaultValue) {
        String as4Parameter = xpMessage.getProcessingDirective(optionPath);
        if (this.isEmpty(as4Parameter)) {
            _log.trace("Processing directive or given type was empty. Try to use given packaging parameter.");
            as4Parameter = packagingParameter;
        }
        if (this.isEmpty(as4Parameter)) {
            try {
                _log.trace("Given packaging parameter was empty. Try to use packaging option value.");
                as4Parameter = xpMessage.getCommunication().getPackagingOptionValue(optionPath);
            }
            catch (OptionNotFoundException optionNotFoundException) {
                // empty catch block
            }
        }
        if (this.isEmpty(as4Parameter)) {
            _log.trace("AS4 parameter still empty. Using default value.");
            as4Parameter = defaultValue;
        }
        if (as4Parameter != null) {
            as4Parameter = this.replaceWildcardValues(xpMessage, as4Parameter);
        }
        _log.debug("Using AS4 parameter: {} for option path: {}", (Object)as4Parameter, (Object)optionPath);
        return as4Parameter;
    }

    private AS4Message createAS4Message(XpMessage xpMessage) throws PackagingException {
        SchemaData schema = this._as4ProcessorHelper.checkMessageTypeIsAS4Ping(xpMessage) ? this.as4PingMessageConverter.generateAS4PingSchema() : this.getSchemataConfig().getSchemaBySetTypeVersion(xpMessage.getSchemaSet(), xpMessage.getMessageType(), xpMessage.getMessageVersion());
        AS4Message as4Message = new AS4Message();
        as4Message.setMessageId(xpMessage.getMessageId());
        as4Message.setTimestamp(xpMessage.getMessageTimestamp());
        if (!this.isEmptyConversationIdSet(xpMessage)) {
            if (schema.getPackagingParameterConversationId() != null) {
                as4Message.setConversationId(schema.getPackagingParameterConversationId());
            } else {
                as4Message.setConversationId(xpMessage.getConversationId());
            }
        } else {
            as4Message.setConversationId("");
        }
        as4Message.setSchemaLocation(xpMessage.getSchemaLocation());
        as4Message.setSchemaNamespace(xpMessage.getSchemaNamespace());
        as4Message.setSchemaVersion(xpMessage.getMessageVersion());
        String as4Action = this.getAS4Parameter(xpMessage, "/Action", schema.getPackagingParameterAction(), this.getAS4UIOptions().getDefaultAction());
        as4Message.setAction(as4Action);
        String as4Service = this.getAS4Parameter(xpMessage, "/Service", schema.getPackagingParameterService(), this.getAS4UIOptions().getDefaultService());
        as4Message.setService(as4Service);
        String as4ServiceType = this.getAS4Parameter(xpMessage, "/Service/Type", schema.getPackagingParameterServiceType(), null);
        as4Message.setServiceType(as4ServiceType);
        String as4AgreementRef = this.getAS4Parameter(xpMessage, "/AgreementRef", schema.getPackagingParameterAgreementRef(), null);
        as4Message.setAgreementRef(as4AgreementRef);
        String as4AgreementRefType = this.getAS4Parameter(xpMessage, "/AgreementRef/Type", schema.getPackagingParameterAgreementRefType(), null);
        as4Message.setAgreementRefType(as4AgreementRefType);
        String as4AgreementRefPMode = this.getAS4Parameter(xpMessage, "/AgreementRef/PMode", null, null);
        as4Message.setAgreementRefPMode(as4AgreementRefPMode);
        this.validateAgreementRef(as4AgreementRef, as4AgreementRefType);
        try {
            PartyId[] senderIds = xpMessage.getSender().getPartyIds(PACKAGERNAME);
            for (int i = 0; i < senderIds.length; ++i) {
                as4Message.addFromParty(senderIds[i].getType(), senderIds[i].getValue());
            }
        }
        catch (ProfileException e) {
            throw new PackagingException(-1, "Could not determine Party Ids for the sender '" + xpMessage.getSenderLocalId() + "'. " + e.toString());
        }
        String fromRole = this.getAS4Parameter(xpMessage, "/RoleFrom", schema.getPackagingParameterRoleFrom(), null);
        as4Message.setFromRole(fromRole);
        try {
            PartyId[] receiverIds = xpMessage.getReceiver().getPartyIds(PACKAGERNAME);
            for (int i = 0; i < receiverIds.length; ++i) {
                as4Message.addToParty(receiverIds[i].getType(), receiverIds[i].getValue());
            }
        }
        catch (ProfileException e) {
            throw new PackagingException(-1, "Could not determine Party Ids for the receiver '" + xpMessage.getReceiverLocalId() + "'. " + e.toString());
        }
        String toRole = this.getAS4Parameter(xpMessage, "/RoleTo", schema.getPackagingParameterRoleTo(), null);
        as4Message.setToRole(toRole);
        try {
            String value = xpMessage.getCommunication().getPackagingOptionValue("/IncludeMessageProperties");
            if (Boolean.parseBoolean(value)) {
                Option[] subOptions = xpMessage.getCommunication().getPackagingOption("/IncludeMessageProperties").getSubOptions();
                if (subOptions != null && subOptions.length > 0) {
                    HashMap<String, String> customMessageProperties = new HashMap<String, String>();
                    Arrays.stream(subOptions).forEach(option -> customMessageProperties.put(option.getName(), option.getValue()));
                    this.addMessageProperties(xpMessage, as4Message, customMessageProperties);
                } else {
                    Map<String, String> messageRelatedProcessingDirectives = xpMessage.getMessageRelatedProcessingDirectives();
                    this.addMessageProperties(xpMessage, as4Message, messageRelatedProcessingDirectives);
                    Map<String, String> packagingParametersMessageProperties = schema.getPackagingParameterMessageProperties();
                    this.addMessageProperties(xpMessage, as4Message, packagingParametersMessageProperties);
                }
            }
        }
        catch (OptionNotFoundException optionNotFoundException) {
            // empty catch block
        }
        this.addAS4Payloads(xpMessage, schema, as4Message);
        return as4Message;
    }

    private void validateAgreementRef(String as4AgreementRef, String as4AgreementRefType) throws PackagingException {
        if (!(as4AgreementRef == null || as4AgreementRef.isBlank() || this.validURI(as4AgreementRef) || as4AgreementRefType != null && !as4AgreementRefType.isBlank())) {
            throw new PackagingException(-1, "Invalid as4AgreementRef, as4AgreementRefType cannot be null or empty");
        }
    }

    private boolean validURI(String uri) {
        try {
            return new URI(uri).getScheme() != null;
        }
        catch (URISyntaxException e) {
            return false;
        }
    }

    private boolean isEmptyConversationIdSet(XpMessage xpMessage) {
        try {
            return Boolean.parseBoolean(xpMessage.getCommunication().getPackagingOptionValue("/EmptyConversationId"));
        }
        catch (OptionNotFoundException e) {
            return false;
        }
    }

    private void addMessageProperties(XpMessage xpMessage, AS4Message as4Message, Map<String, String> messageProperties) {
        if (messageProperties.size() > 0) {
            for (Map.Entry<String, String> entry : messageProperties.entrySet()) {
                as4Message.addMessageProperty(entry.getKey(), this.replaceWildcardValues(xpMessage, entry.getValue()));
            }
        }
    }

    private void addAS4Payloads(XpMessage xpMessage, SchemaData schema, AS4Message as4Message) {
        if (xpMessage.getCurrentContentReference() != null) {
            if (_log.isDebugEnabled()) {
                _log.debug("adding payload");
            }
            String defaultCID = "payload-" + System.currentTimeMillis();
            String contentId = this.getAS4Parameter(xpMessage, "/CID", schema.getPackagingParameterCID(), defaultCID);
            String contentType = xpMessage.getCurrentContentType();
            if (contentType == null || contentType.length() == 0) {
                contentType = "application/octet-stream";
            }
            boolean compressed = false;
            try {
                compressed = Boolean.parseBoolean(xpMessage.getCommunication().getPackagingOptionValue("/CompressContent"));
            }
            catch (OptionNotFoundException optionNotFoundException) {
                // empty catch block
            }
            Object as4Filename = xpMessage.getProcessingDirective("ProcessedOriginalFilename");
            if (as4Filename == null) {
                as4Filename = contentId + MimeTypeMapper.getExtension((String)contentType);
            }
            if (compressed) {
                as4Filename = (String)as4Filename + COMPRESSION_FILE_EXTENSION;
            }
            AS4Payload as4Payload = new AS4Payload(contentId, contentType, xpMessage.getCurrentContentReference(), (String)as4Filename, compressed);
            try {
                String value = xpMessage.getCommunication().getPackagingOptionValue("/IncludeContentProperties");
                if (Boolean.parseBoolean(value)) {
                    Map<String, String> payloadRelatedProcessingDirectives = xpMessage.getPayloadRelatedProcessingDirectives();
                    this.addContentProperties(xpMessage, as4Payload, payloadRelatedProcessingDirectives);
                    Map<String, String> customerRelatedProcessingDirectives = xpMessage.getCustomerProcessingDirectives();
                    this.addContentProperties(xpMessage, as4Payload, customerRelatedProcessingDirectives);
                    Map<String, String> packagingParametersContentProperties = schema.getPackagingParameterContentProperties();
                    this.addContentProperties(xpMessage, as4Payload, packagingParametersContentProperties);
                    Option[] subOptions = xpMessage.getCommunication().getPackagingOption("/IncludeContentProperties").getSubOptions();
                    if (subOptions != null && subOptions.length > 0) {
                        HashMap<String, String> customContentProperties = new HashMap<String, String>();
                        Arrays.stream(subOptions).forEach(option -> customContentProperties.put(option.getName(), option.getValue()));
                        this.addContentProperties(xpMessage, as4Payload, customContentProperties);
                    }
                }
            }
            catch (OptionNotFoundException optionNotFoundException) {
                // empty catch block
            }
            as4Message.addPayload(as4Payload);
        }
    }

    private void addContentProperties(XpMessage xpMessage, AS4Payload as4Payload, Map<String, String> contentProperties) {
        if (contentProperties.size() > 0) {
            for (Map.Entry<String, String> entry : contentProperties.entrySet()) {
                as4Payload.addProperty(entry.getKey(), this.replaceWildcardValues(xpMessage, entry.getValue()));
            }
        }
    }

    private void checkTransportValidity(XpMessage xpMessage) throws PackagingException {
        String url = xpMessage.getCommunication().getTransportURL().toLowerCase();
        if (!(url.startsWith("http:") || url.startsWith("https:") || url.startsWith("mailto:") || url.startsWith("smime:"))) {
            throw new PackagingException(-1, "AS4-Packager only supports http(s) and mailto/smime transport.");
        }
    }

    @Override
    public XpMessage createAsyncAck(List<ProcessingResult> result, XpMessage xpResponse, boolean signed) {
        return null;
    }

    @Override
    public XpMessage createErrorResponse(List<ProcessingResult> result, XpMessage xpResponse, boolean signed) throws PackagingException {
        return null;
    }

    @Override
    public UIOption[] getUIOptions() {
        return this.getAS4UIOptions().getUIOptions();
    }

    @Override
    public String getPackagingEncryptionPath() {
        return "/EncryptMessage";
    }

    @Override
    public String getPackagingAckSignPath() {
        return "/SendReceipt";
    }

    @Override
    public String getPackagingSignPath() {
        return "/SignMessage";
    }

    class SyncReply {
        final Map<String, String> _headers;
        final byte[] _message;
        final String _protocol;
        final long _referenceDatabaseId;

        SyncReply(long referenceDatabaseId, Map<String, String> headers, byte[] message, String protocol) {
            this._headers = headers;
            this._message = message;
            this._protocol = protocol;
            this._referenceDatabaseId = referenceDatabaseId;
            if (_log.isDebugEnabled()) {
                _log.debug("Created AS4.SyncReply object.");
            }
        }

        boolean process() {
            if (_log.isDebugEnabled()) {
                _log.debug("Trying to process the received sync reply.");
            }
            try {
                SoapListener listener = (SoapListener)AS4.this.getListenerManager().getListener("SoapListener");
                listener.processSyncResponse(this._headers, this._message, this._protocol, this._referenceDatabaseId);
                if (_log.isDebugEnabled()) {
                    _log.debug("Processed the received sync reply.");
                }
                return true;
            }
            catch (Exception e) {
                _log.error("Could not processed the received sync reply: {}", (Object)e.getMessage());
                return false;
            }
        }
    }
}

