/*
 * Decompiled with CFR 0.152.
 */
package de.pontonconsulting.xmlpipe.messenger.packaging;

import de.pontonconsulting.common.security.IPasswordCrypt;
import de.pontonconsulting.xmlpipe.as.AS1ObjectFactory;
import de.pontonconsulting.xmlpipe.as.AS2Message;
import de.pontonconsulting.xmlpipe.as.AS2ObjectFactory;
import de.pontonconsulting.xmlpipe.as.AS3ObjectFactory;
import de.pontonconsulting.xmlpipe.as.ASException;
import de.pontonconsulting.xmlpipe.config.IFolders;
import de.pontonconsulting.xmlpipe.config.IMessengerProperties;
import de.pontonconsulting.xmlpipe.config.KeystoreBean;
import de.pontonconsulting.xmlpipe.config.MessengerConfig;
import de.pontonconsulting.xmlpipe.config.SchemataConfig;
import de.pontonconsulting.xmlpipe.cpa.Agreements;
import de.pontonconsulting.xmlpipe.cpp.OptionNotFoundException;
import de.pontonconsulting.xmlpipe.cpp.Profiles;
import de.pontonconsulting.xmlpipe.listener.AS2Listener;
import de.pontonconsulting.xmlpipe.listener.ListenerManager;
import de.pontonconsulting.xmlpipe.message.XpMessage;
import de.pontonconsulting.xmlpipe.messenger.IdGenerator;
import de.pontonconsulting.xmlpipe.messenger.ReceiveFromListener;
import de.pontonconsulting.xmlpipe.messenger.ReferenceDateTask;
import de.pontonconsulting.xmlpipe.messenger.database.DbException;
import de.pontonconsulting.xmlpipe.messenger.database.tables.MDNDataDAO;
import de.pontonconsulting.xmlpipe.messenger.database.tables.MessageDAO;
import de.pontonconsulting.xmlpipe.messenger.database.tables.MessageWorkDataDAO;
import de.pontonconsulting.xmlpipe.messenger.database.tables.MessengerLog;
import de.pontonconsulting.xmlpipe.messenger.packaging.AS4UIOptions;
import de.pontonconsulting.xmlpipe.messenger.packaging.ASPackager;
import de.pontonconsulting.xmlpipe.messenger.packaging.EbXml20UIOptions;
import de.pontonconsulting.xmlpipe.messenger.packaging.PackagingException;
import de.pontonconsulting.xmlpipe.messenger.transport.ProviderResponse;
import de.pontonconsulting.xmlpipe.security.CertificateUtility;
import de.pontonconsulting.xmlpipe.security.MessageDigestCalculator;
import de.pontonconsulting.xmlpipe.security.SecurityException;
import de.pontonconsulting.xmlpipe.security.smime.SMIMECompressor;
import de.pontonconsulting.xmlpipe.security.smime.SMIMEEncrypter;
import de.pontonconsulting.xmlpipe.security.smime.SMIMESigner;
import de.pontonconsulting.xmlpipe.uioption.UIOption;
import jakarta.mail.internet.InternetHeaders;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.InputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class AS2
extends ASPackager {
    private static final String BINARY = "binary";
    private static final String HTTPS = "https:";
    private static final String HTTP = "http:";
    public static final String PACKAGERNAME = "AS2";
    public static final String ASYNC_REPLY = "/RequestMDN/ASyncReply";
    private static final UIOption[] OPTIONS;
    public static final Logger _log;

    public AS2(MessengerConfig messengerConfig, ListenerManager listenerManager, MessengerLog messengerLog, MDNDataDAO mdnDataDAO, IPasswordCrypt passwordCrypt, KeystoreBean keystore, Profiles profiles, Agreements agreements, IdGenerator idGenerator, MessageDAO messageDAO, ReferenceDateTask referenceDate, IFolders folders, ReceiveFromListener receiveFromListener, SchemataConfig schemataConfig, IMessengerProperties messengerProperties, CertificateUtility certificateUtility, AS1ObjectFactory as1ObjectFactory, AS2ObjectFactory as2ObjectFactory, AS3ObjectFactory as3ObjectFactory, EbXml20UIOptions ebXml20UIOptions, AS4UIOptions as4UIOptions, SMIMECompressor smimeCompressor, SMIMEEncrypter smimeEncrypter, SMIMESigner smimeSigner, MessageWorkDataDAO messageWorkDataDAO) {
        super(messengerConfig, listenerManager, messengerLog, mdnDataDAO, passwordCrypt, keystore, profiles, agreements, idGenerator, messageDAO, referenceDate, folders, receiveFromListener, schemataConfig, messengerProperties, certificateUtility, as1ObjectFactory, as2ObjectFactory, as3ObjectFactory, ebXml20UIOptions, as4UIOptions, smimeCompressor, smimeEncrypter, smimeSigner, messageWorkDataDAO);
        super.setLogger(_log);
    }

    @Override
    public boolean handleTransmissionResponse(long messageDataId, ProviderResponse response) {
        byte[] message = response.getResponseMessage();
        String protocol = response.getProtocol();
        Map<String, String> headers = response.getHeaders();
        if (message != null && headers != null && message.length > 0) {
            SyncReply reply = new SyncReply(messageDataId, headers, message, protocol);
            return reply.process();
        }
        return !response.isFailed();
    }

    @Override
    public void storePrequeueingFormat(XpMessage message, File messageFile, File messageHeaderFile) throws PackagingException {
        this._xpMessage = message;
        this.checkMessageType();
        this.checkTransportValidity();
        try {
            this.createAS2Message();
            if (_log.isTraceEnabled()) {
                _log.trace("AS2 Message created.");
            }
            InternetHeaders headers = this._asMessage.getInternetHeaders();
            Optional.ofNullable(message.getProcessingDirective("X-CopyOf")).ifPresent(value -> headers.setHeader("X-CopyOf", value));
            Optional.ofNullable(message.getProcessingDirective("X-OriginalReceiver")).ifPresent(value -> headers.setHeader("X-OriginalReceiver", value));
            if (this._asMessage.getMimePart().getHeader("Content-Disposition") != null && this._asMessage.getMimePart().getHeader("Content-Disposition").length > 0) {
                headers.setHeader("Content-Disposition", this._asMessage.getMimePart().getHeader("Content-Disposition")[0]);
            }
            headers.setHeader("Content-Transfer-Encoding", BINARY);
            try (BufferedOutputStream out = new BufferedOutputStream(Files.newOutputStream(messageFile.toPath(), new OpenOption[0]));
                 BufferedInputStream in = new BufferedInputStream(this._asMessage.getMimePart().getInputStream());){
                if (_log.isTraceEnabled()) {
                    _log.trace("Storing message.");
                }
                byte[] buffer = null;
                buffer = message.getCurrentContentReference().length() >= 0x100000L ? new byte[0x100000] : new byte[65536];
                int length = -1;
                while ((length = ((InputStream)in).read(buffer)) != -1) {
                    ((OutputStream)out).write(buffer, 0, length);
                }
            }
            headers.addHeader("Content-Length", "" + messageFile.length());
            Map<String, String> headerMap = this.convertInternetHeadersToHashMap(headers);
            try (ObjectOutputStream oos = new ObjectOutputStream(new BufferedOutputStream(Files.newOutputStream(messageHeaderFile.toPath(), new OpenOption[0])));){
                oos.writeObject(headerMap);
            }
            if (_log.isTraceEnabled()) {
                _log.trace("Message successfully stored.");
            }
        }
        catch (ASException ase) {
            throw new PackagingException(24002, ase.getMessage(), ase);
        }
        catch (DbException dbe) {
            throw new PackagingException(24002, dbe.getMessage(), dbe);
        }
        catch (Exception e) {
            throw new PackagingException(24002, (Throwable)e);
        }
        finally {
            if (this._asMessage != null) {
                this._asMessage.closeAllAttachmentDataSources();
            }
        }
    }

    private void createAS2Message() throws ASException, DbException {
        this._asMessage = this.getAs2ObjectFactory().createAS2Message(this._xpMessage);
        String option = "";
        try {
            option = this._xpMessage.getCommunication().getPackagingOptionValue(ASYNC_REPLY);
        }
        catch (OptionNotFoundException optionNotFoundException) {
            // empty catch block
        }
        this.prepareMessage(option);
        if (StringUtils.isNotBlank((CharSequence)option)) {
            ((AS2Message)this._asMessage).getMDNParameters().setAsyncMDNRecipient(option);
            ((AS2Message)this._asMessage).getMDNParameters().setSyncReplyRequested(false);
        } else {
            ((AS2Message)this._asMessage).getMDNParameters().setSyncReplyRequested(true);
        }
    }

    @Override
    protected MessageDigestCalculator createMessageDigestCalculator(String digestAlgorithm) throws SecurityException {
        return new MessageDigestCalculator(this._asMessage.getMimePart(), this._includeHeaderInDigestCalculation, digestAlgorithm, false);
    }

    @Override
    public UIOption[] getUIOptions() {
        return OPTIONS;
    }

    @Override
    protected boolean preHandleTransmissionResponse(long messageId, ProviderResponse response) {
        return true;
    }

    private void checkTransportValidity() throws PackagingException {
        String url = this._xpMessage.getCommunication().getTransportURL().toLowerCase();
        if (!url.startsWith(HTTP) && !url.startsWith(HTTPS)) {
            throw new PackagingException(24002, "AS2 packager only supports http(s) transport.");
        }
    }

    private void checkMessageType() throws PackagingException {
        if ("PING".equals(this._xpMessage.getMessageType()) && "ponton".equals(this._xpMessage.getSchemaSet()) && "2.1".equals(this._xpMessage.getMessageVersion())) {
            throw new PackagingException(24001, "AS2 packager doesn't support pings");
        }
    }

    static {
        _log = LogManager.getLogger((String)"Messenger.AS2Packager");
        UIOption async = new UIOption("packagingOption.as2.asyncreply", ASYNC_REPLY, "string", "", "hilfe_header_asyncreply", "packagingOption.as2.asyncreply", "packagingOption.agreement.help.as2.asyncreply", "packagingOption.profile.help.as2.asyncreply", UIOption.NONE);
        async.setVisibility(UIOption.VISIBILITY.OUTBOUND);
        UIOption UIOPTION_SMIME_SIGNATURE_MDN = new UIOption("packagingOption.as2.sign.message.mdn", "/SmimeMdnSignature", "list", "SHA-1 signed,SHA-224 signed,SHA-256 signed,SHA-384 signed,SHA-512 signed,SHA-1/PSS signed,SHA-224/PSS signed,SHA-256/PSS signed,SHA-384/PSS signed,SHA-512/PSS signed,SHA-256/ECDSA signed,SHA-384/ECDSA signed,SHA-512/ECDSA signed,MD5 signed,Same as business signature", "hilfe_smime_mdn_signature", "packagingOption.as2.sign.message.mdn", "packagingOption.agreement.help.as2.sign.message.mdn", "packagingOption.profile.help.as2.sign.message.mdn", UIOption.NONE, "Same as business signature", "none");
        OPTIONS = new UIOption[]{UIOPTION_REQUEST_MDN, async, UIOPTION_SIGN, UIOPTION_SMIME_SIGNATURE_MDN, UIOPTION_COMPRESS, UIOPTION_ENCRYPT, UIOPTION_EXTENDED_ENCRYPTION_ALGORITHM, UIOPTION_DUPLICATE_ELIMINATION};
    }

    class SyncReply {
        final Map<String, String> _headers;
        final byte[] _message;
        final String _protocol;
        final long _referenceDatabaseId;

        SyncReply(long referenceDatabaseId, Map<String, String> headers, byte[] message, String protocol) {
            this._referenceDatabaseId = referenceDatabaseId;
            this._headers = headers;
            this._message = message;
            this._protocol = protocol;
            if (_log.isDebugEnabled()) {
                _log.debug("Created AS2.SyncReply object.");
            }
        }

        boolean process() {
            if (_log.isDebugEnabled()) {
                _log.debug("Trying to process the received sync reply.");
            }
            try {
                AS2Listener listener = (AS2Listener)AS2.this.getListenerManager().getListener("AS2Listener");
                listener.processSyncResponse(this._headers, this._message, this._protocol);
                if (_log.isDebugEnabled()) {
                    _log.debug("Processed the received sync reply.");
                }
                return true;
            }
            catch (Exception e) {
                _log.error("Could not processed the received sync reply: {}", (Object)e.getMessage());
                return false;
            }
        }
    }
}

