/*
 * Decompiled with CFR 0.152.
 */
package de.pontonconsulting.xmlpipe.messenger.packaging;

import de.pontonconsulting.common.encoding.Base64Encoder;
import de.pontonconsulting.common.security.IPasswordCrypt;
import de.pontonconsulting.xmlpipe.as.AS1ObjectFactory;
import de.pontonconsulting.xmlpipe.as.AS2ObjectFactory;
import de.pontonconsulting.xmlpipe.as.AS3ObjectFactory;
import de.pontonconsulting.xmlpipe.as.ASException;
import de.pontonconsulting.xmlpipe.config.IFolders;
import de.pontonconsulting.xmlpipe.config.IMessengerProperties;
import de.pontonconsulting.xmlpipe.config.KeystoreBean;
import de.pontonconsulting.xmlpipe.config.MessengerConfig;
import de.pontonconsulting.xmlpipe.config.SchemataConfig;
import de.pontonconsulting.xmlpipe.cpa.Agreements;
import de.pontonconsulting.xmlpipe.cpa.Communication;
import de.pontonconsulting.xmlpipe.cpp.CppPartner;
import de.pontonconsulting.xmlpipe.cpp.OptionNotFoundException;
import de.pontonconsulting.xmlpipe.cpp.ProfileException;
import de.pontonconsulting.xmlpipe.cpp.Profiles;
import de.pontonconsulting.xmlpipe.listener.ListenerManager;
import de.pontonconsulting.xmlpipe.message.XpMessage;
import de.pontonconsulting.xmlpipe.messenger.IdGenerator;
import de.pontonconsulting.xmlpipe.messenger.ReceiveFromListener;
import de.pontonconsulting.xmlpipe.messenger.ReferenceDateTask;
import de.pontonconsulting.xmlpipe.messenger.database.DbException;
import de.pontonconsulting.xmlpipe.messenger.database.tables.MDNDataDAO;
import de.pontonconsulting.xmlpipe.messenger.database.tables.MessageDAO;
import de.pontonconsulting.xmlpipe.messenger.database.tables.MessageWorkDataDAO;
import de.pontonconsulting.xmlpipe.messenger.database.tables.MessengerLog;
import de.pontonconsulting.xmlpipe.messenger.packaging.AS4UIOptions;
import de.pontonconsulting.xmlpipe.messenger.packaging.ASPackager;
import de.pontonconsulting.xmlpipe.messenger.packaging.EbXml20UIOptions;
import de.pontonconsulting.xmlpipe.messenger.packaging.PackagingException;
import de.pontonconsulting.xmlpipe.messenger.transport.ProviderResponse;
import de.pontonconsulting.xmlpipe.security.CertificateUtility;
import de.pontonconsulting.xmlpipe.security.MessageDigestCalculator;
import de.pontonconsulting.xmlpipe.security.SecurityException;
import de.pontonconsulting.xmlpipe.security.smime.SMIMECompressor;
import de.pontonconsulting.xmlpipe.security.smime.SMIMEEncrypter;
import de.pontonconsulting.xmlpipe.security.smime.SMIMESigner;
import de.pontonconsulting.xmlpipe.uioption.UIOption;
import jakarta.mail.BodyPart;
import jakarta.mail.MessagingException;
import jakarta.mail.Multipart;
import jakarta.mail.Session;
import jakarta.mail.internet.InternetHeaders;
import jakarta.mail.internet.MimeBodyPart;
import jakarta.mail.internet.MimeMessage;
import jakarta.mail.internet.MimeMultipart;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.InputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class AS1
extends ASPackager {
    public static final String PACKAGERNAME = "AS1";
    private static final UIOption[] OPTIONS;
    public static final Logger _log;

    public AS1(MessengerConfig messengerConfig, ListenerManager listenerManager, MessengerLog messengerLog, MDNDataDAO mdnDataDAO, IPasswordCrypt passwordCrypt, KeystoreBean keystore, Profiles profiles, Agreements agreements, IdGenerator idGenerator, MessageDAO messageDAO, ReferenceDateTask referenceDate, IFolders folders, ReceiveFromListener receiveFromListener, SchemataConfig schemataConfig, IMessengerProperties messengerProperties, CertificateUtility certificateUtility, AS1ObjectFactory as1ObjectFactory, AS2ObjectFactory as2ObjectFactory, AS3ObjectFactory as3ObjectFactory, EbXml20UIOptions ebXml20UIOptions, AS4UIOptions as4UIOptions, SMIMECompressor smimeCompressor, SMIMEEncrypter smimeEncrypter, SMIMESigner smimeSigner, MessageWorkDataDAO messageWorkDataDAO) {
        super(messengerConfig, listenerManager, messengerLog, mdnDataDAO, passwordCrypt, keystore, profiles, agreements, idGenerator, messageDAO, referenceDate, folders, receiveFromListener, schemataConfig, messengerProperties, certificateUtility, as1ObjectFactory, as2ObjectFactory, as3ObjectFactory, ebXml20UIOptions, as4UIOptions, smimeCompressor, smimeEncrypter, smimeSigner, messageWorkDataDAO);
        this.setLogger(_log);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void storePrequeueingFormat(XpMessage message, File messageFile, File messageHeaderFile) throws PackagingException {
        this._xpMessage = message;
        this.checkMessageType();
        this.checkTransportValidity();
        try {
            String emailPartyId;
            this.createAS1Message();
            if (_log.isTraceEnabled()) {
                _log.trace("AS1 Message created.");
            }
            InternetHeaders headers = this._asMessage.getInternetHeaders();
            Optional.ofNullable(message.getProcessingDirective("X-CopyOf")).ifPresent(value -> headers.setHeader("X-CopyOf", value));
            Optional.ofNullable(message.getProcessingDirective("X-OriginalReceiver")).ifPresent(value -> headers.setHeader("X-OriginalReceiver", value));
            if (this._asMessage.getMimePart().getHeader("Content-Disposition") != null && this._asMessage.getMimePart().getHeader("Content-Disposition").length > 0) {
                headers.setHeader("Content-Disposition", this._asMessage.getMimePart().getHeader("Content-Disposition")[0]);
            }
            try {
                String subjectOption = this._xpMessage.getCommunication().getPackagingOptionValue("/Subject");
                if (subjectOption.trim().length() > 0) {
                    headers.setHeader("Subject", subjectOption);
                }
            }
            catch (OptionNotFoundException subjectOption) {
                // empty catch block
            }
            OutputStream messageOut = null;
            InputStream in = null;
            try {
                int length;
                String[] encoding = headers.getHeader("Content-Transfer-Encoding");
                String[] contentType = headers.getHeader("Content-Type");
                if (!(contentType[0].startsWith("multipart/") || encoding != null && encoding[0].equals("base64"))) {
                    headers.setHeader("Content-Transfer-Encoding", "base64");
                    messageOut = new Base64Encoder(new BufferedOutputStream(Files.newOutputStream(messageFile.toPath(), new OpenOption[0])));
                } else {
                    messageOut = new BufferedOutputStream(Files.newOutputStream(messageFile.toPath(), new OpenOption[0]));
                }
                if (this._asMessage.getMimePart().getContent() instanceof Multipart) {
                    MimeMessage mimeMessage = new MimeMessage((Session)null);
                    mimeMessage.setContent((Multipart)this._asMessage.getMimePart().getContent());
                    mimeMessage.saveChanges();
                    in = mimeMessage.getInputStream();
                } else {
                    in = this._asMessage.getMimePart().getInputStream();
                }
                if (_log.isTraceEnabled()) {
                    _log.trace("Storing message.");
                }
                byte[] buffer = message.getCurrentContentReference().length() >= 0x100000L ? new byte[0x100000] : new byte[65536];
                while ((length = in.read(buffer)) != -1) {
                    messageOut.write(buffer, 0, length);
                }
            }
            finally {
                if (in != null) {
                    in.close();
                }
                if (messageOut != null) {
                    messageOut.close();
                }
            }
            headers.setHeader("Content-Length", "" + messageFile.length());
            try {
                CppPartner ownPartner = this.getProfiles().getProfileForLocalId(message.getAgreement().getOwnPartner().getId(), true);
                emailPartyId = ownPartner.getPartyIdValue("E-Mail");
            }
            catch (ProfileException e) {
                throw new ASException(43010, "Sender is not set.");
            }
            if (StringUtils.isBlank((CharSequence)emailPartyId)) {
                emailPartyId = this.getMessengerConfig().getSmtpFromAddress();
            }
            if (StringUtils.isBlank((CharSequence)emailPartyId)) {
                throw new IllegalArgumentException("SMTP from address was empty.");
            }
            this._asMessage.setFrom(emailPartyId);
            headers.setHeader("From", emailPartyId);
            Map<String, String> headerMap = this.convertInternetHeadersToHashMap(headers);
            try (ObjectOutputStream oos = new ObjectOutputStream(new BufferedOutputStream(Files.newOutputStream(messageHeaderFile.toPath(), new OpenOption[0])));){
                oos.writeObject(headerMap);
            }
            if (_log.isTraceEnabled()) {
                _log.trace("Message successfully stored.");
            }
        }
        catch (ASException | DbException ase) {
            throw new PackagingException(24002, ase.getMessage(), ase);
        }
        catch (Exception e) {
            throw new PackagingException(24002, (Throwable)e);
        }
        finally {
            if (this._asMessage != null) {
                this._asMessage.closeAllAttachmentDataSources();
            }
        }
    }

    private void createAS1Message() throws ASException, DbException {
        String mdnTo;
        block7: {
            this._asMessage = this.getAs1ObjectFactory().createAS1Message(this._xpMessage);
            try {
                String bodyText = this._xpMessage.getCommunication().getPackagingOptionValue("/WithBody");
                if (bodyText.trim().length() <= 0) break block7;
                try {
                    MimeBodyPart bodyMimePart = new MimeBodyPart();
                    bodyMimePart.setText(bodyText);
                    MimeMultipart multiPart = new MimeMultipart("mixed");
                    multiPart.addBodyPart((BodyPart)bodyMimePart);
                    multiPart.addBodyPart((BodyPart)this._asMessage.getMimePart());
                    MimeBodyPart helpMimePart = new MimeBodyPart();
                    helpMimePart.setContent((Multipart)multiPart);
                    helpMimePart.setHeader("Content-Type", multiPart.getContentType());
                    this._asMessage.setMimePart(helpMimePart);
                }
                catch (MessagingException e) {
                    throw new ASException(-1, (Throwable)e);
                }
            }
            catch (OptionNotFoundException bodyText) {
                // empty catch block
            }
        }
        try {
            String senderLocalId = this._xpMessage.getCommunication().getSenderLocalId();
            String partyIdValue = this.getProfiles().getProfileForLocalId(senderLocalId, true).getPartyIdValue("E-Mail");
            mdnTo = StringUtils.isNotBlank((CharSequence)partyIdValue) ? partyIdValue : this.getMessengerConfig().getSmtpFromAddress();
            if (StringUtils.isBlank((CharSequence)mdnTo)) {
                throw new ASException(-1, "MDN to address was not set.");
            }
        }
        catch (Exception ex) {
            _log.error(ex.getMessage());
            throw new ASException(-1, (Throwable)ex);
        }
        this.prepareMessage(mdnTo);
    }

    @Override
    protected MessageDigestCalculator createMessageDigestCalculator(String digestAlgorithm) throws SecurityException {
        return new MessageDigestCalculator(this._asMessage.getMimePart(), this._includeHeaderInDigestCalculation, digestAlgorithm, true);
    }

    @Override
    public UIOption[] getUIOptions() {
        return OPTIONS;
    }

    @Override
    protected boolean preHandleTransmissionResponse(long messageId, ProviderResponse response) {
        if (this._asMessage != null && this._asMessage.isHandleResponse()) {
            return !response.isFailed();
        }
        return true;
    }

    @Override
    protected boolean isNoAckNeeded(Communication communication) throws OptionNotFoundException {
        return !this.needSmtpResponse(communication);
    }

    private boolean needSmtpResponse(Communication communication) {
        try {
            return "SMTP response".equals(communication.getPackagingOptionValue("/RequestMDN"));
        }
        catch (OptionNotFoundException e) {
            return false;
        }
    }

    @Override
    protected boolean isAckRequired() {
        return super.isAckRequired() || this.needSmtpResponse(this._xpMessage.getCommunication());
    }

    private void checkTransportValidity() throws PackagingException {
        String url = this._xpMessage.getCommunication().getTransportURL().toLowerCase();
        if (!url.startsWith("mailto:") && !url.startsWith("smime:")) {
            throw new PackagingException(24002, "AS1 packager only supports email transport.");
        }
    }

    private void checkMessageType() throws PackagingException {
        if ("PING".equals(this._xpMessage.getMessageType()) && "ponton".equals(this._xpMessage.getSchemaSet()) && "2.1".equals(this._xpMessage.getMessageVersion())) {
            throw new PackagingException(24001, "AS1 packager doesn't support pings");
        }
    }

    static {
        _log = LogManager.getLogger((String)"Messenger.AS1Packager");
        UIOption requestMDN = UIOPTION_REQUEST_MDN;
        try {
            requestMDN = UIOption.clone(new UIOption[]{UIOPTION_REQUEST_MDN})[0];
            requestMDN.setValues(requestMDN.getValues() + ",SMTP response");
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            // empty catch block
        }
        UIOption subject = new UIOption("packagingOption.as.subject", "/Subject", "string", "", "hilfe_header_subject", "packagingOption.as.subject", "packagingOption.agreement.help.as.subject", "packagingOption.profile.help.as.subject", UIOption.NONE);
        subject.setVisibility(UIOption.VISIBILITY.OUTBOUND);
        UIOption withBody = new UIOption("packagingOption.as.withbody", "/WithBody", "string", "", "hilfe_header_withbody", "packagingOption.as.withbody", "packagingOption.agreement.help.as.withbody", "packagingOption.profile.help.as.withbody", UIOption.NONE);
        withBody.setVisibility(UIOption.VISIBILITY.OUTBOUND);
        UIOption mailClientSupport = new UIOption("packagingOption.as.mail_client_support", "/MailClientSupport", "boolean", "", "hilfe_header_mailclientsupport", "packagingOption.as.mail_client_support", "packagingOption.agreement.help.as.mail_client_support", "packagingOption.profile.help.as.mail_client_support", UIOption.NONE);
        mailClientSupport.setVisibility(UIOption.VISIBILITY.INBOUND);
        OPTIONS = new UIOption[]{requestMDN, UIOPTION_SIGN, UIOPTION_COMPRESS, UIOPTION_ENCRYPT, UIOPTION_EXTENDED_ENCRYPTION_ALGORITHM, UIOPTION_DUPLICATE_ELIMINATION, subject, withBody, mailClientSupport};
    }
}

