/*
 * Decompiled with CFR 0.152.
 */
package de.pontonconsulting.xmlpipe.messenger.migration;

import de.pontonconsulting.common.security.IPasswordCrypt;
import de.pontonconsulting.xmlpipe.config.KeystoreBean;
import de.pontonconsulting.xmlpipe.config.MessengerConfig;
import de.pontonconsulting.xmlpipe.config.partnerprofile.Transport;
import de.pontonconsulting.xmlpipe.config.privatepartnerprofile.PrivateKeyPassword;
import de.pontonconsulting.xmlpipe.config.privatepartnerprofile.PrivatePartner;
import de.pontonconsulting.xmlpipe.cpa.Agreement;
import de.pontonconsulting.xmlpipe.cpa.Communication;
import de.pontonconsulting.xmlpipe.cpa.CommunicationNotFoundException;
import de.pontonconsulting.xmlpipe.cpp.CertificateIdNotFoundException;
import de.pontonconsulting.xmlpipe.cpp.CppPartner;
import de.pontonconsulting.xmlpipe.cpp.OptionNotFoundException;
import de.pontonconsulting.xmlpipe.cpp.PackageIdNotFoundException;
import de.pontonconsulting.xmlpipe.cpp.PipelineIdNotFoundException;
import de.pontonconsulting.xmlpipe.cpp.ProfileStoreAccessException;
import de.pontonconsulting.xmlpipe.cpp.Profiles;
import de.pontonconsulting.xmlpipe.cpp.TransportIdNotFoundException;
import de.pontonconsulting.xmlpipe.cpp.util.PrivateKeyPasswordPredicate;
import de.pontonconsulting.xmlpipe.listener.AS4ProcessorHelper;
import de.pontonconsulting.xmlpipe.security.CertificateReader;
import de.pontonconsulting.xmlpipe.security.PontonKeystore;
import de.pontonconsulting.xmlpipe.security.util.SignCertInfo;
import java.security.GeneralSecurityException;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.Predicate;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ConfigMigrationService {
    public static final String COMPATIBILITY_VERSION = "3.3";
    private final Log _log = LogFactory.getLog((String)"Messenger.Migration");
    private final KeystoreBean _keyStoreBean;
    private final MessengerConfig _messengerConfig;
    private final IPasswordCrypt _passwordCrypt;
    private final Profiles _profiles;
    private final CertificateReader _certificate;

    public ConfigMigrationService(KeystoreBean keyStoreBean, MessengerConfig messengerConfig, IPasswordCrypt passwordCrypt, Profiles profiles, CertificateReader certificate) {
        this._keyStoreBean = keyStoreBean;
        this._messengerConfig = messengerConfig;
        this._passwordCrypt = passwordCrypt;
        this._profiles = profiles;
        this._certificate = certificate;
    }

    public boolean migratePartner(CppPartner partner) {
        if (partner.isMigrated()) {
            return false;
        }
        try {
            this.migratePipelineCertToPartnerCert(partner);
            this.migrateSMIMECertToPartnerCert(partner);
            this.updatePartyTypes(partner);
        }
        catch (Exception e) {
            this._log.error((Object)("Could not migrate profile '" + partner.getLocalId() + "': " + e.getMessage()));
        }
        if (partner.isLocal()) {
            this.migratePrivateKeys(partner);
        }
        try {
            partner.save();
        }
        catch (ProfileStoreAccessException ex) {
            this._log.error((Object)ex.getMessage());
        }
        return true;
    }

    private void migrateSMIMECertToPartnerCert(CppPartner partner) throws Exception {
        this.addMissedAS1Otion(partner);
        X509Certificate usedSMIMECertificate = this.deleteAllTransportCertificates(partner);
        String importedCertId = this.addSmimeCertificate(partner, usedSMIMECertificate);
        String defaultCertId = partner.getDefaultCertRefId();
        if (StringUtils.isNotBlank((CharSequence)importedCertId) && StringUtils.isNotBlank((CharSequence)defaultCertId) && !importedCertId.equals(defaultCertId)) {
            this.updatePackage("AS1", partner, importedCertId);
            this.updatePackage("AS2", partner, importedCertId);
            this.updatePackage("AS3", partner, importedCertId);
        }
    }

    private void addMissedAS1Otion(CppPartner partner) {
        try {
            partner.setPackagingOptionValue("AS1", "/RequestMDN", "SHA-1 signed,MD5 signed,unsigned,SMTP response", "list");
        }
        catch (PackageIdNotFoundException e) {
            this._log.warn((Object)("Could not add missed AS1 option for profile '" + partner.getLocalId() + "': " + String.valueOf(e)));
        }
    }

    private void migratePipelineCertToPartnerCert(CppPartner partner) throws PipelineIdNotFoundException, CertificateIdNotFoundException {
        String[] pipelineIds;
        for (String pipelineId : pipelineIds = partner.getPipelineIds()) {
            partner.deleteAllPipelineCertificateOptions(pipelineId);
            String pipelineCertId = partner.getPipelineCertRef(pipelineId);
            partner.setDefaultCertRefId(pipelineCertId);
            partner.setPipelineCertificate(pipelineId, null);
        }
    }

    private void migratePrivateKeys(CppPartner partner) {
        for (X509Certificate cert : partner.getAllCertificates()) {
            try {
                String alias = partner.buildAliasForPartnerCertificate(cert);
                this._log.trace((Object)("Try to install or over write " + alias + " private key."));
                this.migratePrivateKeys(cert, alias, partner);
            }
            catch (Exception ex) {
                this._log.error((Object)ex.getMessage());
            }
        }
    }

    private void migratePrivateKeys(X509Certificate x509Certificate, String alias, CppPartner partner) throws GeneralSecurityException {
        SignCertInfo pkInfo = this.findPrivateKeyPassword(alias, partner);
        if (pkInfo == null) {
            this._log.warn((Object)("Can't find private key for " + alias + " from keystore."));
        } else {
            partner.addPrivateKey(x509Certificate, pkInfo.getPrivateKey(), pkInfo.getPassword());
            this._log.trace((Object)("Successfully installed private key " + alias + " from keystore."));
        }
    }

    private SignCertInfo findPrivateKeyPassword(String alias, CppPartner partner) {
        PrivateKeyPassword pkPass;
        PrivatePartner profile = partner.getPrivatePart();
        if (StringUtils.isNotBlank((CharSequence)alias) && (pkPass = (PrivateKeyPassword)CollectionUtils.find((Collection)profile.getPrivateKeyPassword(), (Predicate)new PrivateKeyPasswordPredicate(alias))) != null) {
            try {
                String passwordDecrypted = this._passwordCrypt.decryptPassword(pkPass.getValue());
                PrivateKey privateKey = this._keyStoreBean.getKeystore().getPrivateKey(alias, passwordDecrypted.toCharArray());
                if (privateKey != null) {
                    return new SignCertInfo(passwordDecrypted, privateKey, null);
                }
                return null;
            }
            catch (GeneralSecurityException e) {
                return null;
            }
        }
        SignCertInfo result = null;
        for (PrivateKeyPassword pkp : profile.getPrivateKeyPassword()) {
            try {
                String passwordDecrypted = this._passwordCrypt.decryptPassword(pkp.getValue());
                PrivateKey privateKey = this._keyStoreBean.getKeystore().getPrivateKey(alias, passwordDecrypted.toCharArray());
                if (privateKey == null) continue;
                result = new SignCertInfo(passwordDecrypted, privateKey, null);
            }
            catch (GeneralSecurityException generalSecurityException) {}
        }
        return result;
    }

    private void updatePartyTypes(CppPartner partner) {
        String localId;
        String email = null;
        List<Transport> transports = partner.getTransportList();
        for (Transport transport : transports) {
            String url = transport.getURL();
            if (url.toLowerCase().startsWith("mailto:")) {
                email = url.substring(7);
                break;
            }
            if (!url.toLowerCase().startsWith("smime:")) continue;
            email = url.substring(6);
            break;
        }
        if (StringUtils.isNotBlank(email) && (localId = this._profiles.getLocalId("E-Mail", email)) == null) {
            partner.addPartyId("E-Mail", email);
        }
    }

    private void updatePackage(String packagingId, CppPartner partner, String certId) {
        if (StringUtils.isNotEmpty((CharSequence)certId)) {
            try {
                partner.setPackagingCertificate(packagingId, certId);
            }
            catch (Exception e) {
                this._log.warn((Object)("Could not migrate profile '" + partner.getLocalId() + "' for packaging '" + packagingId + "': " + e.getMessage()));
            }
        }
    }

    private X509Certificate deleteAllTransportCertificates(CppPartner partner) {
        X509Certificate certificate = null;
        List<Transport> transports = partner.getTransportList();
        for (Transport transport : transports) {
            try {
                String certId = partner.getTransportCertificateId(transport.getId());
                if (!StringUtils.isNotBlank((CharSequence)certId)) continue;
                certificate = partner.getX509Certificate(certId);
                partner.deleteTransportCert(transport.getId());
            }
            catch (CertificateIdNotFoundException | TransportIdNotFoundException e) {
                this._log.warn((Object)("Could not delete transport certificates for partner '" + partner.getLocalId() + "': " + e.getMessage()));
            }
        }
        return certificate;
    }

    public Agreement migrateAgreement(Agreement agreement) {
        if (!agreement.isMigrated()) {
            try {
                Communication communication1 = agreement.getCommunication(agreement.getPartner1LocalId(), agreement.getPartner2LocalId());
                this.updatePackage(communication1);
                this.updatePipeline(communication1);
                Communication communication2 = agreement.getCommunication(agreement.getPartner2LocalId(), agreement.getPartner1LocalId());
                this.updatePackage(communication2);
                this.updatePipeline(communication2);
            }
            catch (CommunicationNotFoundException e) {
                this._log.error((Object)("Could not migrate agreement: partner1 '" + agreement.getPartner1LocalId() + "', partner2 '" + agreement.getPartner2LocalId() + "'."));
            }
            try {
                agreement.save();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return agreement;
    }

    private void updatePipeline(Communication communication) {
        this.updatePipelineCertificateOption(communication, "/sign");
        this.updatePipelineCertificateOption(communication, "/Encryption");
    }

    private void updatePipelineCertificateOption(Communication communication, String optionPath) {
        try {
            String certId = communication.getPipelineOptionCertAlias(optionPath);
            communication.setPipelineOptionCert(optionPath, certId);
        }
        catch (OptionNotFoundException | PipelineIdNotFoundException idNotFoundException) {
            // empty catch block
        }
    }

    private void updatePackage(Communication communication) {
        String packagingId = communication.getPackagingId();
        if (AS4ProcessorHelper.AS4_PACKAGE.equals(packagingId)) {
            this.updatePackagingCertificateOption(communication, "/SignMessage");
            this.updatePackagingCertificateOption(communication, "/EncryptMessage");
            this.updatePackagingCertificateOption(communication, "/SendReceipt");
        } else if ("EbXml20".equals(packagingId)) {
            this.updatePackagingCertificateOption(communication, "/XmlSignature");
        }
    }

    private void updatePackagingCertificateOption(Communication communication, String optionPath) {
        try {
            String certId = communication.getPackagingOptionCertAlias(optionPath);
            communication.setPackagingOptionCert(optionPath, certId);
        }
        catch (OptionNotFoundException | PackageIdNotFoundException idNotFoundException) {
            // empty catch block
        }
    }

    private String addSmimeCertificate(CppPartner partner, X509Certificate smimeCertificate) throws Exception {
        if (partner.isLocal() && this.needSMIMECert(partner, smimeCertificate)) {
            SignCertInfo cert = this.getSignCertInfoForSMimeCertificate();
            if (cert == null) {
                return null;
            }
            X509Certificate x509Cert = cert.getCertificateChain()[0];
            String certId = this.getCertificateId(partner, x509Cert);
            if (StringUtils.isNotBlank((CharSequence)certId)) {
                return certId;
            }
            try {
                String password = cert.getPassword();
                if (cert.getPrivateKey() != null) {
                    certId = partner.addPrivateKey(x509Cert, cert.getPrivateKey(), password);
                }
            }
            catch (Exception ex) {
                this._log.error((Object)ex.getMessage());
            }
            return certId;
        }
        if (smimeCertificate == null) {
            return null;
        }
        String certId = this.getCertificateId(partner, smimeCertificate);
        if (StringUtils.isNotBlank((CharSequence)certId)) {
            return certId;
        }
        return partner.addPartnerCertificate(smimeCertificate);
    }

    private boolean needSMIMECert(CppPartner partner, X509Certificate smimeCertificate) {
        return smimeCertificate != null || this.hasMailURL(partner) || StringUtils.isNotBlank((CharSequence)partner.getPartyIdValue("AS2-Name")) || StringUtils.isNotBlank((CharSequence)partner.getPartyIdValue("AS3-Name"));
    }

    private boolean hasMailURL(CppPartner partner) {
        String[] transportIds;
        for (String transportId : transportIds = partner.getTransportIds()) {
            try {
                String url = partner.getTransportUrl(transportId);
                if (!StringUtils.isNotBlank((CharSequence)url) || !url.toLowerCase().startsWith("mailto:") && !url.toLowerCase().startsWith("smime:")) continue;
                return true;
            }
            catch (TransportIdNotFoundException transportIdNotFoundException) {
                // empty catch block
            }
        }
        return false;
    }

    private String getCertificateId(CppPartner partner, X509Certificate certificate) throws Exception {
        byte[] encodedCertificate = certificate.getEncoded();
        for (String certId : partner.getCertificateIds()) {
            byte[] installedCertificate = partner.getX509Certificate(certId).getEncoded();
            if (!Arrays.equals(installedCertificate, encodedCertificate)) continue;
            return certId;
        }
        return null;
    }

    private SignCertInfo getSignCertInfoForSMimeCertificate() {
        try {
            String email = this._messengerConfig.getSmtpFromAddress();
            byte[] smimePass = this._messengerConfig.getSmimePassword();
            String password = this._passwordCrypt.decryptPassword(smimePass);
            PontonKeystore keystore = this._keyStoreBean.getKeystore();
            X509Certificate smimeCertificate = keystore.getSMIMECertificate(email);
            if (smimeCertificate == null) {
                return null;
            }
            String certKeyEmail = this._certificate.retrieveEmail(smimeCertificate);
            PrivateKey privateKey = keystore.getPrivateKey(certKeyEmail, password.toCharArray());
            X509Certificate[] certificateChain = keystore.getCertificateChain(smimeCertificate);
            SignCertInfo signCertInfo = new SignCertInfo(password, privateKey, certificateChain);
            return signCertInfo;
        }
        catch (Exception ex) {
            this._log.error((Object)ex.getMessage());
            return null;
        }
    }
}

