/*
 * Decompiled with CFR 0.152.
 */
package de.pontonconsulting.xmlpipe.messenger.filter.sign;

import de.pontonconsulting.xmlpipe.LocalizedException;
import de.pontonconsulting.xmlpipe.cpp.OptionNotFoundException;
import de.pontonconsulting.xmlpipe.cpp.ProfileException;
import de.pontonconsulting.xmlpipe.message.XpMessage;
import de.pontonconsulting.xmlpipe.message.XpMessageAttachment;
import de.pontonconsulting.xmlpipe.messenger.database.tables.MessengerLog;
import de.pontonconsulting.xmlpipe.messenger.filter.BaseFilterException;
import de.pontonconsulting.xmlpipe.messenger.filter.BaseFilterPlugin;
import de.pontonconsulting.xmlpipe.messenger.filter.sign.SignatureException;
import de.pontonconsulting.xmlpipe.security.CertificateUtility;
import de.pontonconsulting.xmlpipe.security.CryptoUtil;
import de.pontonconsulting.xmlpipe.security.util.SignCertInfo;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.security.GeneralSecurityException;
import java.security.PrivateKey;
import java.security.Signature;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.security.interfaces.ECPrivateKey;
import java.util.ArrayList;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.cert.jcajce.JcaCertStore;
import org.bouncycastle.cms.CMSException;
import org.bouncycastle.cms.CMSSignedDataStreamGenerator;
import org.bouncycastle.operator.OperatorCreationException;
import org.bouncycastle.util.Store;

public abstract class Signer
extends BaseFilterPlugin {
    public static final String CERT_FILE_EXTENSION = ".cer";
    protected static final int BUFFER_LENGTH = 8192;
    private String _usedAlgorithm;
    private String _usedHashAlgorithm;
    private ASN1ObjectIdentifier _cmsAlgorithm;
    private final CertificateUtility _certificateUtility;
    private boolean isECPrivateKey;

    public Signer(String pluginName, CertificateUtility certificateUtility, MessengerLog messengerLog) {
        super(pluginName, messengerLog);
        this._certificateUtility = certificateUtility;
    }

    protected void setSignatureAlgorithm(String usedAlgorithm, String usedHashAlgorithm, ASN1ObjectIdentifier cmsAlgorithm) throws BaseFilterException {
        try {
            this._usedAlgorithm = usedAlgorithm;
            this._usedHashAlgorithm = usedHashAlgorithm;
            this._cmsAlgorithm = cmsAlgorithm;
            Signature.getInstance(usedAlgorithm, "BC");
        }
        catch (Exception e) {
            throw new BaseFilterException(15011, e);
        }
    }

    public void doFilter(XpMessage message) throws SignatureException {
        if (message.getCurrentContentReference() == null) {
            this._log.debug("No payload to be signed");
            return;
        }
        String senderId = message.getCommunication().getSenderLocalId();
        PrivateKey privateKey = null;
        Certificate[] chain = null;
        SignCertInfo signCertInfo = new SignCertInfo(null, null, null);
        try {
            signCertInfo = message.getCommunication().getProcessingSignKey();
        }
        catch (ProfileException | SecurityException | CertificateException e) {
            this._log.error("Error while creating signature: {}", (Object)e.getMessage());
            this.messageLog(505, message.getDatabaseId(), message.getMessageId(), e.getMessage());
            throw new SignatureException(19004, "Error while signing data with partnerId " + senderId + ": " + e.getMessage());
        }
        try {
            privateKey = signCertInfo.getPrivateKey();
            chain = signCertInfo.getCertificateChain();
            this.isECPrivateKey = privateKey instanceof ECPrivateKey;
            if (privateKey == null) {
                throw new SignatureException(19002, new String[]{senderId}, "No Private Key installed for local partnerId: " + senderId);
            }
            if (chain == null || chain.length < 1) {
                throw new SignatureException(19003, new String[]{senderId}, "No Certificate installed for local partnerId: " + senderId);
            }
            File outFile = null;
            XpMessageAttachment signatureAttachment = null;
            boolean pkcs7 = false;
            boolean includeCert = false;
            try {
                pkcs7 = Boolean.valueOf(message.getCommunication().getPipelineOptionValueForMessage("/sign/PKCS7-signed-data", message.getSchemaLocation()));
                if (pkcs7) {
                    includeCert = Boolean.valueOf(message.getCommunication().getPipelineOptionValueForMessage("/sign/PKCS7-signed-data/includeCerts", message.getSchemaLocation()));
                }
            }
            catch (OptionNotFoundException optionNotFoundException) {
                // empty catch block
            }
            if (pkcs7) {
                outFile = new File(message.getCurrentContentReferenceFolder(), message.getCurrentContentReference().getName() + ".p7s");
                this.createPKCS7signature(privateKey, chain, outFile, message.getCurrentContentReference(), includeCert);
                signatureAttachment = new XpMessageAttachment(outFile, "application/pkcs7-mime", "Signature");
            } else {
                outFile = this.isECPrivateKey ? new File(message.getCurrentContentReferenceFolder(), message.getCurrentContentReference().getName() + "." + this._usedAlgorithm + ".ecdsa") : new File(message.getCurrentContentReferenceFolder(), message.getCurrentContentReference().getName() + "." + this._usedAlgorithm + ".rsa");
                this.createRawSignature(privateKey, outFile, message.getCurrentContentReference());
                signatureAttachment = new XpMessageAttachment(outFile, "application/pkcs7-mime", "Signature");
            }
            signatureAttachment.setRole("xp-signature");
            message.addAttachment(signatureAttachment);
            if (this.isECPrivateKey) {
                message.setProcessingDirective("SignatureAlgorithm", "ecdsa");
            } else {
                message.setProcessingDirective("SignatureAlgorithm", "rsa");
            }
            message.setProcessingDirective("HashAlgorithm", this._usedHashAlgorithm);
            String usingInfoText = this._certificateUtility.toUsingInfoText((X509Certificate)chain[0], "using " + this._usedAlgorithm + " and certificate");
            this.messageLog(63, message.getDatabaseId(), message.getMessageId(), usingInfoText);
            if (this._log.isInfoEnabled()) {
                if (this._log.isDebugEnabled()) {
                    this._log.debug(usingInfoText);
                }
                this._log.info("Message successfully signed");
            }
            try (BufferedOutputStream fileOutputStream = new BufferedOutputStream(Files.newOutputStream(new File(message.getCurrentContentReferenceFolder(), senderId + CERT_FILE_EXTENSION).toPath(), new OpenOption[0]));
                 BufferedOutputStream out = new BufferedOutputStream(fileOutputStream);){
                byte[] cert = chain[0].getEncoded();
                out.write(cert);
                out.flush();
            }
            catch (IOException ioe) {
                this._log.warn("could not store certificate for archiving: {}", (Object)ioe.getMessage());
            }
        }
        catch (Exception e) {
            if (e instanceof LocalizedException) {
                this._log.error("Error while signing data: {}", (Object)e.getMessage());
                this.messageLog(505, message.getDatabaseId(), message.getMessageId(), e.getMessage());
                throw new SignatureException(19004, "Error while signing data with partnerId " + senderId + ": " + e.getMessage());
            }
            this._log.error("Error while signing data: {}", (Object)e.toString());
            this.messageLog(505, message.getDatabaseId(), message.getMessageId(), e.toString());
            throw new SignatureException(19004, "Error while signing data with partnerId " + senderId + ": " + e.toString());
        }
    }

    protected void createRawSignature(PrivateKey privateKey, File outFile, File content) throws GeneralSecurityException, IOException {
        byte[] buffer = new byte[8192];
        try (BufferedInputStream fis = new BufferedInputStream(Files.newInputStream(content.toPath(), new OpenOption[0]));
             BufferedOutputStream fos = new BufferedOutputStream(Files.newOutputStream(outFile.toPath(), new OpenOption[0]));){
            Signature signature = Signature.getInstance(this._usedAlgorithm, "BC");
            signature.initSign(privateKey);
            int length = 0;
            while ((length = ((InputStream)fis).read(buffer)) != -1) {
                signature.update(buffer, 0, length);
            }
            byte[] sig = signature.sign();
            ((OutputStream)fos).write(sig);
        }
    }

    protected void createPKCS7signature(PrivateKey privKey, Certificate[] certChain, File outFile, File content, boolean includeCert) throws GeneralSecurityException, OperatorCreationException, CMSException, IOException {
        byte[] buffer = new byte[8192];
        if (this._cmsAlgorithm == null) {
            throw new GeneralSecurityException("no algorithm set for PKCS7 object");
        }
        CMSSignedDataStreamGenerator gen = CryptoUtil.createStreamGenerator(privKey, (X509Certificate)certChain[0], this._cmsAlgorithm);
        if (includeCert) {
            ArrayList<Certificate> certList = new ArrayList<Certificate>();
            certList.add(certChain[0]);
            JcaCertStore certs = new JcaCertStore(certList);
            gen.addCertificates((Store)certs);
        }
        try (BufferedOutputStream fos = new BufferedOutputStream(Files.newOutputStream(outFile.toPath(), new OpenOption[0]));
             BufferedInputStream fis = new BufferedInputStream(Files.newInputStream(content.toPath(), new OpenOption[0]));
             OutputStream sigOut = gen.open((OutputStream)fos);){
            int length = 0;
            while ((length = ((InputStream)fis).read(buffer)) != -1) {
                sigOut.write(buffer, 0, length);
            }
        }
    }
}

