/*
 * Decompiled with CFR 0.152.
 */
package de.pontonconsulting.xmlpipe.messenger.filter.crypt;

import de.pontonconsulting.common.activation.SimpleFileDataSource;
import de.pontonconsulting.xmlpipe.LocalizedException;
import de.pontonconsulting.xmlpipe.cpp.OptionNotFoundException;
import de.pontonconsulting.xmlpipe.cpp.ProfileException;
import de.pontonconsulting.xmlpipe.cpp.Profiles;
import de.pontonconsulting.xmlpipe.message.XpMessage;
import de.pontonconsulting.xmlpipe.messenger.database.tables.MessengerLog;
import de.pontonconsulting.xmlpipe.messenger.filter.BaseFilterPlugin;
import de.pontonconsulting.xmlpipe.messenger.filter.crypt.CryptException;
import de.pontonconsulting.xmlpipe.security.CertificateUtility;
import de.pontonconsulting.xmlpipe.security.smime.SMIMEDecrypter;
import de.pontonconsulting.xmlpipe.security.util.SignCertInfo;
import jakarta.activation.DataHandler;
import jakarta.activation.DataSource;
import jakarta.mail.MessagingException;
import jakarta.mail.internet.MimeBodyPart;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.cert.X509Certificate;
import java.util.List;
import org.bouncycastle.cms.CMSException;
import org.bouncycastle.mail.smime.SMIMEException;

public abstract class SMIMEDecrypter
extends BaseFilterPlugin {
    private String _usedAlgorithm;
    private String _usedCryptAlgorithm;
    private final CertificateUtility _certificateUtility;
    private final de.pontonconsulting.xmlpipe.security.smime.SMIMEDecrypter _smimeDecrypter;
    private final Profiles profiles;

    public SMIMEDecrypter(String pluginName, CertificateUtility certificateUtility, de.pontonconsulting.xmlpipe.security.smime.SMIMEDecrypter smimeDecrypter, Profiles profiles, MessengerLog messengerLog) {
        super(pluginName, messengerLog);
        this._certificateUtility = certificateUtility;
        this._smimeDecrypter = smimeDecrypter;
        this.profiles = profiles;
    }

    protected void setEncryptionAlgorithm(String usedAlgorithm, String usedCryptAlgorithm) {
        this._usedAlgorithm = usedAlgorithm;
        this._usedCryptAlgorithm = usedCryptAlgorithm;
    }

    public void doFilter(XpMessage message) throws CryptException {
        String encryption = message.getProcessingDirective("CryptoAlgorithm");
        String encrStr = null;
        try {
            encrStr = message.getCommunication().getPipelineOptionValueForMessage("/Encryption", message.getSchemaLocation());
        }
        catch (OptionNotFoundException optionNotFoundException) {
            // empty catch block
        }
        if (this._usedCryptAlgorithm.equalsIgnoreCase(encrStr) && encryption != null && !this._usedAlgorithm.equals(encryption)) {
            String errorMsg = "Message should be encrypted with '" + this._usedAlgorithm + "' but '" + encryption + "' was used by sender.";
            this.messageLog(506, message.getDatabaseId(), message.getMessageId(), errorMsg);
            throw new CryptException(17002, errorMsg);
        }
        if (this._usedCryptAlgorithm.equalsIgnoreCase(encrStr)) {
            this._log.debug("Message is encrypted...");
            String localId = message.getReceiverLocalId();
            List<SignCertInfo> signCertInfos = null;
            try {
                signCertInfos = this.profiles.getProfileForLocalId(localId, true).getAllKeys();
            }
            catch (ProfileException pe) {
                throw new CryptException(19000, pe);
            }
            catch (Exception e) {
                this.messageLog(506, message.getDatabaseId(), message.getMessageId(), e.getMessage());
                throw new CryptException(17004, "Error while decryption: " + e.getMessage());
            }
            try {
                String payloadFilename = this.updateCurrentPayloadFilename(message, true);
                File outFile = new File(message.getCurrentContentReferenceFolder(), payloadFilename);
                String contentType = this.decryptFile(message, outFile, signCertInfos);
                message.setCurrentContentType(contentType);
                message.setCurrentContentReference(outFile);
                this.updateProcessedOriginalFilename(message, true);
                this._log.debug("done");
            }
            catch (Exception e) {
                if (e instanceof LocalizedException) {
                    this._log.fatal("Error while decryption: {}", (Object)e.getMessage());
                    this.messageLog(506, message.getDatabaseId(), message.getMessageId(), e.getMessage());
                    throw new CryptException(17004, "Error while decryption: " + e.getMessage());
                }
                this._log.fatal("Error while decryption: {}", (Object)e.toString());
                this.messageLog(506, message.getDatabaseId(), message.getMessageId(), e.toString());
                throw new CryptException(17004, "Error while decryption: " + e.toString());
            }
        }
        this._log.debug("Message is not encrypted");
    }

    protected String decryptFile(XpMessage message, File outFile, List<SignCertInfo> signCertInfos) throws MessagingException, NoSuchProviderException, IOException, SMIMEException, CMSException, CryptException, NoSuchAlgorithmException {
        File fileIn = message.getCurrentContentReference();
        String contentType = message.getCurrentContentType();
        try (SimpleFileDataSource dataSource = new SimpleFileDataSource(contentType, fileIn);){
            String string;
            try (BufferedOutputStream fos = new BufferedOutputStream(Files.newOutputStream(outFile.toPath(), new OpenOption[0]));){
                MimeBodyPart encBp = new MimeBodyPart();
                encBp.setDataHandler(new DataHandler((DataSource)dataSource));
                SMIMEDecrypter.SMIMEDecryptResult smimeDecryptResult = this._smimeDecrypter.decryptMimeMessage(signCertInfos, encBp);
                MimeBodyPart bp = smimeDecryptResult.getDecryptedContent();
                X509Certificate usedCert = smimeDecryptResult.getUsedCertificate();
                bp.getDataHandler().writeTo((OutputStream)fos);
                this.messageLog(70, message.getDatabaseId(), message.getMessageId(), this._certificateUtility.toUsingInfoText(usedCert, "using " + this._usedCryptAlgorithm + " and certificate"));
                this._log.info(this._certificateUtility.toUsingInfoText(usedCert, "Message successfully decrypted using certificate"));
                string = bp.getContentType();
            }
            return string;
        }
    }

    @Override
    protected String getDefaultExtension() {
        return ".p7m";
    }
}

