/*
 * Decompiled with CFR 0.152.
 */
package de.pontonconsulting.xmlpipe.messenger.filter.crypt;

import de.pontonconsulting.xmlpipe.cpp.CppPartner;
import de.pontonconsulting.xmlpipe.cpp.OptionNotFoundException;
import de.pontonconsulting.xmlpipe.cpp.ProfileException;
import de.pontonconsulting.xmlpipe.cpp.Profiles;
import de.pontonconsulting.xmlpipe.message.XpMessage;
import de.pontonconsulting.xmlpipe.messenger.database.tables.MessageDAO;
import de.pontonconsulting.xmlpipe.messenger.database.tables.MessengerLog;
import de.pontonconsulting.xmlpipe.messenger.filter.BaseFilterPlugin;
import de.pontonconsulting.xmlpipe.messenger.filter.crypt.CryptException;
import de.pontonconsulting.xmlpipe.security.CertificateUtility;
import de.pontonconsulting.xmlpipe.security.CryptoUtil;
import de.pontonconsulting.xmlpipe.security.util.SignCertInfo;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigInteger;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import java.security.interfaces.ECPrivateKey;
import java.security.interfaces.RSAPrivateKey;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.cms.CMSEnvelopedDataParser;
import org.bouncycastle.cms.CMSException;
import org.bouncycastle.cms.CMSTypedStream;
import org.bouncycastle.cms.KeyAgreeRecipientId;
import org.bouncycastle.cms.KeyTransRecipientId;
import org.bouncycastle.cms.Recipient;
import org.bouncycastle.cms.RecipientId;
import org.bouncycastle.cms.RecipientInformation;
import org.bouncycastle.cms.RecipientInformationStore;

public abstract class ASN1Decrypter
extends BaseFilterPlugin {
    private String _usedAlgorithm;
    private String _usedCryptAlgorithm;
    private final MessageDAO _messageDAO;
    private final CertificateUtility _certificateUtility;
    private final Profiles profiles;

    public ASN1Decrypter(String pluginName, MessengerLog messengerLog, MessageDAO messageDAO, CertificateUtility certificateUtility, Profiles profiles) {
        super(pluginName, messengerLog);
        this._messageDAO = messageDAO;
        this._certificateUtility = certificateUtility;
        this.profiles = profiles;
    }

    protected void setEncryptionAlgorithm(String usedAlgorithm, String usedCryptAlgorithm) {
        this._usedAlgorithm = usedAlgorithm;
        this._usedCryptAlgorithm = usedCryptAlgorithm;
    }

    public void doFilter(XpMessage message) throws CryptException {
        String encryption = message.getProcessingDirective("CryptoAlgorithm");
        String encrStr = null;
        try {
            encrStr = message.getCommunication().getPipelineOptionValueForMessage("/Encryption", message.getSchemaLocation());
        }
        catch (OptionNotFoundException optionNotFoundException) {
            // empty catch block
        }
        if (this._usedCryptAlgorithm.equalsIgnoreCase(encrStr) && encryption != null && !this._usedAlgorithm.equals(encryption)) {
            String errorMsg = "Message should be encrypted with '" + this._usedAlgorithm + "' but '" + encryption + "' was used by sender.";
            this.messageLog(506, message.getDatabaseId(), message.getMessageId(), errorMsg);
            throw new CryptException(17002, errorMsg);
        }
        if (this._usedCryptAlgorithm.equalsIgnoreCase(encrStr)) {
            List<SignCertInfo> signCertInfos;
            if (this._log.isDebugEnabled()) {
                this._log.debug("Message should be encrypted with {}", (Object)this._usedCryptAlgorithm);
            }
            String localId = message.getReceiverLocalId();
            try {
                CppPartner receiver = this.profiles.getProfileForLocalId(localId, true);
                signCertInfos = receiver.getAllKeys();
            }
            catch (ProfileException pe) {
                this.messageLog(506, message.getDatabaseId(), message.getMessageId(), pe.getMessage());
                throw new CryptException(19000, pe);
            }
            catch (Exception e) {
                this.messageLog(506, message.getDatabaseId(), message.getMessageId(), e.getMessage());
                throw new CryptException(17004, "Error while decryption: " + e.getMessage());
            }
            try {
                String payloadFilename = this.updateCurrentPayloadFilename(message, true);
                File outFile = new File(message.getCurrentContentReferenceFolder(), payloadFilename);
                this.decryptFile(message, outFile, signCertInfos);
                message.setCurrentContentReference(outFile);
                this.updateProcessedOriginalFilename(message, true);
            }
            catch (CryptException e) {
                this._log.fatal("Error while decryption: {}", (Object)e.getMessage());
                this.messageLog(506, message.getDatabaseId(), message.getMessageId(), e.getMessage());
                throw e;
            }
            catch (Exception e) {
                this._log.fatal("Error while decryption: {}", (Object)e.getMessage());
                this.messageLog(506, message.getDatabaseId(), message.getMessageId(), e.getMessage());
                throw new CryptException(17004, "Error while decryption: " + e.getMessage());
            }
        }
        if (this._log.isDebugEnabled()) {
            this._log.debug("Message is not encrypted");
        }
    }

    protected void decryptFile(XpMessage message, File outFile, List<SignCertInfo> signCertInfos) throws CMSException, IOException, CryptException, NoSuchAlgorithmException {
        File inFile = message.getCurrentContentReference();
        X509Certificate receiverCert = null;
        try (BufferedInputStream fis = new BufferedInputStream(Files.newInputStream(inFile.toPath(), new OpenOption[0]), 8192);
             BufferedOutputStream fos = new BufferedOutputStream(Files.newOutputStream(outFile.toPath(), new OpenOption[0]));){
            CMSTypedStream decryptedContent;
            CMSEnvelopedDataParser ep;
            try {
                ep = new CMSEnvelopedDataParser((InputStream)fis);
            }
            catch (CMSException e) {
                throw new CryptException(-1, "The message is not encrypted: " + e.toString());
            }
            if (this._log.isDebugEnabled()) {
                this._log.debug("encryption algorithm: {}", (Object)ep.getEncryptionAlgOID());
            }
            RecipientInformationStore recipients = ep.getRecipientInfos();
            BigInteger messageSerial = null;
            PrivateKey privateKeyToBeUsed = null;
            RecipientInformation recipient = null;
            AtomicReference<X500Name> issuer = new AtomicReference<X500Name>();
            boolean certificateMatch = false;
            for (SignCertInfo signCertInfo : signCertInfos) {
                KeyTransRecipientId recId;
                if (signCertInfo.getCertificateChain() != null && signCertInfo.getCertificateChain().length > 0) {
                    receiverCert = signCertInfo.getCertificateChain()[0];
                }
                PrivateKey privateKey = signCertInfo.getPrivateKey();
                if (receiverCert == null || privateKey == null) continue;
                messageSerial = receiverCert.getSerialNumber();
                issuer.set(X500Name.getInstance((Object)receiverCert.getIssuerX500Principal().getEncoded()));
                if ("RSA".equals(receiverCert.getPublicKey().getAlgorithm())) {
                    recId = new KeyTransRecipientId((X500Name)issuer.get(), receiverCert.getSerialNumber());
                } else if ("EC".equals(receiverCert.getPublicKey().getAlgorithm())) {
                    recId = new KeyAgreeRecipientId((X500Name)issuer.get(), receiverCert.getSerialNumber());
                } else {
                    throw new NoSuchAlgorithmException("Receiver certificate is neither RSA nor EC");
                }
                if ((recipient = recipients.get((RecipientId)recId)) == null) continue;
                privateKeyToBeUsed = privateKey;
                certificateMatch = true;
                break;
            }
            if (!certificateMatch) {
                AtomicReference serialRef = new AtomicReference();
                recipients.getRecipients().forEach(recipientInformation -> {
                    if (recipientInformation.getRID() instanceof KeyTransRecipientId) {
                        KeyTransRecipientId rid = (KeyTransRecipientId)recipientInformation.getRID();
                        serialRef.set(rid.getSerialNumber());
                    } else if (recipientInformation.getRID() instanceof KeyAgreeRecipientId) {
                        KeyAgreeRecipientId rid = (KeyAgreeRecipientId)recipientInformation.getRID();
                        serialRef.set(rid.getSerialNumber());
                    }
                });
                String errorMsg = "Message was encrypted with a wrong Certificate. Could not find certificate serial:" + this._certificateUtility.serialNr2String((BigInteger)serialRef.get()) + " (" + String.valueOf(serialRef.get()) + ") , Issuer: " + String.valueOf(issuer.get());
                if (message.getDatabaseId() == -1L) {
                    int direction = message.isInbound() ? 1 : 0;
                    message.setDatabaseId(this._messageDAO.getMessageDataID(message.getMessageId(), direction));
                }
                throw new CryptException(17003, new String[]{String.valueOf(messageSerial), issuer.toString()}, errorMsg);
            }
            if (privateKeyToBeUsed instanceof RSAPrivateKey) {
                privateKeyRecipient = CryptoUtil.createTransEnvelopedRecipient(privateKeyToBeUsed);
                decryptedContent = recipient.getContentStream((Recipient)privateKeyRecipient);
            } else if (privateKeyToBeUsed instanceof ECPrivateKey) {
                privateKeyRecipient = CryptoUtil.createKeyAgreeEnvelopedRecipient(privateKeyToBeUsed);
                decryptedContent = recipient.getContentStream((Recipient)privateKeyRecipient);
            } else {
                throw new NoSuchAlgorithmException("Private key is neither RSA nor EC");
            }
            this.messageLog(70, message.getDatabaseId(), message.getMessageId(), this._certificateUtility.toUsingInfoText(receiverCert, "using " + this._usedCryptAlgorithm + " and certificate"));
            this._log.info("Message successfully decrypted");
            try (InputStream in = decryptedContent.getContentStream();){
                this._log.debug("started decrypting content");
                byte[] buffer = new byte[8192];
                int len = 0;
                while ((len = in.read(buffer)) != -1) {
                    ((OutputStream)fos).write(buffer, 0, len);
                }
                this._log.debug("finished decrypting content");
            }
        }
    }

    @Override
    protected String getDefaultExtension() {
        return ".asn1";
    }
}

