/*
 * Decompiled with CFR 0.152.
 */
package de.pontonconsulting.xmlpipe.messenger.filter.compress;

import de.pontonconsulting.xmlpipe.message.XpMessage;
import de.pontonconsulting.xmlpipe.message.XpMessageAttachment;
import de.pontonconsulting.xmlpipe.messenger.database.tables.MessengerLog;
import de.pontonconsulting.xmlpipe.messenger.filter.BaseFilterPlugin;
import de.pontonconsulting.xmlpipe.messenger.filter.IDecompressor;
import de.pontonconsulting.xmlpipe.messenger.filter.compress.CompressionException;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipInputStream;

public class ZIPwithAttachmentsDecompressor
extends BaseFilterPlugin
implements IDecompressor {
    public ZIPwithAttachmentsDecompressor(MessengerLog messengerLog) {
        super("ZIPwithAttachmentsDecompressor", messengerLog);
    }

    @Override
    public void doFilter(XpMessage message) throws CompressionException {
        try {
            long before = message.getCurrentContentReference().length();
            long after = 0L;
            this._log.debug("Message is compressed: {} bytes", (Object)before);
            String payloadFilename = this.updateCurrentPayloadFilename(message, true);
            File payloadFile = new File(message.getCurrentContentReferenceFolder(), payloadFilename);
            this._log.debug("writing to:{}", (Object)payloadFile);
            try (ZipInputStream decomp = new ZipInputStream(new BufferedInputStream(Files.newInputStream(message.getCurrentContentReference().toPath(), new OpenOption[0])));
                 BufferedOutputStream out = new BufferedOutputStream(Files.newOutputStream(payloadFile.toPath(), new OpenOption[0]));){
                ZipEntry payloadEntry = decomp.getNextEntry();
                if (payloadEntry == null) {
                    throw new ZipException("The message is not compressed.");
                }
                this._log.debug("Found an attachment '{}'.", (Object)payloadEntry.getName());
                after += (long)this.write(decomp, out);
                decomp.closeEntry();
                ZipEntry attachmentEntry = decomp.getNextEntry();
                File attachmentFolder = new File(payloadFile.getParentFile(), "attachments");
                while (attachmentEntry != null) {
                    if (!attachmentFolder.exists()) {
                        attachmentFolder.mkdir();
                    }
                    this._log.debug("Found an attachment '{}'.", (Object)attachmentEntry.getName());
                    File attachmentFile = new File(attachmentFolder, attachmentEntry.getName());
                    try (BufferedOutputStream attachmentOut = new BufferedOutputStream(Files.newOutputStream(attachmentFile.toPath(), new OpenOption[0]));){
                        after += (long)this.write(decomp, attachmentOut);
                        decomp.closeEntry();
                        attachmentEntry = decomp.getNextEntry();
                    }
                    message.addAttachment(new XpMessageAttachment(attachmentFile));
                }
                this._log.debug("Message is decompressed: {} bytes", (Object)after);
                message.setCurrentContentReference(payloadFile);
                this.messageLog(69, message.getDatabaseId(), message.getMessageId(), before + " bytes -> " + after + " bytes (" + this.getOptionValue() + ")");
                this.updateProcessedOriginalFilename(message, true);
                this._log.info("Message successfully decompressed ({})", (Object)this.getOptionValue());
            }
        }
        catch (IOException e) {
            this._log.debug("Error while decompressing Message: {}", (Object)e.toString());
            this.messageLog(503, message.getDatabaseId(), message.getMessageId(), "decompression problem: " + e.toString());
            throw new CompressionException(16003, "Error while decompressing Message: " + e.toString());
        }
    }

    @Override
    protected String getDefaultExtension() {
        return ".zip";
    }

    @Override
    public String getOptionValue() {
        return "ZIPwithAttachments";
    }
}

