/*
 * Decompiled with CFR 0.152.
 */
package de.pontonconsulting.xmlpipe.messenger.filter.compress;

import de.pontonconsulting.xmlpipe.message.XpMessage;
import de.pontonconsulting.xmlpipe.messenger.database.tables.MessengerLog;
import de.pontonconsulting.xmlpipe.messenger.filter.BaseFilterPlugin;
import de.pontonconsulting.xmlpipe.messenger.filter.IDecompressor;
import de.pontonconsulting.xmlpipe.messenger.filter.compress.CompressionException;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipInputStream;

public class ZIPDecompressor
extends BaseFilterPlugin
implements IDecompressor {
    public ZIPDecompressor(MessengerLog messengerLog) {
        super("ZIPDecompressor", messengerLog);
    }

    @Override
    public void doFilter(XpMessage message) throws CompressionException {
        long before = message.getCurrentContentReference().length();
        long after = 0L;
        this._log.debug("Message is compressed: {} bytes", (Object)before);
        try (BufferedInputStream in = new BufferedInputStream(Files.newInputStream(message.getCurrentContentReference().toPath(), new OpenOption[0]));){
            String payloadFilename = this.updateCurrentPayloadFilename(message, true);
            File outFile = new File(message.getCurrentContentReferenceFolder(), payloadFilename);
            this._log.debug("writing to:{}", (Object)outFile);
            try (BufferedOutputStream out = new BufferedOutputStream(Files.newOutputStream(outFile.toPath(), new OpenOption[0]));
                 ZipInputStream decomp = new ZipInputStream(in);){
                ZipEntry entry = decomp.getNextEntry();
                if (entry == null) {
                    throw new ZipException("The message is not compressed.");
                }
                decomp.transferTo(out);
            }
            after = outFile.length();
            this._log.debug("Message is decompressed: {} bytes", (Object)after);
            message.setCurrentContentReference(outFile);
            this.messageLog(69, message.getDatabaseId(), message.getMessageId(), before + " bytes -> " + after + " bytes (" + this.getOptionValue() + ")");
            this.updateProcessedOriginalFilename(message, true);
            this._log.info("Message successfully decompressed ({})", (Object)this.getOptionValue());
        }
        catch (IOException e) {
            this._log.fatal("Error while decompressing Message: {}", (Object)e.toString());
            this.messageLog(503, message.getDatabaseId(), message.getMessageId(), "decompression problem: " + e.toString());
            throw new CompressionException(16003, "Error while decompressing Message: " + e.toString());
        }
    }

    @Override
    protected String getDefaultExtension() {
        return ".zip";
    }

    @Override
    public String getOptionValue() {
        return "ZIP";
    }
}

