/*
 * Decompiled with CFR 0.152.
 */
package de.pontonconsulting.xmlpipe.messenger.filter.antivirus.icap;

import de.pontonconsulting.xmlpipe.messenger.filter.antivirus.icap.ConnectionAttempt;
import de.pontonconsulting.xmlpipe.messenger.filter.antivirus.icap.ErrorCode;
import de.pontonconsulting.xmlpipe.messenger.filter.antivirus.icap.Header;
import de.pontonconsulting.xmlpipe.messenger.filter.antivirus.icap.ICAPStreamReader;
import de.pontonconsulting.xmlpipe.messenger.filter.antivirus.icap.ISTagInfo;
import de.pontonconsulting.xmlpipe.messenger.filter.antivirus.icap.Policy;
import de.pontonconsulting.xmlpipe.messenger.filter.antivirus.icap.Request;
import de.pontonconsulting.xmlpipe.messenger.filter.antivirus.icap.Result;
import de.pontonconsulting.xmlpipe.messenger.filter.antivirus.icap.ResultStatus;
import de.pontonconsulting.xmlpipe.messenger.filter.antivirus.icap.ScanException;
import de.pontonconsulting.xmlpipe.messenger.filter.antivirus.icap.ThreatInfo;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Iterator;

abstract class RequestImpl
implements Request {
    Socket socket;
    Result result;
    Policy policy;
    File actualFile;
    File originalFile;
    OutputStream scanoutput;
    OutputStream socketOutputStream;
    byte[] headerBytes;
    String xClientIP;
    InetAddress[] inetAddress;
    ISTagInfo[] isTagInfo;
    int connectedIndex;
    int[] portNumber;
    int failRetryTime;
    int readWriteTime;
    InputStream inputStream;
    byte[] endOfFileBytes = "\r\n0\r\n\r\n".getBytes();

    RequestImpl(InetAddress[] ainetaddress, int[] ai, ISTagInfo[] aistaginfo, File file, File file1, OutputStream outputstream, Policy policy1) {
        this.inetAddress = new InetAddress[ainetaddress.length];
        this.inetAddress = ainetaddress;
        this.portNumber = new int[ai.length];
        this.isTagInfo = new ISTagInfo[aistaginfo.length];
        this.isTagInfo = aistaginfo;
        this.portNumber = ai;
        this.actualFile = file;
        this.originalFile = file1;
        this.scanoutput = outputstream;
        this.policy = policy1;
    }

    Socket getConnection() throws ScanException, IOException {
        int i;
        long[] al = new long[this.inetAddress.length];
        boolean[] aflag = new boolean[this.inetAddress.length];
        for (int j = 0; j < this.inetAddress.length; ++j) {
            al[j] = 0L;
            aflag[j] = true;
        }
        int byte0 = 5;
        int k = 0;
        while (true) {
            block10: {
                if (k == byte0) {
                    throw new ScanException("Attempt to connect to Symantec Scan Engine failed.", ErrorCode.MAX_TRIES_REACHED);
                }
                i = this.inetAddress.length == 1 ? 0 : (int)((double)this.inetAddress.length * Math.random());
                try {
                    long l;
                    if (aflag[i] && (l = System.currentTimeMillis()) >= al[i] + (long)this.failRetryTime) {
                        ++k;
                        InetSocketAddress inetsocketaddress = new InetSocketAddress(this.inetAddress[i], this.portNumber[i]);
                        this.socket = new Socket();
                        this.socket.connect(inetsocketaddress, 2000);
                    }
                }
                catch (UnknownHostException unknownhostexception) {
                    aflag[i] = false;
                    ConnectionAttempt connectionattempt = new ConnectionAttempt();
                    connectionattempt.setIPAddress(this.inetAddress[i].getHostAddress());
                    connectionattempt.setPortNumber(this.portNumber[i]);
                    connectionattempt.setErrString("Unknown Host");
                    connectionattempt.setErrCode(ErrorCode.IP_UNRESOLVED);
                    this.result.connectionDetailsList.add(connectionattempt);
                    this.socket = null;
                    if (this.inetAddress.length == 1) {
                        throw new ScanException("Attempt to Connect to Symantec Scan Engine failed.", ErrorCode.MAX_TRIES_REACHED);
                    }
                }
                catch (IOException ioexception) {
                    al[i] = System.currentTimeMillis();
                    ConnectionAttempt connectionattempt1 = new ConnectionAttempt();
                    connectionattempt1.setIPAddress(this.inetAddress[i].getHostAddress());
                    connectionattempt1.setPortNumber(this.portNumber[i]);
                    connectionattempt1.setErrString("Unable to communicate with the server at " + this.inetAddress[i].getHostAddress() + ".");
                    connectionattempt1.setErrCode(ErrorCode.ERROR_SOCKET_COMMUNICATION);
                    this.result.connectionDetailsList.add(connectionattempt1);
                    this.socket = null;
                    if (this.inetAddress.length != 1) break block10;
                    throw new ScanException("Attempt to Connect to Symantec Scan Engine failed.", ErrorCode.MAX_TRIES_REACHED);
                }
            }
            if (this.socket == null || !this.socket.isConnected()) continue;
            String s = "OPTIONS icap://" + this.socket.getInetAddress().getHostAddress() + ":" + this.socket.getPort() + "/SYMCScanResp-AV ICAP/1.0\r\n\r\n";
            this.headerBytes = s.getBytes();
            OutputStream outputstream = this.socket.getOutputStream();
            outputstream.write(this.headerBytes);
            InputStream inputstream = this.socket.getInputStream();
            BufferedReader bufferedreader = new BufferedReader(new InputStreamReader(inputstream));
            String s1 = bufferedreader.readLine();
            if (!s1.startsWith("ICAP/1.0 506")) break;
            ConnectionAttempt connectionattempt2 = new ConnectionAttempt();
            connectionattempt2.setIPAddress(this.inetAddress[i].getHostAddress());
            connectionattempt2.setPortNumber(this.portNumber[i]);
            connectionattempt2.setErrString("Server Too Busy.");
            connectionattempt2.setErrCode(ErrorCode.ERROR_SERVER_TOO_BUSY);
            this.result.connectionDetailsList.add(connectionattempt2);
        }
        this.connectedIndex = i;
        ConnectionAttempt connectionattempt3 = new ConnectionAttempt();
        connectionattempt3.setIPAddress(this.inetAddress[i].getHostAddress());
        connectionattempt3.setPortNumber(this.portNumber[i]);
        connectionattempt3.setErrString("Able to connect");
        connectionattempt3.setErrCode(ErrorCode.SOCKET_CREATED);
        this.result.connectionDetailsList.add(connectionattempt3);
        try {
            this.socket.setSoTimeout(this.readWriteTime);
        }
        catch (SocketException socketexception) {
            throw new ScanException("Unable to set read write Time.", ErrorCode.ERROR_READ_WRITE_TIMEOUT);
        }
        return this.socket;
    }

    @Override
    public void setClientIP(String s) {
        this.xClientIP = s;
    }

    String getClientIP() {
        return this.xClientIP;
    }

    OutputStream getOutputStream() throws ScanException {
        try {
            this.socketOutputStream = this.socket.getOutputStream();
        }
        catch (IOException ioexception) {
            throw new ScanException("Unable to open the output Stream", ErrorCode.ERROR_OUTPUT_STREAM_OPEN);
        }
        return this.socketOutputStream;
    }

    public void abort() {
        try {
            if (this.inputStream != null) {
                this.inputStream.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            if (this.socketOutputStream != null) {
                this.socketOutputStream.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            if (this.socket != null) {
                this.socket.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public Result finish() throws ScanException {
        try {
            this.socketOutputStream.write(this.endOfFileBytes);
            this.socketOutputStream.flush();
        }
        catch (IOException ioexception) {
            throw new ScanException("Unable to send data to the Server.", ErrorCode.ERROR_ON_SERVER_WRITE);
        }
        Result result1 = this.readResult1();
        return result1;
    }

    Result read() throws ScanException {
        ArrayList<String> array = new ArrayList<String>();
        try {
            String s1;
            BufferedReader bufferedreader = new BufferedReader(new InputStreamReader(this.socket.getInputStream()));
            while ((s1 = bufferedreader.readLine()) != null) {
                array.add(s1);
            }
        }
        catch (Exception exception) {
            throw new ScanException("Error in reading response from server.", ErrorCode.ERROR_INPUT_STREAM_OPEN);
        }
        this.result = this.parseHeader(array);
        this.abort();
        return this.result;
    }

    public final Result readResult1() throws ScanException {
        try {
            InputStream inputstream = this.socket.getInputStream();
            ICAPStreamReader icapstreamreader = new ICAPStreamReader(inputstream);
            String s = null;
            boolean flag = false;
            boolean flag3 = false;
            s = icapstreamreader.readLine();
            if (s.startsWith("ICAP/1.0 200")) {
                this.result.setStatus(ResultStatus.CLEAN);
            }
            if (s.startsWith("ICAP/1.0 204")) {
                this.result.setStatus(ResultStatus.CLEAN);
                flag = true;
            }
            if (s.startsWith("ICAP/1.0 205") || s.startsWith("ICAP/1.0 403")) {
                this.result.setStatus(ResultStatus.INFECTED_UNREPAIRED);
                flag3 = true;
            }
            if (s.startsWith("ICAP/1.0 201")) {
                this.result.setStatus(ResultStatus.INFECTED_REPLACED);
                flag3 = true;
            }
            if (s.startsWith("ICAP/1.0 500")) {
                this.result.setStatus(ResultStatus.INTERNAL_SERVER_ERROR);
                flag = true;
            }
            if (s.startsWith("ICAP/1.0 502")) {
                this.result.setStatus(ResultStatus.FILE_ACCESS_FAILED);
                flag = true;
            }
            if (s.startsWith("ICAP/1.0 539") || s.startsWith("ICAP/1.0 558")) {
                this.result.setStatus(ResultStatus.NO_AV_LICENSE);
                flag = true;
            }
            if (!flag) {
                String s1 = icapstreamreader.readLine();
                do {
                    if (!s1.startsWith("Date:")) {
                        // empty if block
                    }
                    if (!s1.startsWith("Service:")) {
                        // empty if block
                    }
                    if (!s1.startsWith("Service-ID:")) {
                        // empty if block
                    }
                    if (!s1.startsWith("X-Outer-Container-Is-Mime:")) {
                        // empty if block
                    }
                    if (!flag3 || !s1.startsWith("X-Violations-Found:")) continue;
                    String s6 = s1.substring("X-Violations-Found: ".length());
                    int j = Integer.parseInt(s6);
                    for (int k = 0; k < j; ++k) {
                        ThreatInfo threatinfo = new ThreatInfo();
                        String s9 = icapstreamreader.readLine();
                        s9 = s9.substring(s9.lastIndexOf(9) + 1);
                        threatinfo.setfileName(s9);
                        s9 = icapstreamreader.readLine();
                        s9 = s9.substring(s9.lastIndexOf(9) + 1);
                        int l1 = s9.indexOf(124);
                        if (l1 > -1) {
                            String s10 = s9.substring(l1 + 1);
                            s9 = s9.substring(0, l1);
                            threatinfo.setViolationName(s9.substring(0, l1));
                            threatinfo.setThreatCategory(s10.substring(s10.indexOf(61) + 1));
                        } else {
                            threatinfo.setViolationName(s9);
                            threatinfo.setThreatCategory("");
                        }
                        s9 = icapstreamreader.readLine();
                        s9 = s9.substring(s9.lastIndexOf(9) + 1);
                        threatinfo.setviolationId(s9);
                        s9 = icapstreamreader.readLine();
                        s9 = s9.substring(s9.lastIndexOf(9) + 1);
                        threatinfo.setDisposition(s9);
                        this.result.threatArrayList.add(threatinfo);
                    }
                } while (!(s1 = icapstreamreader.readLine()).startsWith("Encaps"));
                if (s1.startsWith("Encaps")) {
                    // empty if block
                }
                s1 = icapstreamreader.readLine();
                s1 = icapstreamreader.readLine();
                s1 = icapstreamreader.readLine();
                boolean flag4 = false;
                if (s1.startsWith("Via")) {
                    s1 = icapstreamreader.readLine();
                } else {
                    flag4 = true;
                    s1 = icapstreamreader.readLine();
                    s1 = icapstreamreader.readLine();
                    s1 = icapstreamreader.readLine();
                }
                s1 = icapstreamreader.readLine();
                int l = Integer.parseInt(s1, 16);
                if (flag4) {
                    icapstreamreader.readLine();
                    icapstreamreader.readLine();
                    icapstreamreader.readLine();
                } else {
                    int j1 = 0;
                    do {
                        ++j1;
                        byte[] abyte0 = new byte[l];
                        int i2 = icapstreamreader.read(abyte0);
                        if (i2 < l) {
                            this.scanoutput.write(abyte0, 0, i2);
                            for (int j2 = i2; j2 < l && (i2 = icapstreamreader.read(abyte0, 0, l - j2)) != -1; j2 += i2) {
                                this.scanoutput.write(abyte0, 0, i2);
                            }
                            String s3 = icapstreamreader.readLine();
                            s3 = icapstreamreader.readLine();
                            l = Integer.parseInt(s3, 16);
                            continue;
                        }
                        this.scanoutput.write(abyte0, 0, i2);
                        String s4 = icapstreamreader.readLine();
                        s4 = icapstreamreader.readLine();
                        l = Integer.parseInt(s4, 16);
                    } while (l != 0);
                    this.scanoutput.flush();
                }
            }
        }
        catch (Exception exception) {
            throw new ScanException(exception.getMessage(), ErrorCode.ERROR_SOCKET_COMMUNICATION);
        }
        this.readOptions(Header.respMode);
        this.abort();
        return this.result;
    }

    public Result parseHeader(ArrayList<String> array) throws ScanException {
        Iterator<String> iterator = array.iterator();
        boolean flag = false;
        ThreatInfo threatinfo = new ThreatInfo();
        int i = 0;
        int j = 0;
        int k = 0;
        boolean flag1 = false;
        while (iterator.hasNext()) {
            String s1 = iterator.next();
            if (s1.startsWith("ICAP/1.0 200") || s1.startsWith("ICAP/1.0 204")) {
                this.result.status = ResultStatus.CLEAN;
                this.result.fileStatus = "clean";
                flag1 = true;
                continue;
            }
            if (s1.startsWith("ICAP/1.0 201")) {
                this.result.status = ResultStatus.INFECTED_REPLACED;
                this.result.fileStatus = "infected";
                continue;
            }
            if (s1.startsWith("ICAP/1.0 205") || s1.startsWith("ICAP/1.0 403")) {
                this.result.status = ResultStatus.INFECTED_UNREPAIRED;
                this.result.fileStatus = "UnRepaired";
                continue;
            }
            if (s1.startsWith("ICAP/1.0 500")) {
                this.result.status = ResultStatus.INTERNAL_SERVER_ERROR;
                this.result.fileStatus = "Error Scanning File";
                continue;
            }
            if (s1.startsWith("ICAP/1.0 502")) {
                this.result.status = ResultStatus.FILE_ACCESS_FAILED;
                this.result.fileStatus = "Fail File Access";
                continue;
            }
            if (s1.startsWith("ICAP/1.0 539") || s1.startsWith("ICAP/1.0 558")) {
                this.result.status = ResultStatus.NO_AV_LICENSE;
                this.result.fileStatus = "Abort No Av Scanning License ";
                break;
            }
            if (!s1.startsWith("X-Violations-Found") && !flag) continue;
            if (flag1 && Header.use_avscan) {
                this.result.status = ResultStatus.INFECTED_UNREPAIRED;
                this.result.fileStatus = "INFECTED";
            }
            if (!flag) {
                String s3 = s1.substring(20);
                this.result.totalInfection = j = Integer.parseInt(s3.trim());
                flag = true;
                continue;
            }
            if (k < j && i < 4) {
                if (i == 0) {
                    threatinfo = new ThreatInfo();
                    threatinfo.setfileName(s1.trim());
                    ++i;
                    continue;
                }
                if (i == 1) {
                    this.parseThreatDesc(s1.trim(), threatinfo);
                    ++i;
                    continue;
                }
                if (i == 2) {
                    threatinfo.setviolationId(s1.trim());
                    ++i;
                    continue;
                }
                if (i == 3) {
                    threatinfo.setDisposition(s1.trim());
                    this.result.threatArrayList.add(threatinfo);
                    ++k;
                    i = 0;
                }
            }
            if (k != j) continue;
            flag = false;
        }
        return this.result;
    }

    public void readOptions(String s) throws ScanException {
        String s1 = "";
        ISTagInfo istaginfo = new ISTagInfo();
        if (this.socketOutputStream == null) {
            try {
                this.socket = this.getConnection();
                this.socketOutputStream = this.getOutputStream();
                this.inputStream = this.socket.getInputStream();
            }
            catch (IOException ioexception) {
                throw new ScanException("Unable to open a stream to receive the data from the server.", ErrorCode.ERROR_INPUT_STREAM_OPEN);
            }
        }
        if (this.inputStream == null) {
            try {
                this.inputStream = this.socket.getInputStream();
            }
            catch (IOException ioexception1) {
                throw new ScanException("Unable to open a stream to receive the data from the server.", ErrorCode.ERROR_INPUT_STREAM_OPEN);
            }
        }
        BufferedReader bufferedreader = new BufferedReader(new InputStreamReader(this.inputStream));
        String s2 = Header.getOptionsHeader(s, this.socket);
        this.headerBytes = s2.getBytes();
        try {
            this.socketOutputStream.write(this.headerBytes);
        }
        catch (IOException ioexception2) {
            throw new ScanException(" Unable to send data to the Server.", ErrorCode.ERROR_ON_SERVER_WRITE);
        }
        do {
            try {
                s1 = bufferedreader.readLine();
                if (s1 == null) {
                    break;
                }
            }
            catch (IOException ioexception3) {
                throw new ScanException("Unable to read the response from the Server.", ErrorCode.ERROR_ON_SERVER_READ);
            }
            if (s1.startsWith("ISTag:")) {
                String s3 = s1.substring(8);
                istaginfo.setISTag(s3);
            }
            if (!s1.startsWith("X-Definition-Info:")) continue;
            String s4 = s1.substring(19);
            String s5 = s4.substring(0, 8);
            SimpleDateFormat simpledateformat = new SimpleDateFormat("yyyyMMdd");
            try {
                istaginfo.setDefDate(simpledateformat.parse(s5));
            }
            catch (ParseException parseexception) {
                throw new ScanException("Unable to parse date", ErrorCode.ERROR_ON_SERVER_READ);
            }
            istaginfo.setRevNo(s4.substring(9));
            this.isTagInfo[this.connectedIndex] = istaginfo;
            break;
        } while (!s1.startsWith("Encapsulated:") && s1 != null);
        this.result.setDefinitionDate(this.isTagInfo[this.connectedIndex].getdefDate());
        this.result.setDefinitionRevNumber(this.isTagInfo[this.connectedIndex].getRevNumber());
    }

    int offSetValue(String s, String s1) {
        int i = s.indexOf(s1);
        if (i == -1) {
            return -1;
        }
        int j = i + s1.length();
        int k = s.indexOf(44, j);
        int l = -1;
        if (k == -1) {
            l = s.length();
        }
        String s2 = l == -1 ? s.substring(j + 1, k) : s.substring(j + 1, l);
        return Integer.parseInt(s2.trim());
    }

    void parseThreatDesc(String s, ThreatInfo threatinfo) {
        int i = -1;
        int byte0 = 124;
        String s1 = " NonViralThreat=";
        threatinfo.setViolationName(s);
        threatinfo.setThreatCategory("");
        i = s.indexOf(byte0);
        if (i == -1) {
            return;
        }
        threatinfo.setViolationName(s.substring(0, i));
        i = s.indexOf(s1, i);
        if (i == -1) {
            return;
        }
        threatinfo.setThreatCategory(s.substring(i += s1.length()));
    }

    final void setFailRetryTime(int i) {
        this.failRetryTime = i;
    }

    final void setReadWriteTime(int i) {
        this.readWriteTime = i;
    }
}

