/*
 * Decompiled with CFR 0.152.
 */
package de.pontonconsulting.xmlpipe.messenger.filter;

import de.pontonconsulting.xmlpipe.config.SchemaData;
import de.pontonconsulting.xmlpipe.config.SchemataConfig;
import de.pontonconsulting.xmlpipe.cpp.OptionNotFoundException;
import de.pontonconsulting.xmlpipe.message.PayloadRecognizer;
import de.pontonconsulting.xmlpipe.message.XmlExtractor;
import de.pontonconsulting.xmlpipe.message.XpMessage;
import de.pontonconsulting.xmlpipe.messenger.database.DbException;
import de.pontonconsulting.xmlpipe.messenger.database.tables.MessageDAO;
import de.pontonconsulting.xmlpipe.messenger.database.tables.MessengerLog;
import de.pontonconsulting.xmlpipe.messenger.filter.BaseFilter;
import de.pontonconsulting.xmlpipe.messenger.filter.BaseFilterException;
import de.pontonconsulting.xmlpipe.messenger.filter.MessageRecognitionException;
import de.pontonconsulting.xmlpipe.messenger.filter.validate.XmlValidator;
import de.pontonconsulting.xmlpipe.uiconfig.UIConfig;
import de.pontonconsulting.xmlpipe.uioption.UIOption;
import java.io.File;
import java.util.Iterator;
import org.springframework.context.ApplicationContext;

public class ValidationFilter
extends BaseFilter<XmlValidator> {
    public static final String OPTION_PATH = "/validation";
    private static final UIOption[] OPTIONS = new UIOption[]{new UIOption("pipelineOption.filter.validation", "/validation", "boolean", Boolean.TRUE.toString(), "help_header_validation", "pipelineOption.filter.validation", "pipelineOption.agreement.help.filter.validation", "pipelineOption.profile.help.filter.validation", UIOption.NONE, true)};
    private XmlValidator _xmlValidator;
    private final MessageDAO messageDAO;
    private final XmlExtractor xmlExtractor;
    private final SchemataConfig schemataConfig;

    public ValidationFilter(MessengerLog messengerLog, UIConfig uiConfig, MessageDAO messageDAO, XmlExtractor xmlExtractor, SchemataConfig schemataConfig, ApplicationContext applicationContext) {
        super("ValidationFilter", messengerLog, uiConfig, applicationContext);
        this.messageDAO = messageDAO;
        this.xmlExtractor = xmlExtractor;
        this.schemataConfig = schemataConfig;
    }

    @Override
    protected Class<XmlValidator> getFilterPluginClass() {
        return XmlValidator.class;
    }

    @Override
    public void initFilter() throws BaseFilterException {
        super.initFilter();
        for (XmlValidator plugin : this._plugins) {
            if (!(plugin instanceof XmlValidator)) continue;
            this._xmlValidator = plugin;
        }
        if (this._xmlValidator == null) {
            throw new BaseFilterException(15000, "No XML Validator found.");
        }
    }

    @Override
    public void doFilter(XpMessage message) throws BaseFilterException {
        boolean notValidateMessageType;
        boolean validationEnabled = false;
        try {
            validationEnabled = Boolean.parseBoolean(message.getCommunication().getPipelineOptionValueForMessage(OPTION_PATH, message.getSchemaLocation()));
        }
        catch (OptionNotFoundException optionNotFoundException) {
            // empty catch block
        }
        boolean validateable = true;
        String messageType = message.getMessageType();
        String schemaSet = message.getSchemaSet();
        boolean notValidateSchemaSet = "ponton".equals(schemaSet);
        boolean bl = notValidateMessageType = "ACK".equals(messageType) || "PING".equals(messageType) || "PONG".equals(messageType) || "StatusRequest".equals(messageType) || "StatusResponse".equals(messageType);
        if (notValidateSchemaSet && notValidateMessageType) {
            validateable = false;
        } else {
            try {
                PayloadRecognizer.RecognizePayloadResult payloadResult;
                if (this.getLogger().isTraceEnabled()) {
                    this.getLogger().trace("Trying to identify the payload.");
                }
                if (!(payloadResult = message.recognizePayload()).isValid()) {
                    if (this.getLogger().isTraceEnabled()) {
                        this.getLogger().trace("Payload couldn't be identified..");
                    }
                    if (this.getLogger().isDebugEnabled()) {
                        this.getLogger().debug("Could not validate unknown message.");
                    }
                    this.messageLog(508, message.getDatabaseId(), message.getMessageId(), payloadResult.errorMessage());
                    throw new MessageRecognitionException(-1, payloadResult.errorMessage());
                }
                SchemaData schema = this.schemataConfig.getSchemaBySetTypeVersion(message.getSchemaSet(), message.getMessageType(), message.getMessageVersion());
                File payloadFile = message.getCurrentContentReference();
                this.xmlExtractor.readMissingDataFromPayload(payloadFile, schema, message);
                this.messageDAO.updateMessage(message);
            }
            catch (DbException dbException) {
                // empty catch block
            }
        }
        if (message.getCurrentContentReference() == null) {
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug("There is no payload, so we can not validate");
            }
        } else if (message.isAck()) {
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug("Acknowledgments are not validated.");
            }
        } else if (validationEnabled && validateable) {
            this.validate(message);
        } else if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("Validation is not activated in the agreement.");
        }
    }

    private void validate(XpMessage message) throws BaseFilterException {
        boolean pluginFound = false;
        Iterator it = this._plugins.iterator();
        while (it.hasNext() && !pluginFound) {
            XmlValidator validator = (XmlValidator)it.next();
            for (int i = 0; i < validator.getAcceptedContentTypes().length && !pluginFound; ++i) {
                if (!validator.getAcceptedContentTypes()[i].equalsIgnoreCase(message.getCurrentContentType())) continue;
                pluginFound = true;
                validator.doFilter(message);
            }
        }
        if (!pluginFound) {
            if (this.getLogger().isInfoEnabled()) {
                this.getLogger().info("No validation plugin found which is able to validate '{}' data. Trying to validate with the xml validator.", (Object)message.getCurrentContentType());
            }
            this._xmlValidator.doFilter(message);
        }
    }

    @Override
    public UIOption[] getUIOptions() {
        return OPTIONS;
    }

    public static UIOption[] getOptions() {
        return OPTIONS;
    }
}

