/*
 * Decompiled with CFR 0.152.
 */
package de.pontonconsulting.xmlpipe.messenger.filter;

import de.pontonconsulting.xmlpipe.cpp.OptionNotFoundException;
import de.pontonconsulting.xmlpipe.message.XpMessage;
import de.pontonconsulting.xmlpipe.messenger.database.tables.FileRefDAO;
import de.pontonconsulting.xmlpipe.messenger.database.tables.MessengerLog;
import de.pontonconsulting.xmlpipe.messenger.filter.BaseFilter;
import de.pontonconsulting.xmlpipe.messenger.filter.BaseFilterException;
import de.pontonconsulting.xmlpipe.messenger.filter.IDecompressor;
import de.pontonconsulting.xmlpipe.messenger.filter.IFilterPlugin;
import de.pontonconsulting.xmlpipe.messenger.filter.compress.CompressionException;
import de.pontonconsulting.xmlpipe.uiconfig.UIConfig;
import de.pontonconsulting.xmlpipe.uioption.UIOption;
import org.springframework.context.ApplicationContext;

public class DecompressionFilter
extends BaseFilter<IDecompressor> {
    private final FileRefDAO fileRefDAO;

    public DecompressionFilter(FileRefDAO fileRefDAO, MessengerLog messengerLog, UIConfig uiConfig, ApplicationContext applicationContext) {
        super("DecompressionFilter", messengerLog, uiConfig, applicationContext);
        this.fileRefDAO = fileRefDAO;
    }

    @Override
    protected Class<IDecompressor> getFilterPluginClass() {
        return IDecompressor.class;
    }

    @Override
    public void doFilter(XpMessage message) throws CompressionException, BaseFilterException {
        String usedCompression = message.getProcessingDirective("CompressionAlgorithm");
        this.getLogger().debug("CompressionAlgorithm in processing directives is: {}", (Object)usedCompression);
        String expectedCompression = null;
        try {
            expectedCompression = message.getCommunication().getPipelineOptionValueForMessage("/Compression", message.getSchemaLocation());
        }
        catch (OptionNotFoundException optionNotFoundException) {
            // empty catch block
        }
        if (usedCompression != null && expectedCompression == null) {
            String errorMsg = "Message should not be compressed, but is compressed using '" + usedCompression + "'.";
            this.messageLog(503, message.getDatabaseId(), message.getMessageId(), errorMsg);
            throw new CompressionException(16002, errorMsg);
        }
        if (usedCompression != null && expectedCompression != null && !expectedCompression.equals(usedCompression)) {
            String algorithmMismatchError = "Message is compressed using '" + usedCompression + "' algorithm, but '" + expectedCompression + "' algorithm is specified in agreement.";
            this.messageLog(503, message.getDatabaseId(), message.getMessageId(), algorithmMismatchError);
            this.getLogger().fatal(algorithmMismatchError);
            throw new CompressionException(16004, algorithmMismatchError);
        }
        if (expectedCompression != null && expectedCompression.length() > 0) {
            for (IFilterPlugin plugin : this._plugins) {
                if (!plugin.getOptionValue().equals(expectedCompression)) continue;
                try {
                    plugin.doFilter(message);
                    break;
                }
                catch (BaseFilterException bfe) {
                    if (bfe instanceof CompressionException) {
                        throw (CompressionException)bfe;
                    }
                    throw bfe;
                }
            }
        } else {
            this.getLogger().debug("Message is not compressed");
        }
        if (message.getCurrentContentReference() != null) {
            this.fileRefDAO.insertMessageFileReference(message.getDatabaseId(), message.getCurrentContentReference().getParentFile(), message.getCurrentContentReference().getName(), message.getCurrentContentType());
        }
    }

    @Override
    public UIOption[] getUIOptions() {
        UIOption[] options = new UIOption[]{};
        return options;
    }
}

