/*
 * Decompiled with CFR 0.152.
 */
package de.pontonconsulting.xmlpipe.messenger.filter;

import de.pontonconsulting.xmlpipe.config.uiconfig.OptionType;
import de.pontonconsulting.xmlpipe.message.XpMessage;
import de.pontonconsulting.xmlpipe.messenger.database.tables.MessengerLog;
import de.pontonconsulting.xmlpipe.messenger.filter.BaseFilterException;
import de.pontonconsulting.xmlpipe.messenger.filter.IFilterPlugin;
import de.pontonconsulting.xmlpipe.uiconfig.UIConfig;
import de.pontonconsulting.xmlpipe.uioption.UIOption;
import jakarta.annotation.PostConstruct;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.context.ApplicationContext;

public abstract class BaseFilter<S extends IFilterPlugin> {
    private Logger _log = null;
    private String _filterName = null;
    protected final MessengerLog _messengerLog;
    private final UIConfig _uiConfig;
    protected List<S> _plugins;
    protected final ApplicationContext applicationContext;

    public BaseFilter(String filterName, MessengerLog messengerLog, UIConfig uiConfig, ApplicationContext applicationContext) {
        this._filterName = filterName;
        this._messengerLog = messengerLog;
        this._uiConfig = uiConfig;
        this.applicationContext = applicationContext;
    }

    protected abstract Class<S> getFilterPluginClass();

    private final List<S> findPlugins(Class<S> clazz) {
        Map pluginMap = this.applicationContext.getBeansOfType(clazz);
        ArrayList<IFilterPlugin> plugins = new ArrayList<IFilterPlugin>();
        for (IFilterPlugin plugin : pluginMap.values()) {
            this._log.debug("filter-plugin found: {}", (Object)plugin.getClass().getSimpleName());
            plugins.add(plugin);
        }
        return plugins;
    }

    protected String updateCurrentPayloadFilename(XpMessage xpMessage, boolean inbound) throws IOException {
        if (inbound) {
            File currentContentReference = xpMessage.getCurrentContentReference();
            String payloadFilename = currentContentReference.getName();
            if (payloadFilename.endsWith(this.getDefaultExtension())) {
                payloadFilename = payloadFilename.substring(0, payloadFilename.length() - this.getDefaultExtension().length());
            } else {
                File processedPayload = new File(currentContentReference.getParent(), payloadFilename + this.getDefaultExtension());
                if (!currentContentReference.renameTo(processedPayload)) {
                    throw new IOException("Could not rename file " + currentContentReference.getAbsolutePath() + " to " + String.valueOf(processedPayload));
                }
                xpMessage.setCurrentContentReference(processedPayload);
                this.updateSignatureFile(xpMessage, currentContentReference, processedPayload);
            }
            return payloadFilename;
        }
        throw new IllegalAccessError("Don't use this method for the outbound direction.");
    }

    protected void updateSignatureFile(XpMessage xpMessage, File oldPayloadFile, File newPayloadFile) throws IOException {
        final String oldPayloadFilename = oldPayloadFile.getName();
        String newPayloadFilename = newPayloadFile.getName();
        File[] sigFiles = oldPayloadFile.getParentFile().listFiles(new FileFilter(){

            @Override
            public boolean accept(File file) {
                return file.getName().equals(oldPayloadFilename + ".p7s") || file.getName().startsWith(oldPayloadFilename) && file.getName().endsWith(".rsa") || file.getName().equals(oldPayloadFilename + ".p7smime");
            }
        });
        if (sigFiles != null) {
            for (File oldSignatureFile : sigFiles) {
                String oldSignatureFilename = oldSignatureFile.getName();
                File newSignatureFile = new File(newPayloadFile.getParent(), oldSignatureFilename.replace(oldPayloadFilename, newPayloadFilename));
                if (!oldSignatureFile.renameTo(newSignatureFile)) {
                    throw new IOException("Could not rename file " + oldSignatureFile.getAbsolutePath() + " to " + newSignatureFile.getAbsolutePath());
                }
                if (!this.getLogger().isDebugEnabled()) continue;
                this.getLogger().debug("Renamed signature file from '" + oldSignatureFilename + "' to '" + newSignatureFile.getName() + "'.");
            }
        }
    }

    protected void updateProcessedOriginalFilename(XpMessage xpMessage, boolean inbound) {
        String extention = this.getDefaultExtension();
        Object processedOriginalFilename = xpMessage.getProcessingDirective("ProcessedOriginalFilename");
        if (inbound) {
            if (((String)processedOriginalFilename).endsWith(extention)) {
                processedOriginalFilename = ((String)processedOriginalFilename).substring(0, ((String)processedOriginalFilename).length() - extention.length());
                xpMessage.setProcessingDirective("ProcessedOriginalFilename", (String)processedOriginalFilename);
                if (this._log.isTraceEnabled()) {
                    this._log.trace("Set pocessing directive ProcessedOriginalFilename to {}", processedOriginalFilename);
                }
            }
        } else {
            processedOriginalFilename = (String)processedOriginalFilename + extention;
            xpMessage.setProcessingDirective("ProcessedOriginalFilename", (String)processedOriginalFilename);
            if (this._log.isTraceEnabled()) {
                this._log.trace("Set pocessing directive ProcessedOriginalFilename to {}", processedOriginalFilename);
            }
        }
    }

    protected String getDefaultValueFromUIConfig(String optionPath, String defaultValue) {
        String result = null;
        for (String pipelineId : this._uiConfig.getAllDefinedPipelineIds()) {
            OptionType option = this._uiConfig.getPipelineOptionConfig(pipelineId, optionPath);
            if (option == null || option.getDefaultValue() == null || option.getDefaultValue().length() <= 0) continue;
            result = option.getDefaultValue();
            break;
        }
        if (result == null || result.isEmpty()) {
            result = defaultValue;
        }
        return result;
    }

    protected String getDefaultExtension() {
        throw new IllegalAccessError("This method is not overridden by the subclass.");
    }

    @PostConstruct
    public void initFilter() throws BaseFilterException {
        this.initLogger();
        Class<S> clazz = this.getFilterPluginClass();
        this._plugins = clazz == null ? new ArrayList<S>(0) : this.findPlugins(this.getFilterPluginClass());
    }

    public abstract void doFilter(XpMessage var1) throws BaseFilterException;

    public abstract UIOption[] getUIOptions();

    private void initLogger() {
        this._log = LogManager.getLogger((String)("Messenger." + this._filterName));
    }

    public void messageLog(int textId, long messageDataID, String transferId, String additionalInfo) {
        try {
            this._messengerLog.log2db(textId, messageDataID, additionalInfo);
        }
        catch (Exception e) {
            this._log.warn("{}  message:{} code:{} text:{}", (Object)e.getMessage(), (Object)transferId, (Object)textId, (Object)additionalInfo);
        }
    }

    public Logger getLogger() {
        return this._log;
    }
}

